/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching;

import Alachisoft.NCache.Caching.OperationID;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Common.ICloneable;
import Alachisoft.NCache.Persistence.EventType;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.io.Serializable;
import tangible.DotNetToJavaStringHelper;

public class EventId
implements Cloneable,
ICloneable,
InternalCompactSerializable,
Serializable {
    private String _eventUniqueId;
    private long _operationCounter;
    private int _eventCounter;
    private QueryChangeType _queryChangeType = QueryChangeType.None;
    private EventType _eventType;
    private String _queryId;
    private int _hashCode = -1;

    public EventId() {
    }

    public EventId(String eventUniqueId, long operationCounter, int eventCounter) {
        this._eventUniqueId = eventUniqueId;
        this._operationCounter = operationCounter;
        this._eventCounter = eventCounter;
    }

    public static EventId CreateEventId(OperationID opId) {
        EventId eventId = new EventId();
        eventId._eventUniqueId = opId.getOperationId();
        eventId._operationCounter = opId.getOpCounter();
        return eventId;
    }

    public final String getEventUniqueID() {
        return this._eventUniqueId;
    }

    public final void setEventUniqueID(String value) {
        this._eventUniqueId = value;
    }

    public final long getOperationCounter() {
        return this._operationCounter;
    }

    public final void setOperationCounter(long value) {
        this._operationCounter = value;
    }

    public final int getEventCounter() {
        return this._eventCounter;
    }

    public final void setEventCounter(int value) {
        this._eventCounter = value;
    }

    public final QueryChangeType getQueryChangeType() {
        return this._queryChangeType;
    }

    public final void setQueryChangeType(QueryChangeType value) {
        this._queryChangeType = value;
    }

    public final EventType getEventType() {
        return this._eventType;
    }

    public final void setEventType(EventType value) {
        this._eventType = value;
    }

    public final String getQueryId() {
        return this._queryId;
    }

    public final void setQueryId(String value) {
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)value)) {
            this._queryId = value;
        }
    }

    public int hashCode() {
        if (this._hashCode == -1 && this._eventUniqueId == null) {
            return super.hashCode();
        }
        if (this._hashCode == -1) {
            this._hashCode = (this._eventUniqueId + new Integer(this._eventCounter).toString() + ":" + new Long(this.getOperationCounter()).toString() + ":" + this._eventType.toString() + ":" + this._queryChangeType.toString() + ":" + this._queryId).hashCode();
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        EventId eventId = (EventId)obj;
        return this.getEventUniqueID().equals(eventId.getEventUniqueID()) && this.getEventCounter() == eventId.getEventCounter() && this.getOperationCounter() == eventId.getOperationCounter() && this.getQueryChangeType() == eventId.getQueryChangeType() && this.getEventType() == eventId.getEventType() && this._queryId.equals(eventId._queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object clone() {
        EventId ei = new EventId();
        EventId eventId = this;
        synchronized (eventId) {
            ei._eventUniqueId = this._eventUniqueId;
            ei._operationCounter = this._operationCounter;
            ei._eventCounter = this._eventCounter;
            ei._queryChangeType = this._queryChangeType;
            ei._eventType = this._eventType;
            ei._queryId = this._queryId;
        }
        return ei;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._eventCounter = reader.ReadInt32();
        this._eventUniqueId = (String)reader.ReadObject();
        this._operationCounter = reader.ReadInt64();
        this._eventType = (EventType)((Object)reader.ReadObject());
        this._queryChangeType = (QueryChangeType)((Object)reader.ReadObject());
        this._queryId = (String)reader.ReadObject();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(this._eventCounter);
        writer.WriteObject((Object)this._eventUniqueId);
        writer.Write(this._operationCounter);
        writer.Write(this._eventType.getValue());
        writer.Write(this._queryChangeType.getValue());
        writer.WriteObject((Object)this._queryId);
    }
}

