/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.EvictionPolicies.IEvictionPolicy;
import Alachisoft.NCache.Caching.EvictionPolicies.LFUEvictionPolicy;
import Alachisoft.NCache.Caching.EvictionPolicies.LRUEvictionPolicy;
import Alachisoft.NCache.Caching.EvictionPolicies.PriorityEvictionPolicy;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.util.Map;

public class EvictionPolicyFactory {
    public static IEvictionPolicy CreateDefaultEvictionPolicy() {
        return null;
    }

    public static IEvictionPolicy CreateEvictionPolicy(Map properties) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            float evictRatio = 0.0f;
            if (properties.containsKey("evict-ratio")) {
                evictRatio = Float.parseFloat((String)properties.get("evict-ratio"));
            }
            IEvictionPolicy evictionPolicy = null;
            String scheme = "";
            if (LicenseManager.isEnterprise()) {
                scheme = String.valueOf(properties.get("class"));
                scheme = scheme.toLowerCase();
            } else {
                scheme = "priority";
            }
            Map schemeProps = (Map)properties.get(scheme);
            if (scheme.equals("lru")) {
                evictionPolicy = new LRUEvictionPolicy(schemeProps, evictRatio);
            } else if (scheme.equals("lfu")) {
                evictionPolicy = new LFUEvictionPolicy(schemeProps, evictRatio);
            } else if (scheme.equals("priority")) {
                evictionPolicy = new PriorityEvictionPolicy(schemeProps, evictRatio);
            }
            if (evictionPolicy == null) {
                throw new ConfigurationException("Invalid Eviction Policy: " + scheme);
            }
            return evictionPolicy;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("EvictionPolicyFactory.CreateEvictionPolicy(): " + e.toString());
        }
    }
}

