/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.EvictionPolicies.CounterHint;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionIndex;
import Alachisoft.NCache.Caching.EvictionPolicies.IEvictionPolicy;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.ServicePropValues;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import tangible.RefObject;

public class LFUEvictionPolicy
implements IEvictionPolicy {
    private EvictionIndex _index;
    private float _ratio = 0.25f;
    private int _minHint;
    private int _maxHint;
    private long _sleepInterval = 0L;
    private int _removeThreshhold = 10;
    private long totalEvicted;

    public LFUEvictionPolicy() {
        this._sleepInterval = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveDelay);
        this._removeThreshhold = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveSize);
        this.Initialize();
    }

    public LFUEvictionPolicy(Map properties, float ratio) {
        this._ratio = ratio / 100.0f;
        this.Initialize();
    }

    private void Initialize() {
        this._index = new EvictionIndex();
        this._maxHint = 1;
        this._minHint = 1;
    }

    @Override
    public final EvictionHint CompatibleHint(EvictionHint eh) {
        if (eh != null && eh instanceof CounterHint) {
            return eh;
        }
        return new CounterHint();
    }

    @Override
    public void Execute(CacheBase cache, CacheRuntimeContext context, long evictSize) {
        OperationContext lfuEvictionOperationContext;
        int notifThreshold = 30720;
        if (context.getNCacheLog().getIsInfoEnabled()) {
            try {
                context.getNCacheLog().Info("LFU LocalCache.Evict()", "Cache Size: {0}" + new Long(cache.getCount()).toString());
            }
            catch (CacheException cacheException) {
                context.getNCacheLog().Info("LFU LocalCache.Evict()", "Logging cache count throws Exception: " + cacheException.getMessage());
            }
        }
        this._sleepInterval = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveDelay);
        this._removeThreshhold = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveSize);
        Date startTime = new Date();
        ArrayList selectedKeys = this.GetSelectedKeys(cache, (long)Math.ceil((float)evictSize * this._ratio));
        Date endTime = new Date();
        try {
            if (context.getNCacheLog().getIsInfoEnabled()) {
                context.getNCacheLog().Info("LocalCache.Evict()", String.format("Time Span for {0} Items: " + TimeSpan.subtract((Date)endTime, (Date)startTime), selectedKeys.size()));
            }
        }
        catch (IllegalArgumentException argumentException) {
            context.getNCacheLog().Info("LocalCache.Event", "TimeSpan.Subtract failed");
        }
        startTime = new Date();
        Cache rootCache = context.getCacheRoot();
        ArrayList keysTobeRemoved = new ArrayList();
        ArrayList dependentItems = new ArrayList();
        ArrayList removedItems = null;
        this.totalEvicted += (long)selectedKeys.size();
        Iterator e = selectedKeys.iterator();
        int removedThreshhold = this._removeThreshhold / 300;
        int remIteration = 0;
        while (e.hasNext()) {
            Object key = e.next();
            keysTobeRemoved.add(key);
            if (keysTobeRemoved.size() % 300 != 0) continue;
            try {
                lfuEvictionOperationContext = new OperationContext();
                lfuEvictionOperationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                lfuEvictionOperationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                Object tempVar = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Underused, false, lfuEvictionOperationContext);
                removedItems = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
                context.PerfStatsColl.incrementEvictPerSecStatsBy(keysTobeRemoved.size());
            }
            catch (Exception ex) {
                context.getNCacheLog().Error("LfuEvictionPolicy.Execute", "an error occured while removing items. Error " + ex.toString());
            }
            keysTobeRemoved.clear();
            if (removedItems != null && removedItems.size() > 0) {
                dependentItems.addAll(removedItems);
            }
            if (++remIteration < removedThreshhold) continue;
            try {
                Thread.sleep(this._sleepInterval * 1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            remIteration = 0;
        }
        if (keysTobeRemoved.size() > 0) {
            try {
                OperationContext lfuEvictionOperationContext2 = new OperationContext();
                lfuEvictionOperationContext2.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                lfuEvictionOperationContext2.Add(OperationContextFieldName.RaiseCQNotification, true);
                Object tempVar2 = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Underused, false, lfuEvictionOperationContext2);
                removedItems = (ArrayList)(tempVar2 instanceof ArrayList ? tempVar2 : null);
                context.PerfStatsColl.incrementEvictPerSecStatsBy(keysTobeRemoved.size());
                if (removedItems != null && removedItems.size() > 0) {
                    dependentItems.addAll(removedItems);
                }
            }
            catch (Exception ex) {
                context.getNCacheLog().Error("LfuEvictionPolicy.Execute", "an error occured while removing items. Error " + ex.toString());
            }
        }
        if (dependentItems.size() > 0) {
            ArrayList removableList = new ArrayList();
            if (rootCache != null) {
                for (Object depenentItme : dependentItems) {
                    if (depenentItme == null) continue;
                    removableList.add(depenentItme);
                    if (removableList.size() % 100 != 0) continue;
                    try {
                        OperationContext lfuEvictionOperationContext3 = new OperationContext();
                        lfuEvictionOperationContext3.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        lfuEvictionOperationContext3.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Underused, true, lfuEvictionOperationContext3);
                        context.PerfStatsColl.incrementEvictPerSecStatsBy(removableList.size());
                    }
                    catch (Exception exc) {
                        context.getNCacheLog().Error("LfuEvictionPolicy.Execute", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                }
                if (removableList.size() > 0) {
                    try {
                        lfuEvictionOperationContext = new OperationContext();
                        lfuEvictionOperationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        lfuEvictionOperationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Underused, true, lfuEvictionOperationContext);
                        context.PerfStatsColl.incrementEvictPerSecStatsBy(removableList.size());
                    }
                    catch (Exception exc) {
                        context.getNCacheLog().Error("LfuEvictionPolicy.Execute", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                }
            }
        }
    }

    @Override
    public float getEvictRatio() {
        return this._ratio;
    }

    @Override
    public void setEvictRatio(float value) {
        this._ratio = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Notify(Object key, EvictionHint oldhint, EvictionHint newHint) {
        Object object = this._index.getSyncRoot();
        synchronized (object) {
            EvictionHint hint;
            EvictionHint evictionHint = hint = oldhint == null ? newHint : oldhint;
            if (this._index != null && key != null && hint != null) {
                short indexKey = ((CounterHint)hint).getCount();
                if (this._index.Contains(indexKey, key)) {
                    long previous = -1L;
                    long next = -1L;
                    RefObject tempRef_previous = new RefObject((Object)previous);
                    RefObject tempRef_next = new RefObject((Object)next);
                    this._index.Remove(indexKey, key, (RefObject<Long>)tempRef_previous, (RefObject<Long>)tempRef_next);
                    previous = (Long)tempRef_previous.argvalue;
                    next = (Long)tempRef_next.argvalue;
                    hint = newHint == null ? oldhint : newHint;
                    hint.Update();
                    indexKey = ((CounterHint)hint).getCount();
                    this._index.Insert(indexKey, key, previous, next);
                } else {
                    this._index.Insert(indexKey, key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Remove(Object key, EvictionHint hint) {
        if (hint == null) {
            return;
        }
        Object object = this._index.getSyncRoot();
        synchronized (object) {
            long indexKey = ((CounterHint)hint).getCount();
            this._index.Remove(indexKey, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Clear() {
        Object object = this._index.getSyncRoot();
        synchronized (object) {
            this._index.Clear();
        }
    }

    private ArrayList GetSelectedKeys(CacheBase cache, long evictSize) {
        return this._index.GetSelectedKeys(cache, evictSize);
    }
}

