/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.IEvictionPolicy;
import Alachisoft.NCache.Caching.EvictionPolicies.PriorityEvictionHint;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.ServicePropValues;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PriorityEvictionPolicy
implements IEvictionPolicy {
    private CacheItemPriority _priority = CacheItemPriority.Normal;
    private HashMap[] _index;
    private float _ratio = 0.25f;
    private long _sleepInterval = 0L;
    private int _removeThreshhold = 10;

    public PriorityEvictionPolicy() {
        this.Initialize();
    }

    public PriorityEvictionPolicy(Map properties, float ratio) {
        if (properties != null && properties.containsKey("default-value")) {
            String defaultValue = (String)properties.get("default-value");
            this._priority = PriorityEvictionPolicy.GetPriorityValue(defaultValue);
        }
        if (ServicePropValues.CacheServer_EvictionBulkRemoveDelay != null) {
            this._sleepInterval = Long.decode(ServicePropValues.CacheServer_EvictionBulkRemoveDelay) * 1000L;
        }
        if (ServicePropValues.CacheServer_EvictionBulkRemoveSize != null) {
            this._removeThreshhold = Integer.decode(ServicePropValues.CacheServer_EvictionBulkRemoveSize);
        }
        this._sleepInterval = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveDelay);
        this._removeThreshhold = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveSize);
        this._ratio = ratio / 100.0f;
        this.Initialize();
    }

    private static CacheItemPriority GetPriorityValue(String priority) {
        if ((priority = priority.toLowerCase()).equals("notremovable")) {
            return CacheItemPriority.NotRemovable;
        }
        if (priority.equals("high")) {
            return CacheItemPriority.High;
        }
        if (priority.equals("above-normal")) {
            return CacheItemPriority.AboveNormal;
        }
        if (priority.equals("below-normal")) {
            return CacheItemPriority.BelowNormal;
        }
        if (priority.equals("low")) {
            return CacheItemPriority.Low;
        }
        return CacheItemPriority.Normal;
    }

    private void Initialize() {
        this._index = new HashMap[5];
    }

    @Override
    public final EvictionHint CompatibleHint(EvictionHint eh) {
        if (eh != null && eh instanceof PriorityEvictionHint) {
            return eh;
        }
        return new PriorityEvictionHint(this._priority);
    }

    @Override
    public float getEvictRatio() {
        return this._ratio;
    }

    @Override
    public void setEvictRatio(float value) {
        this._ratio = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void Notify(Object key, EvictionHint oldhint, EvictionHint newHint) {
        CacheItemPriority newPriority;
        CacheItemPriority oldPriority;
        EvictionHint hint = newHint;
        if (hint == null) return;
        CacheItemPriority hintPriority = ((PriorityEvictionHint)hint).getPriority();
        if (hintPriority == CacheItemPriority.Default) {
            hintPriority = this._priority;
            ((PriorityEvictionHint)hint).setPriority(this._priority);
        }
        if (oldhint != null && (oldPriority = ((PriorityEvictionHint)oldhint).getPriority()) != (newPriority = ((PriorityEvictionHint)newHint).getPriority())) {
            this.Remove(key, oldhint);
        }
        HashMap[] hashMapArray = this._index;
        synchronized (this._index) {
            switch (hintPriority) {
                case Low: {
                    if (this._index[0] == null) {
                        this._index[0] = new HashMap(25000, 0.7f);
                    }
                    this._index[0].put(key, hint);
                    break;
                }
                case BelowNormal: {
                    if (this._index[1] == null) {
                        this._index[1] = new HashMap(25000, 0.7f);
                    }
                    this._index[1].put(key, hint);
                    break;
                }
                case Normal: {
                    if (this._index[2] == null) {
                        this._index[2] = new HashMap(25000, 0.7f);
                    }
                    this._index[2].put(key, hint);
                    break;
                }
                case AboveNormal: {
                    if (this._index[3] == null) {
                        this._index[3] = new HashMap(25000, 0.7f);
                    }
                    this._index[3].put(key, hint);
                    break;
                }
                case High: {
                    if (this._index[4] == null) {
                        this._index[4] = new HashMap(25000, 0.7f);
                    }
                    this._index[4].put(key, hint);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void Execute(CacheBase cache, CacheRuntimeContext context, long evictSize) {
        OperationContext priorityEvictionOperationContext;
        int notifThreshold = 30720;
        ILogger NCacheLog = cache.getContext().getNCacheLog();
        if (NCacheLog.getIsInfoEnabled()) {
            try {
                NCacheLog.Info("LocalCache.Evict()", "Cache Size: {0}" + new Long(cache.getCount()).toString());
            }
            catch (CacheException cacheException) {
                context.getNCacheLog().Info("PriorityEvictionPolicy LocalCache.Evict()", "Logging cache count throws Exception: " + cacheException.getMessage());
            }
        }
        this._sleepInterval = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveDelay);
        this._removeThreshhold = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveSize);
        Date startTime = new Date();
        ArrayList selectedKeys = this.GetSelectedKeys(cache, (long)Math.ceil((float)evictSize * this._ratio));
        Date endTime = new Date();
        if (NCacheLog.getIsInfoEnabled()) {
            try {
                NCacheLog.Info("LocalCache.Evict()", String.format("Time Span for {0} Items: " + TimeSpan.subtract((Date)endTime, (Date)startTime), selectedKeys.size()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        startTime = new Date();
        Cache rootCache = context.getCacheRoot();
        ArrayList keysTobeRemoved = new ArrayList();
        ArrayList dependentItems = new ArrayList();
        ArrayList removedItems = null;
        Iterator e = selectedKeys.iterator();
        int removedThreshhold = this._removeThreshhold / 300;
        int remIteration = 0;
        while (e.hasNext()) {
            Object key = e.next();
            if (key == null) continue;
            keysTobeRemoved.add(key);
            if (keysTobeRemoved.size() % 300 != 0) continue;
            try {
                priorityEvictionOperationContext = new OperationContext();
                priorityEvictionOperationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                priorityEvictionOperationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                Object tempVar = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Underused, false, priorityEvictionOperationContext);
                removedItems = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
                context.PerfStatsColl.incrementEvictPerSecStatsBy(keysTobeRemoved.size());
            }
            catch (Exception ex) {
                NCacheLog.Error("PriorityEvictionPolicy.Execute", "an error occured while removing items. Error " + ex.toString());
            }
            keysTobeRemoved.clear();
            if (removedItems != null && removedItems.size() > 0) {
                dependentItems.addAll(removedItems);
            }
            if (++remIteration < removedThreshhold) continue;
            try {
                Thread.sleep(this._sleepInterval * 1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            remIteration = 0;
        }
        if (keysTobeRemoved.size() > 0) {
            try {
                OperationContext priorityEvictionOperationContext2 = new OperationContext();
                priorityEvictionOperationContext2.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                priorityEvictionOperationContext2.Add(OperationContextFieldName.RaiseCQNotification, true);
                Object tempVar2 = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Underused, false, priorityEvictionOperationContext2);
                removedItems = (ArrayList)(tempVar2 instanceof ArrayList ? tempVar2 : null);
                context.PerfStatsColl.incrementEvictPerSecStatsBy(keysTobeRemoved.size());
                if (removedItems != null && removedItems.size() > 0) {
                    dependentItems.addAll(removedItems);
                }
            }
            catch (Exception ex) {
                NCacheLog.Error("PriorityEvictionPolicy.Execute", "an error occured while removing items. Error " + ex.toString());
            }
        }
        if (dependentItems.size() > 0) {
            ArrayList removableList = new ArrayList();
            if (rootCache != null) {
                for (Object depenentItme : dependentItems) {
                    if (depenentItme == null) continue;
                    removableList.add(depenentItme);
                    if (removableList.size() % 100 != 0) continue;
                    try {
                        OperationContext priorityEvictionOperationContext3 = new OperationContext();
                        priorityEvictionOperationContext3.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        priorityEvictionOperationContext3.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Underused, true, priorityEvictionOperationContext3);
                        context.PerfStatsColl.incrementEvictPerSecStatsBy(removableList.size());
                    }
                    catch (Exception exc) {
                        NCacheLog.Error("PriorityEvictionPolicy.Execute", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                }
                if (removableList.size() > 0) {
                    try {
                        priorityEvictionOperationContext = new OperationContext();
                        priorityEvictionOperationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        priorityEvictionOperationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Underused, true, priorityEvictionOperationContext);
                        context.PerfStatsColl.incrementEvictPerSecStatsBy(removableList.size());
                    }
                    catch (Exception exc) {
                        NCacheLog.Error("PriorityEvictionPolicy.Execute", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList GetSelectedKeys(CacheBase cache, long evictSize) {
        ArrayList<Object> selectedKeys = new ArrayList<Object>(100);
        long sizeCount = 0L;
        int prvsSize = 0;
        Object key = null;
        boolean selectionComplete = false;
        HashMap[] hashMapArray = this._index;
        synchronized (this._index) {
            block3: for (int i = 0; i < 5 && !selectionComplete; ++i) {
                HashMap currentIndex = this._index[i];
                if (currentIndex == null) continue;
                for (Map.Entry pair : currentIndex.entrySet()) {
                    key = pair.getKey();
                    if (key == null) continue;
                    int itemSize = cache.GetItemSize(key);
                    if (sizeCount + (long)itemSize >= evictSize && sizeCount > 0L) {
                        if (evictSize - sizeCount > (long)itemSize + sizeCount - evictSize) {
                            selectedKeys.add(key);
                        }
                        selectionComplete = true;
                        continue block3;
                    }
                    selectedKeys.add(key);
                    sizeCount += (long)itemSize;
                    prvsSize = itemSize;
                }
            }
            // ** MonitorExit[var10_8] (shouldn't be in output)
            return selectedKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Remove(Object key, EvictionHint hint) {
        HashMap[] hashMapArray = this._index;
        synchronized (this._index) {
            if (this._index != null) {
                for (int i = 0; i < 5; ++i) {
                    if (this._index[i] == null || !this._index[i].containsKey(key)) continue;
                    this._index[i].remove(key);
                    if (!this._index[i].isEmpty()) continue;
                    this._index[i] = null;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Clear() {
        HashMap[] hashMapArray = this._index;
        synchronized (this._index) {
            if (this._index != null) {
                for (int i = 0; i < 5; ++i) {
                    if (this._index[i] == null) continue;
                    this._index[i].clear();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

