/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching;

import java.util.HashMap;
import java.util.LinkedList;

public class KeyBasedLockManager {
    private HashMap _lockTable = new HashMap();
    private Object _sync_mutex = new Object();
    private boolean _globalLock;
    private boolean _waiting4globalLock;
    private LockInfo _globalLockInfo;
    private LockingContext _globalLockingContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AcquireLock(Object key) throws InterruptedException {
        boolean lockAcquired;
        LockInfo info = null;
        Object object = this._sync_mutex;
        synchronized (object) {
            while (!(!this._globalLock && !this._waiting4globalLock || this._globalLock && this._globalLockingContext != null && this._globalLockingContext.getIsCurrentContext())) {
                this._sync_mutex.wait();
            }
            if (!this._lockTable.containsKey(key)) {
                this._lockTable.put(key, new LockInfo());
            } else {
                info = this._lockTable.get(key) instanceof LockInfo ? this._lockTable.get(key) : null;
            }
        }
        if (info != null && !(lockAcquired = info.AddWaitingThread())) {
            this.AcquireLock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ReleaseLock(Object key) {
        Object object = this._sync_mutex;
        synchronized (object) {
            LockInfo info;
            if (this._lockTable.containsKey(key) && !(info = (LockInfo)(this._lockTable.get(key) instanceof LockInfo ? this._lockTable.get(key) : null)).PulseWaitingThread()) {
                this._lockTable.remove(key);
            }
            if (this._waiting4globalLock && this._lockTable.isEmpty()) {
                this._globalLock = true;
                this._waiting4globalLock = false;
                this._globalLockInfo.PulseWaitingThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AcquireGlobalLock() throws InterruptedException {
        Object object = this._sync_mutex;
        synchronized (object) {
            if (this._globalLockingContext != null && this._globalLockingContext.getIsCurrentContext()) {
                this._globalLockingContext.IncrementRefCount();
                return;
            }
            while (this._globalLock || this._waiting4globalLock) {
                this._sync_mutex.wait();
            }
            if (this._lockTable.isEmpty()) {
                this._globalLock = true;
            } else {
                this._waiting4globalLock = true;
                this._globalLockInfo = new LockInfo();
            }
        }
        if (this._globalLockInfo != null && !this._globalLock) {
            this._globalLockInfo.AddWaitingThread();
        }
        this._globalLockingContext = new LockingContext();
        this._globalLockingContext.IncrementRefCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ReleaseGlobalLock() {
        Object object = this._sync_mutex;
        synchronized (object) {
            if (this._globalLockingContext.getIsCurrentContext() && this._globalLockingContext.DecrementRefCount()) {
                this._globalLock = false;
                this._globalLockInfo = null;
                this._globalLockingContext = null;
                this._sync_mutex.notifyAll();
            }
        }
    }

    private static class LockingContext {
        private Thread _currentThread = Thread.currentThread();
        private int _refCount;

        public final boolean getIsCurrentContext() {
            boolean isCurrentThread = this._currentThread.equals(Thread.currentThread());
            return isCurrentThread;
        }

        public final void IncrementRefCount() {
            ++this._refCount;
        }

        public final boolean DecrementRefCount() {
            --this._refCount;
            return this._refCount == 0;
        }
    }

    private static class LockInfo {
        private LinkedList _queue = new LinkedList();
        private boolean _lastPulsed;

        private LockInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean AddWaitingThread() throws InterruptedException {
            Object syncObject;
            Object object = syncObject = new Object();
            synchronized (object) {
                LinkedList linkedList = this._queue;
                synchronized (linkedList) {
                    if (this._lastPulsed) {
                        return false;
                    }
                    this._queue.offer(syncObject);
                }
                syncObject.wait();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean PulseWaitingThread() {
            Object syncObject = null;
            LinkedList linkedList = this._queue;
            synchronized (linkedList) {
                if (this._queue.isEmpty()) {
                    this._lastPulsed = true;
                    return false;
                }
                syncObject = this._queue.poll();
            }
            linkedList = syncObject;
            synchronized (linkedList) {
                syncObject.notify();
            }
            return true;
        }

        public final int getCount() {
            return this._queue.size();
        }
    }
}

