/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.HashStore;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ActiveQueryEvaluationIndex
extends AttributeIndex
implements Serializable {
    public ActiveQueryEvaluationIndex() {
    }

    public ActiveQueryEvaluationIndex(String cacheName, String type) {
        super(cacheName, type);
    }

    public ActiveQueryEvaluationIndex(ArrayList attribList, String cacheName, String type) {
        super(attribList, cacheName, type);
    }

    @Override
    public void setSharedTypes(ArrayList<AttributeIndex> list) {
        super.setSharedTypes(list);
    }

    @Override
    public void setCommonRBStores(HashMap commonRBStores) {
        super.setCommonRBStores(commonRBStores);
    }

    @Override
    public void Initialize(ArrayList attribList) {
        HashStore store = null;
        if (attribList != null && attribList.size() > 0) {
            Iterator e = attribList.iterator();
            while (e.hasNext()) {
                String attribName = e.next().toString();
                if (this._commonRBStores != null && this._commonRBStores.containsKey(this._type + ":" + attribName)) {
                    HashStore commonStore = (HashStore)this._commonRBStores.get(this._type + ":" + attribName);
                    this._indexTable.put(attribName, commonStore);
                    continue;
                }
                store = new HashStore();
                this._indexTable.put(attribName, store);
            }
            if (this._commonRBStores != null && this._commonRBStores.containsKey("$Tag$")) {
                store = (HashStore)this._commonRBStores.get("$Tag$");
                this._indexTable.put("$Tag$", store);
            } else {
                store = new HashStore();
                this._indexTable.put("$Tag$", store);
            }
        }
        if (!this._indexTable.containsKey("$Tag$") && this._commonRBStores != null && this._commonRBStores.containsKey("$Tag$")) {
            store = (HashStore)this._commonRBStores.get("$Tag$");
            this._indexTable.put("$Tag$", store);
        }
    }

    @Override
    public void AddToIndex(Object key, Object value) throws RedBlackException {
        HashMap attributeValues = (HashMap)(value instanceof HashMap ? value : null);
        for (Map.Entry current : attributeValues.entrySet()) {
            String indexKey = (String)current.getKey();
            IIndexStore store = this._indexTable.get(indexKey) instanceof IIndexStore ? this._indexTable.get(indexKey) : null;
            if (store == null) {
                if ("$Tag$".equals(indexKey)) {
                    store = new HashStore();
                    this._indexTable.put(indexKey, store);
                } else {
                    String namedTagIndexKey = this.ConvertToNamedTagKey(indexKey);
                    store = this._indexTable.get(namedTagIndexKey) instanceof IIndexStore ? this._indexTable.get(namedTagIndexKey) : null;
                    if (store == null) {
                        if (this._sharedTypes != null && this._sharedTypes.size() > 0) {
                            for (AttributeIndex attrib : this._sharedTypes) {
                                if (this._commonRBStores != null && this._commonRBStores.containsKey(attrib._type + ":" + indexKey)) {
                                    store = attrib.getRBStore(indexKey);
                                }
                                if (store == null) {
                                    store = attrib.getRBStore(namedTagIndexKey);
                                }
                                if (store == null) continue;
                                break;
                            }
                        }
                        if (store == null) {
                            store = new HashStore();
                            this._indexTable.put(namedTagIndexKey, store);
                            if (this._sharedTypes != null && this._sharedTypes.size() > 0) {
                                for (AttributeIndex attrib : this._sharedTypes) {
                                    if (attrib._indexTable.containsKey(namedTagIndexKey)) continue;
                                    attrib._indexTable.put(namedTagIndexKey, store);
                                }
                            }
                        }
                    }
                }
            }
            if (store == null) continue;
            Object val = current.getValue();
            if (val != null) {
                store.Add(val, key);
                continue;
            }
            store.Add("null", key);
        }
    }

    @Override
    public void RemoveFromIndex(Object key, Object value) throws RedBlackException {
        HashMap attributeValues = (HashMap)(value instanceof HashMap ? value : null);
        for (Map.Entry current : attributeValues.entrySet()) {
            String indexKey = (String)current.getKey();
            if (!this._indexTable.containsKey(indexKey) && !this._indexTable.containsKey(indexKey = this.ConvertToNamedTagKey(indexKey))) continue;
            IIndexStore store = this._indexTable.get(indexKey) instanceof IIndexStore ? this._indexTable.get(indexKey) : null;
            Object val = current.getValue();
            if (val != null) {
                store.Remove(val, key);
            } else {
                store.Remove("null", key);
            }
            if (store.getSize() != 0) continue;
            if ("$Tag$".equals(indexKey) || ActiveQueryEvaluationIndex.IsNamedTagKey(indexKey)) {
                this._indexTable.remove(indexKey);
                continue;
            }
            this._indexTable.put(indexKey, new HashStore());
        }
    }
}

