/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.Queries.HashStore;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Caching.Queries.IQueryIndex;
import Alachisoft.NCache.Caching.Queries.IndexInformation;
import Alachisoft.NCache.Caching.Queries.IndexStoreInformation;
import Alachisoft.NCache.Caching.Queries.QueryIndexManager;
import Alachisoft.NCache.Caching.Queries.RBStore;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.DataStructures.RedBlackNodeReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AttributeIndex
implements IQueryIndex,
Serializable {
    protected static final String TAG_INDEX_KEY = "$Tag$";
    protected static final String NAMED_TAG_PREFIX = "$NamedTagAttribute$";
    protected HashMap _indexTable;
    protected String _cacheName;
    protected String _type;
    protected HashMap _keyIndexTable;
    protected ArrayList<AttributeIndex> _sharedTypes;
    protected HashMap _commonRBStores;

    public AttributeIndex() {
    }

    public AttributeIndex(String cacheName, String type) {
        this._indexTable = new HashMap();
        this._cacheName = cacheName;
        this._type = type;
        this._keyIndexTable = new HashMap();
    }

    public AttributeIndex(ArrayList attribList, String cacheName, String type) {
        this._indexTable = new HashMap();
        this._cacheName = cacheName;
        this._keyIndexTable = new HashMap();
        this._type = type;
        this.Initialize(attribList);
    }

    public static final boolean IsNamedTagKey(String indexKey) {
        boolean result = indexKey.startsWith(NAMED_TAG_PREFIX);
        return result;
    }

    public void setSharedTypes(ArrayList<AttributeIndex> list) {
        this._sharedTypes = list;
    }

    public void setCommonRBStores(HashMap commonRBStores) {
        this._commonRBStores = commonRBStores;
    }

    public IIndexStore getRBStore(String attrib) {
        return this._indexTable.get(attrib) instanceof IIndexStore ? this._indexTable.get(attrib) : null;
    }

    public String getCompatibleAttrib(String attribName) {
        String compatibleAttrib = null;
        String storeName = null;
        RBStore store = null;
        if (this._sharedTypes != null) {
            for (AttributeIndex attrib : this._sharedTypes) {
                if (!this._commonRBStores.containsKey(attrib._type + ":" + attribName)) continue;
                store = (RBStore)this._commonRBStores.get(attrib._type + ":" + attribName);
                storeName = attrib._type + ":" + attribName;
                break;
            }
            if (store != null && storeName != null) {
                for (Map.Entry entry : this._commonRBStores.entrySet()) {
                    String key = (String)entry.getKey();
                    RBStore entryStore = (RBStore)entry.getValue();
                    if (storeName.equals(key) || !store.equals(entryStore)) continue;
                    String[] tempName = key.split(":");
                    compatibleAttrib = tempName[1];
                    break;
                }
            }
        }
        return compatibleAttrib;
    }

    public final int getSize() {
        if (this._indexTable != null) {
            return this._indexTable.size();
        }
        return 0;
    }

    public void Initialize(ArrayList attribList) {
        RBStore store = null;
        if (attribList != null && attribList.size() > 0) {
            Iterator e = attribList.iterator();
            while (e.hasNext()) {
                String attribName = e.next().toString();
                if (this._commonRBStores != null && this._commonRBStores.containsKey(this._type + ":" + attribName)) {
                    RBStore commonStore = (RBStore)this._commonRBStores.get(this._type + ":" + attribName);
                    this._indexTable.put(attribName, commonStore);
                    continue;
                }
                store = new RBStore(this._cacheName);
                this._indexTable.put(attribName, store);
            }
            if (this._commonRBStores != null && this._commonRBStores.containsKey(TAG_INDEX_KEY)) {
                store = (RBStore)this._commonRBStores.get(TAG_INDEX_KEY);
                this._indexTable.put(TAG_INDEX_KEY, store);
            } else {
                store = new RBStore(this._cacheName);
                this._indexTable.put(TAG_INDEX_KEY, store);
            }
        }
        if (!this._indexTable.containsKey(TAG_INDEX_KEY) && this._commonRBStores != null && this._commonRBStores.containsKey(TAG_INDEX_KEY)) {
            store = (RBStore)this._commonRBStores.get(TAG_INDEX_KEY);
            this._indexTable.put(TAG_INDEX_KEY, store);
        }
    }

    @Override
    public void AddToIndex(Object key, Object value) throws RedBlackException {
        HashMap attributeValues = (HashMap)(value instanceof HashMap ? value : null);
        Iterator valuesDic = attributeValues.entrySet().iterator();
        RedBlackNodeReference keyNode = null;
        while (valuesDic.hasNext()) {
            Object val;
            String indexKey;
            Map.Entry current = valuesDic.next();
            String storeName = indexKey = (String)current.getKey();
            IIndexStore store = this._indexTable.get(indexKey) instanceof IIndexStore ? this._indexTable.get(indexKey) : null;
            keyNode = null;
            if (store == null) {
                if (TAG_INDEX_KEY.equals(indexKey)) {
                    store = new RBStore(this._cacheName);
                    this._indexTable.put(indexKey, store);
                } else {
                    String namedTagIndexKey;
                    storeName = namedTagIndexKey = this.ConvertToNamedTagKey(indexKey);
                    store = this._indexTable.get(namedTagIndexKey) instanceof IIndexStore ? this._indexTable.get(namedTagIndexKey) : null;
                    if (store == null) {
                        if (this._sharedTypes != null && this._sharedTypes.size() > 0) {
                            AttributeIndex attrib;
                            Iterator<AttributeIndex> iterator = this._sharedTypes.iterator();
                            while (iterator.hasNext() && (store = (attrib = iterator.next()).getRBStore(namedTagIndexKey)) == null) {
                            }
                        }
                        if (store == null) {
                            store = new RBStore(this._cacheName);
                            this._indexTable.put(namedTagIndexKey, store);
                            if (this._sharedTypes != null && this._sharedTypes.size() > 0) {
                                for (AttributeIndex attrib : this._sharedTypes) {
                                    if (attrib._indexTable.containsKey(namedTagIndexKey)) continue;
                                    attrib._indexTable.put(namedTagIndexKey, store);
                                }
                            }
                        }
                    }
                }
            }
            if (store != null && (val = current.getValue()) != null) {
                keyNode = (RedBlackNodeReference)store.Add(val, key);
            }
            IndexInformation info = this._keyIndexTable.containsKey(key) ? (IndexInformation)(this._keyIndexTable.get(key) instanceof IndexInformation ? this._keyIndexTable.get(key) : null) : new IndexInformation();
            info.Add(storeName, store, keyNode);
            this._keyIndexTable.put(key, info);
        }
    }

    @Override
    public void RemoveFromIndex(Object key) throws RedBlackException {
        boolean isNodeRemoved = false;
        IndexInformation indexInfo = (IndexInformation)this._keyIndexTable.get(key);
        if (indexInfo != null) {
            for (IndexStoreInformation indexStoreInfo : indexInfo.getIndexStoreInformations()) {
                isNodeRemoved = false;
                IIndexStore store = indexStoreInfo.getStore();
                if (indexStoreInfo.getIndexPosition() == null) continue;
                isNodeRemoved = store.Remove(key, indexStoreInfo.getIndexPosition());
            }
        }
        this._keyIndexTable.remove(key);
    }

    @Override
    public void RemoveFromIndex(Object key, Object value) throws RedBlackException {
        HashMap attributeValues = (HashMap)(value instanceof HashMap ? value : null);
        for (Map.Entry current : attributeValues.entrySet()) {
            String indexKey = (String)current.getKey();
            if (!this._indexTable.containsKey(indexKey) && !this._indexTable.containsKey(indexKey = this.ConvertToNamedTagKey(indexKey))) continue;
            IIndexStore store = this._indexTable.get(indexKey) instanceof IIndexStore ? this._indexTable.get(indexKey) : null;
            Object val = current.getValue();
            if (val != null) {
                store.Remove(val, key);
            } else {
                store.Remove("null", key);
            }
            if (store.getSize() != 0) continue;
            if (TAG_INDEX_KEY.equals(indexKey) || AttributeIndex.IsNamedTagKey(indexKey)) {
                this._indexTable.remove(indexKey);
                continue;
            }
            this._indexTable.put(indexKey, new RBStore(this._cacheName));
        }
    }

    public final IIndexStore GetStore(String attrib) {
        boolean disableException = QueryIndexManager.getDisableException();
        IIndexStore store = null;
        if (this._indexTable.containsKey(attrib)) {
            store = this._indexTable.get(attrib) instanceof IIndexStore ? this._indexTable.get(attrib) : null;
        } else {
            String namedTagKey = this.ConvertToNamedTagKey(attrib);
            if (this._indexTable.containsKey(namedTagKey)) {
                store = this._indexTable.get(namedTagKey) instanceof IIndexStore ? this._indexTable.get(namedTagKey) : null;
            }
            if (store == null && this._sharedTypes != null && this._sharedTypes.size() > 0) {
                AttributeIndex sharedAttrib;
                Iterator<AttributeIndex> iterator = this._sharedTypes.iterator();
                while (iterator.hasNext() && (store = (sharedAttrib = iterator.next()).getRBStore(attrib)) == null) {
                }
            }
            if (disableException && store == null) {
                store = new HashStore();
            }
        }
        return store;
    }

    @Override
    public final void Clear() {
        for (Map.Entry current : this._indexTable.entrySet()) {
            IIndexStore store = current.getValue() instanceof IIndexStore ? current.getValue() : null;
            store.Clear();
        }
        this._keyIndexTable.clear();
    }

    @Override
    public final Iterator GetEnumerator(String type, boolean forTag) {
        Iterator en = this._indexTable.entrySet().iterator();
        if (!forTag) {
            while (en.hasNext()) {
                Map.Entry current = en.next();
                IIndexStore store = current.getValue() instanceof IIndexStore ? current.getValue() : null;
                if (TAG_INDEX_KEY.equals((String)current.getKey())) continue;
                return store.GetEnumerator();
            }
        } else if (this._indexTable.containsKey(TAG_INDEX_KEY)) {
            IIndexStore store = this._indexTable.get(TAG_INDEX_KEY) instanceof IIndexStore ? this._indexTable.get(TAG_INDEX_KEY) : null;
            return store.GetEnumerator();
        }
        return null;
    }

    @Override
    public final IndexInformation GetIndexInformation(Object key) {
        return (IndexInformation)this._keyIndexTable.get(key);
    }

    public final Iterator GetEnumerator() {
        return this._indexTable.entrySet().iterator();
    }

    protected final String ConvertToNamedTagKey(String indexKey) {
        String namedTagKey = NAMED_TAG_PREFIX + indexKey;
        return namedTagKey;
    }

    public final Object GetAttributeValue(String key, String attributeName) {
        String storeName = attributeName;
        if (!this._indexTable.containsKey(storeName) && !this._indexTable.containsKey(storeName = this.ConvertToNamedTagKey(attributeName))) {
            throw new RuntimeException("Index is not defined for attribute '" + attributeName + "'");
        }
        IndexInformation indexInformation = this.GetIndexInformation(key);
        if (indexInformation == null && this._sharedTypes != null) {
            for (AttributeIndex index : this._sharedTypes) {
                indexInformation = index.GetIndexInformation(key);
                if (indexInformation == null) continue;
                String compatibleName = index.getCompatibleAttrib(storeName);
                if (compatibleName == null) break;
                storeName = compatibleName;
                break;
            }
        }
        Comparable value = null;
        for (IndexStoreInformation indexStoreInfo : indexInformation.getIndexStoreInformations()) {
            if (!storeName.equals(indexStoreInfo.getStoreName())) continue;
            if (indexStoreInfo.getIndexPosition() != null) {
                value = indexStoreInfo.getIndexPosition().getRBReference().getKey();
                break;
            }
            return null;
        }
        return value;
    }
}

