/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries.Filters;

import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.ComparisonType;
import Alachisoft.NCache.Caching.Queries.Filters.IFunctor;
import Alachisoft.NCache.Caching.Queries.Filters.IGenerator;
import Alachisoft.NCache.Caching.Queries.Filters.MemberFunction;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Common.DataStructures.SortedMap;
import Alachisoft.NCache.Parser.AttributeIndexNotDefined;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import tangible.RefObject;

public class IsInListPredicate
extends Predicate
implements Comparable {
    private IFunctor functor;
    private ArrayList members = new ArrayList();

    public final void setFunctor(IFunctor value) {
        this.functor = value;
    }

    public final ArrayList getValues() {
        return this.members;
    }

    public final void Append(Object item) {
        Object obj = ((IGenerator)item).Evaluate();
        if (this.members.contains(obj)) {
            return;
        }
        this.members.add(obj);
        Collections.sort(this.members);
    }

    @Override
    public boolean ApplyPredicate(Object o) {
        Object lhs = this.functor.Evaluate(o);
        if (this.getInverse()) {
            return !this.members.contains(lhs);
        }
        return this.members.contains(lhs);
    }

    @Override
    public void ExecuteInternal(QueryContext queryContext, RefObject<SortedMap> list) throws Exception {
        AttributeIndex index = queryContext.getIndex();
        IIndexStore store = ((MemberFunction)this.functor).GetStore(index);
        ArrayList keyList = new ArrayList();
        if (store != null) {
            Object tempVar = queryContext.getAttributeValues().get(((MemberFunction)this.functor).getMemberName());
            this.members = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
            if (this.members == null) {
                if (queryContext.getAttributeValues().size() > 0) {
                    this.members = new ArrayList();
                    this.members.add(queryContext.getAttributeValues().get(((MemberFunction)this.functor).getMemberName()));
                } else {
                    throw new Exception("Value(s) not specified for indexed attribute " + ((MemberFunction)this.functor).getMemberName() + ".");
                }
            }
            if (!this.getInverse()) {
                for (int i = 0; i < this.members.size(); ++i) {
                    ArrayList temp = store.GetData(this.members.get(i), ComparisonType.EQUALS);
                    if (temp == null || temp.size() <= 0) continue;
                    keyList.addAll(temp);
                }
            } else {
                ArrayList temp = store.GetData(this.members.get(0), ComparisonType.NOT_EQUALS);
                if (temp != null && temp.size() > 0) {
                    for (int i = 1; i < this.members.size(); ++i) {
                        Iterator ie;
                        ArrayList extras = store.GetData(this.members.get(i), ComparisonType.EQUALS);
                        if (extras == null || (ie = extras.iterator()) == null) continue;
                        while (ie.hasNext()) {
                            if (!temp.contains(ie.next())) continue;
                            temp.remove(ie.next());
                        }
                    }
                    keyList.addAll(temp);
                }
            }
            if (keyList != null) {
                ((SortedMap)list.argvalue).putValue((Object)keyList.size(), keyList);
            }
        } else {
            throw new AttributeIndexNotDefined("Index is not defined for attribute '" + ((MemberFunction)this.functor).getMemberName() + "'");
        }
    }

    @Override
    public void Execute(QueryContext queryContext, Predicate nextPredicate) throws Exception {
        AttributeIndex index = queryContext.getIndex();
        IIndexStore store = ((MemberFunction)this.functor).GetStore(index);
        if (store != null) {
            Object tempVar = queryContext.getAttributeValues().get(((MemberFunction)this.functor).getMemberName());
            this.members = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
            if (this.members == null) {
                if (queryContext.getAttributeValues().size() > 0) {
                    this.members = new ArrayList();
                    this.members.add(queryContext.getAttributeValues().get(((MemberFunction)this.functor).getMemberName()));
                } else {
                    throw new Exception("Value(s) not specified for indexed attribute " + ((MemberFunction)this.functor).getMemberName() + ".");
                }
            }
            ArrayList keyList = new ArrayList();
            if (!this.getInverse()) {
                for (int i = 0; i < this.members.size(); ++i) {
                    ArrayList temp = store.GetData(this.members.get(i), ComparisonType.EQUALS);
                    if (temp == null || temp.size() <= 0) continue;
                    keyList.addAll(temp);
                }
            } else {
                ArrayList temp = store.GetData(this.members.get(0), ComparisonType.NOT_EQUALS);
                if (temp != null && temp.size() > 0) {
                    for (int i = 1; i < this.members.size(); ++i) {
                        Iterator ie;
                        ArrayList extras = store.GetData(this.members.get(i), ComparisonType.EQUALS);
                        if (extras == null || (ie = extras.iterator()) == null) continue;
                        while (ie.hasNext()) {
                            if (!temp.contains(ie.next())) continue;
                            temp.remove(ie.next());
                        }
                    }
                    keyList.addAll(temp);
                }
            }
            if (keyList != null && keyList.size() > 0) {
                Iterator keyListEnum = keyList.iterator();
                if (queryContext.getPopulateTree()) {
                    queryContext.getTree().setRightList(keyList);
                    queryContext.setPopulateTree(false);
                } else {
                    while (keyListEnum.hasNext()) {
                        if (!queryContext.getTree().getLeftList().contains(keyListEnum.next())) continue;
                        queryContext.getTree().Shift(keyListEnum.next());
                    }
                }
            }
        } else {
            throw new AttributeIndexNotDefined("Index is not defined for attribute '" + ((MemberFunction)this.functor).getMemberName() + "'");
        }
    }

    public String toString() {
        Object text = this.getInverse() ? "is not in (" : "is in (";
        for (int i = 0; i < this.members.size(); ++i) {
            if (i > 0) {
                text = (String)text + ", ";
            }
            text = (String)text + this.members.get(i).toString();
        }
        text = (String)text + ")";
        return text;
    }

    public final int compareTo(Object obj) {
        if (obj instanceof IsInListPredicate) {
            IsInListPredicate other = (IsInListPredicate)obj;
            if (this.getInverse() == other.getInverse() && this.members.size() == other.members.size()) {
                for (int i = 0; i < this.members.size(); ++i) {
                    if (this.members.get(i) == other.members.get(i)) continue;
                    return -1;
                }
                return 0;
            }
        }
        return -1;
    }
}

