/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries.Filters;

import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.Queries.Filters.IsOfTypePredicate;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.Filters.QueryResultComparer;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Common.DataStructures.SortedMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import tangible.RefObject;

public class LogicalAndPredicate
extends Predicate
implements Comparable {
    private ArrayList members = new ArrayList();

    public final ArrayList getChildren() {
        return this.members;
    }

    @Override
    public void Invert() {
        super.Invert();
        for (int i = 0; i < this.members.size(); ++i) {
            ((Predicate)this.members.get(i)).Invert();
        }
    }

    @Override
    public boolean ApplyPredicate(Object o) {
        for (int i = 0; i < this.members.size(); ++i) {
            if (((Predicate)this.members.get(i)).Evaluate(o) != this.getInverse()) continue;
            return this.getInverse();
        }
        return !this.getInverse();
    }

    @Override
    public void ExecuteInternal(QueryContext queryContext, RefObject<SortedMap> list) throws Exception {
        boolean sortAscending = true;
        ArrayList keys = new ArrayList();
        if (this.getInverse()) {
            sortAscending = false;
        }
        SortedMap tmpList = new SortedMap((Comparator)new QueryResultComparer(sortAscending));
        for (int i = 0; i < this.members.size(); ++i) {
            Predicate predicate = (Predicate)this.members.get(i);
            RefObject tempRef_tmpList = new RefObject((Object)tmpList);
            predicate.ExecuteInternal(queryContext, (RefObject<SortedMap>)tempRef_tmpList);
            tmpList = (SortedMap)tempRef_tmpList.argvalue;
        }
        keys = this.getInverse() ? this.GetUnion(tmpList) : this.GetIntersection(tmpList);
        if (keys != null) {
            ((SortedMap)list.argvalue).putValue((Object)keys.size(), (Object)keys);
        }
    }

    @Override
    public void Execute(QueryContext queryContext, Predicate nextPredicate) throws StateTransferException, Exception {
        boolean sortAscending = true;
        boolean normalizePredicates = true;
        if (this.getInverse()) {
            sortAscending = false;
        }
        SortedMap list = new SortedMap((Comparator)new QueryResultComparer(sortAscending));
        for (int i = 0; i < this.members.size(); ++i) {
            Predicate predicate = (Predicate)this.members.get(i);
            boolean isOfTypePredicate = predicate instanceof IsOfTypePredicate;
            if (isOfTypePredicate) {
                predicate.Execute(queryContext, (Predicate)this.members.get(++i));
                normalizePredicates = false;
                continue;
            }
            RefObject tempRef_list = new RefObject((Object)list);
            predicate.ExecuteInternal(queryContext, (RefObject<SortedMap>)tempRef_list);
            list = (SortedMap)tempRef_list.argvalue;
        }
        if (normalizePredicates) {
            if (this.getInverse()) {
                queryContext.getTree().setRightList(this.GetUnion(list));
            } else {
                queryContext.getTree().setRightList(this.GetIntersection(list));
            }
        }
    }

    private ArrayList GetUnion(SortedMap list) {
        HashMap finalTable = new HashMap();
        if (list.size() > 0) {
            int i;
            Object tempVar = list.getByIndex(0);
            ArrayList finalKeys = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
            for (i = 0; i < finalKeys.size(); ++i) {
                finalTable.put(finalKeys.get(i), null);
            }
            for (i = 1; i < list.size(); ++i) {
                Object tempVar2 = list.getByIndex(i);
                ArrayList keys = (ArrayList)(tempVar2 instanceof ArrayList ? tempVar2 : null);
                if (keys == null || keys.size() <= 0) continue;
                for (int j = 0; j < keys.size(); ++j) {
                    finalTable.put(keys.get(j), null);
                }
            }
        }
        return new ArrayList(finalTable.keySet());
    }

    private ArrayList GetIntersection(SortedMap list) {
        HashMap finalTable = new HashMap();
        if (list.size() > 0) {
            int i;
            Object tempVar = list.getByIndex(0);
            ArrayList keys = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
            for (i = 0; i < keys.size(); ++i) {
                finalTable.put(keys.get(i), null);
            }
            for (i = 1; i < list.size(); ++i) {
                HashMap shiftTable = new HashMap();
                Object tempVar2 = list.getByIndex(i);
                keys = (ArrayList)(tempVar2 instanceof ArrayList ? tempVar2 : null);
                if (keys != null) {
                    for (int j = 0; j < keys.size(); ++j) {
                        Object key = keys.get(j);
                        if (!finalTable.containsKey(key)) continue;
                        shiftTable.put(key, null);
                    }
                }
                finalTable = shiftTable;
            }
        }
        return new ArrayList(finalTable.keySet());
    }

    public String toString() {
        Object text = this.getInverse() ? "(" : "(";
        for (int i = 0; i < this.members.size(); ++i) {
            if (i > 0) {
                text = (String)text + (this.getInverse() ? " or " : " and ");
            }
            text = (String)text + this.members.get(i).toString();
        }
        text = (String)text + ")";
        return text;
    }

    public final int compareTo(Object obj) {
        if (obj instanceof LogicalAndPredicate) {
            LogicalAndPredicate other = (LogicalAndPredicate)obj;
            if (this.getInverse() == other.getInverse() && this.members.size() == other.members.size()) {
                for (int i = 0; i < this.members.size(); ++i) {
                    if (this.members.get(i) == other.members.get(i)) continue;
                    return -1;
                }
                return 0;
            }
        }
        return -1;
    }
}

