/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.Queries.ComparisonType;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Common.Util.WildcardEnabledRegex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class HashStore
implements IIndexStore,
Serializable {
    private HashMap _store = new HashMap();

    @Override
    public final Object Add(Object key, Object value) {
        if (this._store != null) {
            this._store.put(key, value);
        }
        return null;
    }

    @Override
    public final boolean Remove(Object key, Object value) {
        if (this._store != null && this._store.containsKey(key)) {
            this._store.remove(key);
        }
        return true;
    }

    @Override
    public final void Clear() {
        if (this._store != null) {
            this._store.clear();
        }
    }

    @Override
    public final Iterator GetEnumerator() {
        if (this._store != null) {
            return this._store.entrySet().iterator();
        }
        return new HashMap().entrySet().iterator();
    }

    @Override
    public final int getSize() {
        return this._store != null ? this._store.size() : 0;
    }

    @Override
    public final ArrayList GetData(Object key, ComparisonType comparisonType) {
        ArrayList result = new ArrayList();
        Comparable keyToCompare = (Comparable)(key instanceof Comparable ? key : null);
        if (this._store != null) {
            switch (comparisonType) {
                case EQUALS: {
                    if (!this._store.containsKey(key)) break;
                    result.add(this._store.get(key));
                    break;
                }
                case NOT_EQUALS: {
                    for (Object storedKey : this._store.keySet()) {
                        if (((Comparable)storedKey).compareTo(keyToCompare) == 0) continue;
                        result.add(this._store.get(storedKey));
                    }
                    break;
                }
                case LESS_THAN: {
                    for (Object storedKey : this._store.keySet()) {
                        if (((Comparable)storedKey).compareTo(keyToCompare) >= 0) continue;
                        result.add(this._store.get(storedKey));
                    }
                    break;
                }
                case GREATER_THAN: {
                    for (Object storedKey : this._store.keySet()) {
                        if (((Comparable)storedKey).compareTo(keyToCompare) <= 0) continue;
                        result.add(this._store.get(storedKey));
                    }
                    break;
                }
                case LESS_THAN_EQUALS: {
                    for (Object storedKey : this._store.keySet()) {
                        if (((Comparable)storedKey).compareTo(keyToCompare) > 0) continue;
                        result.add(this._store.get(storedKey));
                    }
                    break;
                }
                case GREATER_THAN_EQUALS: {
                    for (Object storedKey : this._store.keySet()) {
                        if (((Comparable)storedKey).compareTo(keyToCompare) < 0) continue;
                        result.add(this._store.get(storedKey));
                    }
                    break;
                }
                case LIKE: {
                    for (Object storedKey : this._store.keySet()) {
                        String pattern = (String)(key instanceof String ? key : null);
                        WildcardEnabledRegex regex = new WildcardEnabledRegex(pattern);
                        if (!(storedKey instanceof String) || !regex.IsMatch((String)storedKey)) continue;
                        result.add(this._store.get(key));
                    }
                    break;
                }
                case NOT_LIKE: {
                    for (Object storedKey : this._store.keySet()) {
                        String pattern = (String)(key instanceof String ? key : null);
                        WildcardEnabledRegex regex = new WildcardEnabledRegex(pattern);
                        if (!(storedKey instanceof String) || regex.IsMatch((String)storedKey)) continue;
                        result.add(this._store.get(key));
                    }
                    break;
                }
            }
        }
        return result;
    }
}

