/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.Queries.QueryType;
import Alachisoft.NCache.Common.DataStructures.RecordSet;
import Alachisoft.NCache.Common.Enum.AggregateFunctionType;
import com.alachisoft.ncache.runtime.queries.AverageResult;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QueryResultSet
implements ICompactSerializable {
    private ArrayList _searchKeysResult;
    private HashMap _searchEntriesResult;
    private Map.Entry _aggregateFunctionResult;
    private boolean _isInitialized = false;
    private QueryType _queryType = QueryType.SearchKeys;
    private AggregateFunctionType _aggregateFunctionType = AggregateFunctionType.NOTAPPLICABLE;
    private String _cqId;
    private ArrayList _keysForUpdateIndices;
    private RecordSet _groupByResult;

    public RecordSet getGroupByResult() {
        return this._groupByResult;
    }

    public void setGroupByResult(RecordSet value) {
        this._groupByResult = value;
    }

    public ArrayList getUpdateIndicesKeys() {
        return this._keysForUpdateIndices;
    }

    public void setUpdateIndicesKeys(ArrayList value) {
        this._keysForUpdateIndices = value;
    }

    public String getCQUniqueId() {
        return this._cqId;
    }

    public void setCQUniqueId(String value) {
        this._cqId = value;
    }

    public boolean getIsInitialized() {
        return this._isInitialized;
    }

    public QueryType getType() {
        return this._queryType;
    }

    public void setType(QueryType value) {
        this._queryType = value;
    }

    public AggregateFunctionType getAggregateFunctionType() {
        return this._aggregateFunctionType;
    }

    public void setAggregateFunctionType(AggregateFunctionType value) {
        this._aggregateFunctionType = value;
    }

    public ArrayList getSearchKeysResult() {
        return this._searchKeysResult;
    }

    public void setSearchKeysResult(ArrayList value) {
        this._searchKeysResult = value;
    }

    public HashMap getSearchEntriesResult() {
        return this._searchEntriesResult;
    }

    public void setSearchEntriesResult(HashMap value) {
        this._searchEntriesResult = value;
    }

    public Map.Entry getAggregateFunctionResult() {
        return this._aggregateFunctionResult;
    }

    public void setAggregateFunctionResult(Map.Entry value) {
        this._aggregateFunctionResult = value;
    }

    public void Initialize(QueryResultSet resultSet) {
        if (!this._isInitialized) {
            this.setType(resultSet.getType());
            this.setAggregateFunctionType(resultSet.getAggregateFunctionType());
            this.setAggregateFunctionResult(resultSet.getAggregateFunctionResult());
            this.setSearchKeysResult(resultSet.getSearchKeysResult());
            this.setSearchEntriesResult(resultSet.getSearchEntriesResult());
            this._isInitialized = true;
        }
    }

    public void Compile(QueryResultSet resultSet) {
        if (!this._isInitialized) {
            this.Initialize(resultSet);
            return;
        }
        switch (this.getType()) {
            case AggregateFunction: {
                switch ((AggregateFunctionType)this.getAggregateFunctionResult().getKey()) {
                    case SUM: {
                        BigDecimal a = new BigDecimal(0);
                        BigDecimal b = new BigDecimal(0);
                        Object thisVal = this.getAggregateFunctionResult().getValue();
                        Object otherVal = resultSet.getAggregateFunctionResult().getValue();
                        BigDecimal sum = null;
                        if (thisVal == null && otherVal != null) {
                            sum = (BigDecimal)otherVal;
                        } else if (thisVal != null && otherVal == null) {
                            sum = (BigDecimal)thisVal;
                        } else if (thisVal != null && otherVal != null) {
                            a = (BigDecimal)thisVal;
                            b = (BigDecimal)otherVal;
                            sum = a.add(b);
                        }
                        if (sum != null) {
                            this.setAggregateFunctionResult(new AbstractMap.SimpleEntry<AggregateFunctionType, BigDecimal>(AggregateFunctionType.SUM, sum));
                            break;
                        }
                        this.setAggregateFunctionResult(new AbstractMap.SimpleEntry<AggregateFunctionType, Object>(AggregateFunctionType.SUM, null));
                        break;
                    }
                    case COUNT: {
                        BigDecimal a = (BigDecimal)this.getAggregateFunctionResult().getValue();
                        BigDecimal b = (BigDecimal)resultSet.getAggregateFunctionResult().getValue();
                        BigDecimal count = a.add(b);
                        this.setAggregateFunctionResult(new AbstractMap.SimpleEntry<AggregateFunctionType, BigDecimal>(AggregateFunctionType.COUNT, count));
                        break;
                    }
                    case MIN: {
                        Comparable thisValue = (Comparable)this.getAggregateFunctionResult().getValue();
                        Comparable otherValue = (Comparable)resultSet.getAggregateFunctionResult().getValue();
                        Comparable min = thisValue;
                        if (thisValue == null && otherValue != null) {
                            min = otherValue;
                        } else if (thisValue != null && otherValue == null) {
                            min = thisValue;
                        } else if (thisValue == null && otherValue == null) {
                            min = null;
                        } else if (otherValue.compareTo(thisValue) < 0) {
                            min = otherValue;
                        }
                        this.setAggregateFunctionResult(new AbstractMap.SimpleEntry<AggregateFunctionType, Comparable>(AggregateFunctionType.MIN, min));
                        break;
                    }
                    case MAX: {
                        Comparable thisValue = (Comparable)this.getAggregateFunctionResult().getValue();
                        Comparable otherValue = (Comparable)resultSet.getAggregateFunctionResult().getValue();
                        Comparable max = thisValue;
                        if (thisValue == null && otherValue != null) {
                            max = otherValue;
                        } else if (thisValue != null && otherValue == null) {
                            max = thisValue;
                        } else if (thisValue == null && otherValue == null) {
                            max = null;
                        } else if (otherValue.compareTo(thisValue) > 0) {
                            max = otherValue;
                        }
                        this.setAggregateFunctionResult(new AbstractMap.SimpleEntry<AggregateFunctionType, Comparable>(AggregateFunctionType.MAX, max));
                        break;
                    }
                    case AVG: {
                        Object thisVal = this.getAggregateFunctionResult().getValue();
                        Object otherVal = resultSet.getAggregateFunctionResult().getValue();
                        AverageResult avg = null;
                        if (thisVal == null && otherVal != null) {
                            avg = (AverageResult)otherVal;
                        } else if (thisVal != null && otherVal == null) {
                            avg = (AverageResult)thisVal;
                        } else if (thisVal != null && otherVal != null) {
                            AverageResult thisResult = (AverageResult)thisVal;
                            AverageResult otherResult = (AverageResult)otherVal;
                            avg = new AverageResult();
                            avg.setSum(thisResult.getSum().add(otherResult.getSum()));
                            avg.setCount(thisResult.getCount().add(otherResult.getCount()));
                        }
                        if (avg != null) {
                            this.setAggregateFunctionResult(new AbstractMap.SimpleEntry<AggregateFunctionType, AverageResult>(AggregateFunctionType.AVG, avg));
                            break;
                        }
                        this.setAggregateFunctionResult(new AbstractMap.SimpleEntry<AggregateFunctionType, Object>(AggregateFunctionType.AVG, null));
                    }
                }
                break;
            }
            case SearchKeys: {
                if (this.getSearchKeysResult() == null) {
                    this.setSearchKeysResult(resultSet.getSearchKeysResult());
                    break;
                }
                if (resultSet.getSearchKeysResult() == null) break;
                this.getSearchKeysResult().addAll(resultSet.getSearchKeysResult());
                break;
            }
            case SearchEntries: {
                if (this.getSearchEntriesResult() == null) {
                    this.setSearchEntriesResult(resultSet.getSearchEntriesResult());
                    break;
                }
                for (Map.Entry current : resultSet.getSearchEntriesResult().entrySet()) {
                    try {
                        this.getSearchEntriesResult().put(current.getKey(), current.getValue());
                    }
                    catch (IllegalArgumentException ex) {
                        CacheEntry entry = current.getValue() instanceof CacheEntry ? current.getValue() : null;
                        Object tempVar = this.getSearchEntriesResult().get(current.getKey());
                        CacheEntry existingEntry = (CacheEntry)(tempVar instanceof CacheEntry ? tempVar : null);
                        if (entry == null || existingEntry == null || entry.getVersion() <= existingEntry.getVersion()) continue;
                        this.getSearchEntriesResult().put(current.getKey(), entry);
                    }
                }
                break;
            }
        }
    }

    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._aggregateFunctionResult = (Map.Entry)reader.readObject();
        Object tempVar = reader.readObject();
        this._searchKeysResult = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
        Object tempVar2 = reader.readObject();
        this._searchEntriesResult = (HashMap)(tempVar2 instanceof HashMap ? tempVar2 : null);
        this._queryType = QueryType.forValue(reader.readInt());
        this._aggregateFunctionType = AggregateFunctionType.forValue((int)reader.readInt());
        this._cqId = reader.readUTF();
        this._groupByResult = (RecordSet)reader.readObject();
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeObject((Object)this._aggregateFunctionResult);
        writer.writeObject((Object)this._searchKeysResult);
        writer.writeObject((Object)this._searchEntriesResult);
        writer.writeInt(this._queryType.getValue());
        writer.writeInt(this._aggregateFunctionType.getValue());
        writer.writeUTF(this.getCQUniqueId());
        writer.writeObject((Object)this._groupByResult);
    }
}

