/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.Queries.ComparisonType;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Common.DataStructures.RedBlack;
import Alachisoft.NCache.Common.DataStructures.RedBlackEnumerator;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import java.util.ArrayList;
import java.util.Iterator;

public class RBStore
implements IIndexStore {
    private RedBlack _rbTree;

    public RBStore(String cacheName) {
        this._rbTree = new RedBlack(cacheName);
    }

    @Override
    public final Object Add(Object key, Object value) throws RedBlackException {
        Object node = new Object();
        if (this._rbTree != null) {
            node = this._rbTree.Add((Comparable)(key instanceof Comparable ? key : null), value);
        }
        return node;
    }

    @Override
    public final boolean Remove(Object value, Object indexPosition) throws RedBlackException {
        boolean isNodeRemoved = false;
        if (this._rbTree != null) {
            isNodeRemoved = this._rbTree.Remove(value, indexPosition);
        }
        return isNodeRemoved;
    }

    @Override
    public final void Clear() {
        if (this._rbTree != null) {
            this._rbTree.Clear();
        }
    }

    @Override
    public final Iterator GetEnumerator() {
        if (this._rbTree != null) {
            return this._rbTree.GetEnumerator();
        }
        return new RedBlackEnumerator();
    }

    @Override
    public final ArrayList GetData(Object key, ComparisonType comparisonType) {
        RedBlack.COMPARE compare = RedBlack.COMPARE.EQ;
        ArrayList result = new ArrayList();
        if (this._rbTree != null) {
            switch (comparisonType) {
                case EQUALS: {
                    compare = RedBlack.COMPARE.EQ;
                    break;
                }
                case NOT_EQUALS: {
                    compare = RedBlack.COMPARE.NE;
                    break;
                }
                case LESS_THAN: {
                    compare = RedBlack.COMPARE.LT;
                    break;
                }
                case GREATER_THAN: {
                    compare = RedBlack.COMPARE.GT;
                    break;
                }
                case LESS_THAN_EQUALS: {
                    compare = RedBlack.COMPARE.LTEQ;
                    break;
                }
                case GREATER_THAN_EQUALS: {
                    compare = RedBlack.COMPARE.GTEQ;
                    break;
                }
                case LIKE: {
                    compare = RedBlack.COMPARE.REGEX;
                    break;
                }
                case NOT_LIKE: {
                    compare = RedBlack.COMPARE.IREGEX;
                }
            }
            Object tempVar = this._rbTree.GetData((Comparable)(key instanceof Comparable ? key : null), compare);
            result = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
        }
        return result;
    }

    @Override
    public final int getSize() {
        return this._rbTree != null ? this._rbTree.getSize() : 0;
    }
}

