/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching;

import Alachisoft.NCache.Common.ServicePropValues;
import java.net.InetAddress;

public class SQLDependencySettings {
    private String SERVICE_PREFIX = "NCacheSQLService-";
    private String QUEUE_PREFIX = "NCacheSQLQueue-";
    private boolean _useDefaultServiceQueue = true;
    private String _serviceName = null;
    private String _queueName = null;

    public SQLDependencySettings() {
        if (ServicePropValues.CacheServer_SQLNotificationService != null) {
            this.SERVICE_PREFIX = ServicePropValues.CacheServer_SQLNotificationService + "-";
        }
        if (ServicePropValues.CacheServer_SQLNotificationQueue != null) {
            this.SERVICE_PREFIX = ServicePropValues.CacheServer_SQLNotificationQueue + "-";
        }
    }

    public final void initialize(boolean useDefaultServiceQueue, InetAddress ipAddress) {
        this._useDefaultServiceQueue = useDefaultServiceQueue;
        if (!this._useDefaultServiceQueue) {
            this._serviceName = this.SERVICE_PREFIX + ipAddress.toString();
            this._queueName = this.QUEUE_PREFIX + ipAddress.toString();
        }
    }

    public final boolean getUseDefaultServiceQueue() {
        return this._useDefaultServiceQueue;
    }

    public final String getServiceName() {
        return this._serviceName;
    }

    public final String getQueueName() {
        return this._queueName;
    }

    public final String GetDependencyOptions(String connString) {
        StringBuilder sqlConnectionStringBuilder = new StringBuilder(connString);
        return String.format("Service=%1$s;local database=%2$s", this.getServiceName(), sqlConnectionStringBuilder);
    }
}

