/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Statistics;

import Alachisoft.NCache.Common.Util.SerializationUtility;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BucketStatistics
implements ICompactSerializable,
Serializable {
    private long _count;
    private long _dataSize;
    private Map<String, TopicStats> _topicWiseDataSize = new HashMap<String, TopicStats>();

    public final long getCount() {
        return this._count;
    }

    public final void setCount(long value) {
        this._count = value;
    }

    public final long getDataSize() {
        return this._dataSize;
    }

    public final void setDataSize(long value) {
        this._dataSize = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Increment(long dataSize) {
        BucketStatistics bucketStatistics = this;
        synchronized (bucketStatistics) {
            ++this._count;
            this._dataSize += dataSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Decrement(long dataSize) {
        BucketStatistics bucketStatistics = this;
        synchronized (bucketStatistics) {
            --this._count;
            this._dataSize -= dataSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear() {
        BucketStatistics bucketStatistics = this;
        synchronized (bucketStatistics) {
            this._count = 0L;
            this._dataSize = 0L;
            this._topicWiseDataSize.clear();
        }
    }

    public final void SerializeLocal(NCacheObjectOutput writer) throws IOException {
        writer.writeLong(this._count);
        writer.writeLong(this._dataSize);
        SerializationUtility.serializeDictionary(this._topicWiseDataSize, (NCacheObjectOutput)writer);
    }

    public final void DeserializeLocal(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        this._count = reader.readLong();
        this._dataSize = reader.readLong();
        this._topicWiseDataSize = SerializationUtility.deserializeDictionary((NCacheObjectInput)reader);
    }

    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._count = reader.readLong();
        this._dataSize = reader.readLong();
        this._topicWiseDataSize = SerializationUtility.deserializeDictionary((NCacheObjectInput)reader);
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeLong(this._count);
        writer.writeLong(this._dataSize);
        SerializationUtility.serializeDictionary(this._topicWiseDataSize, (NCacheObjectOutput)writer);
    }

    class TopicStats
    implements ICompactSerializable,
    Serializable {
        private long size;
        private long count;

        TopicStats() {
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long value) {
            this.size = value;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long value) {
            this.count = value;
        }

        public void deserialize(NCacheObjectInput reader) throws IOException {
            this.size = reader.readLong();
            this.count = reader.readLong();
        }

        public void serialize(NCacheObjectOutput writer) throws IOException {
            writer.writeLong(this.size);
            writer.writeLong(this.count);
        }
    }
}

