/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Statistics;

import Alachisoft.NCache.Caching.Statistics.BucketStatistics;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class CacheStatistics
implements Cloneable,
ICompactSerializable,
Serializable {
    public static final int MAX_CLIENTS_IN_EXPRESS = 2;
    private String _className = "";
    private Date _upTime = new Date(0L);
    private long _count;
    private long _sessionCount;
    private long _hiCount;
    private long _maxCount;
    private long _maxSize;
    private long _hitCount;
    private long _missCount;
    private long _dataSize;
    private String _perfInst = "";
    private BucketStatistics[] _localBuckets;
    private long _updatesCount;
    private HashMap _clientsList = new HashMap(4);

    public CacheStatistics() {
        this("", "");
    }

    public CacheStatistics(String instanceName, String className) {
        this._className = className;
        this._perfInst = instanceName;
        this._upTime = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheStatistics(CacheStatistics stat) {
        CacheStatistics cacheStatistics = stat;
        synchronized (cacheStatistics) {
            this._className = stat._className;
            this._perfInst = stat._perfInst;
            this._upTime = stat._upTime;
            this._count = stat._count;
            this._hiCount = stat._hiCount;
            this._maxCount = stat._maxCount;
            this._maxSize = stat._maxSize;
            this._hitCount = stat._hitCount;
            this._missCount = stat._missCount;
            this._localBuckets = stat._localBuckets != null ? (BucketStatistics[])stat._localBuckets.clone() : null;
        }
    }

    public static CacheStatistics readCacheStatistics(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        byte isNull = reader.readByte();
        if (isNull == 1) {
            return null;
        }
        CacheStatistics newStats = new CacheStatistics();
        newStats.deserialize(reader);
        return newStats;
    }

    public static void writeCacheStatistics(NCacheObjectOutput writer, CacheStatistics stats) throws IOException {
        int isNull = 1;
        if (stats == null) {
            writer.writeByte(isNull);
        } else {
            isNull = 0;
            writer.writeByte(isNull);
            stats.serialize(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AcceptClient(InetAddress clientAddress) {
        HashMap hashMap = this._clientsList;
        synchronized (hashMap) {
            if (this._clientsList.containsKey(clientAddress)) {
                int refCount = (Integer)this._clientsList.get(clientAddress);
                this._clientsList.put(clientAddress, ++refCount);
                return true;
            }
            if (this._clientsList.size() < 2) {
                int refCount = 1;
                this._clientsList.put(clientAddress, refCount);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void DisconnectClient(InetAddress clientAddress) {
        HashMap hashMap = this._clientsList;
        synchronized (hashMap) {
            if (this._clientsList.containsKey(clientAddress)) {
                int refCount = (Integer)this._clientsList.get(clientAddress);
                if (--refCount == 0) {
                    this._clientsList.remove(clientAddress);
                } else {
                    this._clientsList.put(clientAddress, refCount);
                }
            }
        }
    }

    public final String getClassName() {
        return this._className;
    }

    public final void setClassName(String value) {
        this._className = value;
    }

    public final String getInstanceName() {
        return this._perfInst;
    }

    public final void setInstanceName(String value) {
        this._perfInst = value;
    }

    public final Date getUpTime() {
        return this._upTime;
    }

    public final void setUpTime(Date value) {
        this._upTime = value;
    }

    public final long getCount() {
        return this._count;
    }

    public final void setCount(long value) {
        this._count = value;
    }

    public final long getSessionCount() {
        return this._sessionCount;
    }

    public final void setSessionCount(long value) {
        this._sessionCount = value;
    }

    public final HashMap getClientsList() {
        return this._clientsList;
    }

    public final void setClientsList(HashMap value) {
        this._clientsList = value;
    }

    public final long getHiCount() {
        return this._hiCount;
    }

    public final void setHiCount(long value) {
        this._hiCount = value;
    }

    public final long getMaxCount() {
        return this._maxCount;
    }

    public final void setMaxCount(long value) {
        this._maxCount = value;
    }

    public long getMaxSize() {
        return this._maxSize;
    }

    public void setMaxSize(long value) {
        this._maxSize = value;
    }

    public final long getHitCount() {
        return this._hitCount;
    }

    public final void setHitCount(long value) {
        this._hitCount = value;
    }

    public final long getMissCount() {
        return this._missCount;
    }

    public final void setMissCount(long value) {
        this._missCount = value;
    }

    public final long getUpdatesCount() {
        return this._updatesCount;
    }

    public final void setUpdatesCount(long value) {
        this._updatesCount = value;
    }

    public final BucketStatistics[] getLocalBuckets() {
        return this._localBuckets;
    }

    public final void setLocalBuckets(BucketStatistics[] value) {
        this._localBuckets = value;
    }

    public Object clone() {
        return new CacheStatistics(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        CacheStatistics cacheStatistics = this;
        synchronized (cacheStatistics) {
            StringBuilder ret = new StringBuilder();
            ret.append("Stats[Sch:" + this.getClassName() + ", Cnt:" + new Long(this.getCount()).toString() + ", ");
            ret.append("Hi:" + new Long(this.getHiCount()).toString() + ", ");
            ret.append("MxS:" + new Long(this.getMaxSize()).toString() + ", ");
            ret.append("MxC:" + new Long(this.getMaxCount()).toString() + ", ");
            ret.append("Hit:" + new Long(this.getHitCount()).toString() + ", ");
            ret.append("Miss:" + new Long(this.getMissCount()).toString() + "]");
            return ret.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void UpdateCount(long count) {
        CacheStatistics cacheStatistics = this;
        synchronized (cacheStatistics) {
            this._count = count;
            if (this._count > this._hiCount) {
                this._hiCount = this._count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void UpdateSessionCount(int sessionCountUpdateFlag) {
        CacheStatistics cacheStatistics = this;
        synchronized (cacheStatistics) {
            switch (sessionCountUpdateFlag) {
                case -1: {
                    --this._sessionCount;
                    break;
                }
                case 0: {
                    this._sessionCount = 0L;
                    break;
                }
                case 1: {
                    ++this._sessionCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void BumpMissCount() {
        CacheStatistics cacheStatistics = this;
        synchronized (cacheStatistics) {
            ++this._missCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void BumpHitCount() {
        CacheStatistics cacheStatistics = this;
        synchronized (cacheStatistics) {
            ++this._hitCount;
        }
    }

    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._className = (String)reader.readObject();
        this._perfInst = (String)reader.readObject();
        this._upTime = new NCDateTime(reader.readLong()).getDate();
        this._count = reader.readLong();
        this._hiCount = reader.readLong();
        this._maxSize = reader.readLong();
        this._maxCount = reader.readLong();
        this._hitCount = reader.readLong();
        this._missCount = reader.readLong();
        this._updatesCount = reader.readLong();
        this._localBuckets = (BucketStatistics[])reader.readObject();
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeObject((Object)this._className);
        writer.writeObject((Object)this._perfInst);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(14, 0);
        c.setTime(this._upTime);
        NCDateTime ncdt = null;
        try {
            ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        writer.writeLong(ncdt.getTicks());
        writer.writeLong(this._count);
        writer.writeLong(this._hiCount);
        writer.writeLong(this._maxSize);
        writer.writeLong(this._maxCount);
        writer.writeLong(this._hitCount);
        writer.writeLong(this._missCount);
        writer.writeLong(this._updatesCount);
        writer.writeObject((Object)this._localBuckets);
    }
}

