/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Statistics;

import Alachisoft.NCache.Caching.DataGrouping.DataAffinity;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatus;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class NodeInfo
implements Cloneable,
Comparable,
ICompactSerializable,
Serializable {
    private Address _address;
    private String _subgroupName;
    private CacheStatistics _stats;
    private BitSet _status = new BitSet();
    private DataAffinity _dataAffinity;
    private List _connectedClients = Collections.synchronizedList(new ArrayList());
    private Address _rendererAddress;
    private boolean _isInproc;
    private boolean _isStartedAsMirror;
    private String _nodeGuid = UUID.randomUUID().toString();
    private int _statsReplicationCounter = 0;
    private CacheNodeStatus _cacheNodeStatus;
    private List _localConnectedClientsInfo = Collections.synchronizedList(new ArrayList());

    private NodeInfo() {
    }

    public NodeInfo(Address address) {
        this._address = address;
    }

    public NodeInfo(Address address, boolean isStartedAsMirror) {
        this._address = address;
        this._isStartedAsMirror = isStartedAsMirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeInfo(NodeInfo info) {
        Address address = info._address == null ? null : (this._address = (Address)(info._address.clone() instanceof Address ? info._address.clone() : null));
        if (this._rendererAddress != null) {
            Object tempVar2 = info._rendererAddress.clone();
            Address address2 = info._rendererAddress != null ? (Address)(tempVar2 instanceof Address ? tempVar2 : null) : (this._rendererAddress = null);
        }
        this._stats = info._stats == null ? null : (CacheStatistics)(info._stats.clone() instanceof CacheStatistics ? info._stats.clone() : null);
        this._status = info._status;
        this._subgroupName = info._subgroupName;
        this._isInproc = info._isInproc;
        this._dataAffinity = info._dataAffinity == null ? null : (info._dataAffinity instanceof DataAffinity ? info._dataAffinity : null);
        this._isStartedAsMirror = info.getIsStartedAsMirror();
        if (info._connectedClients != null) {
            List list = info._connectedClients;
            synchronized (list) {
                ArrayList list2 = new ArrayList();
                list2.addAll(info._connectedClients);
                this._connectedClients = list2;
            }
        }
    }

    public static NodeInfo ReadNodeInfo(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        byte isNull = reader.readByte();
        if (isNull == 1) {
            return null;
        }
        NodeInfo newInfo = new NodeInfo();
        newInfo.deserialize(reader);
        return newInfo;
    }

    public final Address getAddress() {
        return this._address;
    }

    public final void setAddress(Address value) {
        this._address = value;
    }

    public final Address getRendererAddress() {
        return this._rendererAddress;
    }

    public final void setRendererAddress(Address value) {
        this._rendererAddress = value;
    }

    public final boolean getIsStartedAsMirror() {
        return this._isStartedAsMirror;
    }

    public final void setIsStartedAsMirror(boolean value) {
        this._isStartedAsMirror = value;
    }

    public final boolean getIsInproc() {
        return this._isInproc;
    }

    public final void setIsInproc(boolean value) {
        this._isInproc = value;
    }

    public final String getSubgroupName() {
        return this._subgroupName;
    }

    public final void setSubgroupName(String value) {
        this._subgroupName = value;
    }

    public final DataAffinity getDataAffinity() {
        return this._dataAffinity;
    }

    public final void setDataAffinity(DataAffinity value) {
        this._dataAffinity = value;
    }

    public final CacheStatistics getStatistics() {
        return this._stats;
    }

    public final void setStatistics(CacheStatistics value) {
        this._stats = value;
    }

    public final BitSet getStatus() {
        return this._status;
    }

    public final void setStatus(BitSet value) {
        this._status = value;
    }

    public final List getConnectedClients() {
        return this._connectedClients;
    }

    public final void setConnectedClients(List value) {
        this._connectedClients = value;
    }

    public final boolean getIsActive() {
        return this.getStatus().IsAnyBitSet((byte)4);
    }

    public final int compareTo(Object obj) {
        return this._address.compareTo((Object)((NodeInfo)obj).getAddress());
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public final Object clone() {
        return new NodeInfo(this);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        try {
            ret.append("Node[Adr:" + this._address);
            if (this._stats != null) {
                ret.append(", " + this._stats);
            }
            ret.append("]");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret.toString();
    }

    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._address = Address.readAddress((NCacheObjectInput)reader);
        this._subgroupName = (String)reader.readObject();
        this._stats = CacheStatistics.readCacheStatistics(reader);
        this._status = (BitSet)reader.readObject();
        this._dataAffinity = DataAffinity.readDataAffinity(reader);
        ArrayList list = (ArrayList)reader.readObject();
        if (list != null) {
            this._connectedClients = Collections.synchronizedList(list);
        }
        this._isInproc = reader.readBoolean();
        this._rendererAddress = Address.readAddress((NCacheObjectInput)reader);
        this._isStartedAsMirror = reader.readBoolean();
        this._nodeGuid = (String)reader.readObject();
        this._statsReplicationCounter = reader.readInt();
        this._cacheNodeStatus = CacheNodeStatus.forValue((int)reader.readByte());
        list = (ArrayList)reader.readObject();
        if (list != null) {
            this._localConnectedClientsInfo = Collections.synchronizedList(list);
        }
    }

    public final void serialize(NCacheObjectOutput writer) throws IOException {
        Address.writeAddress((NCacheObjectOutput)writer, (Address)this._address);
        writer.writeObject((Object)this._subgroupName);
        CacheStatistics.writeCacheStatistics(writer, this._stats);
        writer.writeObject((Object)this._status);
        DataAffinity.writeDataAffinity(writer, this._dataAffinity);
        ArrayList arr = null;
        if (this._connectedClients != null) {
            arr = new ArrayList(this._connectedClients);
        }
        writer.writeObject(arr);
        writer.writeBoolean(this._isInproc);
        Address.writeAddress((NCacheObjectOutput)writer, (Address)this._rendererAddress);
        writer.writeBoolean(this._isStartedAsMirror);
        writer.writeObject((Object)this._nodeGuid);
        writer.write(this._statsReplicationCounter);
        writer.write((int)((byte)this._cacheNodeStatus.getValue()));
        arr = null;
        if (this._localConnectedClientsInfo != null) {
            arr = new ArrayList(this._localConnectedClientsInfo);
        }
        writer.writeObject((Object)this._localConnectedClientsInfo);
    }
}

