/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.LockExpiration;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.DataGrouping.GroupInfo;
import Alachisoft.NCache.Caching.DataSourceUpdateOptions;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Queries.Continuous.ContinuousQueryStateInfo;
import Alachisoft.NCache.Caching.Queries.ContinuousQuery;
import Alachisoft.NCache.Caching.Queries.DeleteQueryResultSet;
import Alachisoft.NCache.Caching.Queries.PredicateHolder;
import Alachisoft.NCache.Caching.Queries.QueryDataFilters;
import Alachisoft.NCache.Caching.Queries.QueryResultSet;
import Alachisoft.NCache.Caching.Statistics.BucketStatistics;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResultWithEntry;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.VirtualArray;
import Alachisoft.NCache.Common.Exceptions.SuspectedException;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.LockOptions;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.Common.ResetableIterator;
import Alachisoft.NCache.Common.StreamModes;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.RefObject;

public class CacheSyncWrapper
extends CacheBase {
    private CacheBase _cache;

    public CacheSyncWrapper(CacheBase cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache");
        }
        this._cache = cache;
        this._context = cache.getContext();
        this._syncObj = this._cache.getSync();
    }

    @Override
    public void dispose() {
        if (this._cache != null) {
            this._cache.dispose();
            this._cache = null;
        }
        super.dispose();
    }

    public final CacheBase getInternal() {
        return this._cache;
    }

    @Override
    public CacheBase getInternalCache() {
        return this._cache.getInternalCache();
    }

    @Override
    public TypeInfoMap getTypeInfoMap() {
        return this._cache.getTypeInfoMap();
    }

    @Override
    public String getName() {
        return this.getInternal().getName();
    }

    @Override
    public void setName(String value) {
        this.getInternal().setName(value);
    }

    @Override
    public ICacheEventsListener getListener() {
        return this.getInternal().getListener();
    }

    @Override
    public void setListener(ICacheEventsListener value) {
        this.getInternal().setListener(value);
    }

    @Override
    public int GetItemSize(Object key) {
        return this._cache.GetItemSize(key);
    }

    @Override
    public CacheBase.NotificationWrapper getNotifiers() {
        return this.getInternal().getNotifiers();
    }

    @Override
    public void setNotifiers(CacheBase.NotificationWrapper value) {
        this.getInternal().setNotifiers(value);
    }

    @Override
    public long getCount() throws GeneralFailureException, OperationFailedException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Count_get", (String)"enter");
        }
        try {
            long l = this.getInternal().getCount();
            return l;
        }
        finally {
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Count_get", (String)"exit");
            }
        }
    }

    @Override
    public long getSize() {
        return this.getInternal().getSize();
    }

    @Override
    public long getSessionCount() {
        if (!this.getSync().IsWriterLockHeld()) {
            this.getSync().AcquireReaderLock();
        }
        try {
            long l = this.getInternal().getSessionCount();
            return l;
        }
        finally {
            if (!this.getSync().IsWriterLockHeld()) {
                this.getSync().ReleaseReaderLock();
            }
        }
    }

    @Override
    public CacheStatistics getActualStats() {
        if (!this.getSync().IsWriterLockHeld()) {
            this.getSync().AcquireReaderLock();
        }
        try {
            CacheStatistics cacheStatistics = this.getInternal().getActualStats();
            return cacheStatistics;
        }
        finally {
            if (!this.getSync().IsWriterLockHeld()) {
                this.getSync().ReleaseReaderLock();
            }
        }
    }

    @Override
    public CacheStatistics getStatistics() {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Stats_get", (String)"enter");
        }
        if (!this.getSync().IsWriterLockHeld()) {
            this.getSync().AcquireReaderLock();
        }
        try {
            CacheStatistics cacheStatistics = this.getInternal().getStatistics();
            return cacheStatistics;
        }
        finally {
            if (!this.getSync().IsWriterLockHeld()) {
                this.getSync().ReleaseReaderLock();
            }
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Stats_get", (String)"exit");
            }
        }
    }

    @Override
    public ContinuousQueryStateInfo GetContinuousQueryStateInfo() throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        this.getSync().AcquireReaderLock();
        try {
            ContinuousQueryStateInfo continuousQueryStateInfo = this._cache.GetContinuousQueryStateInfo();
            return continuousQueryStateInfo;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    @Override
    public ArrayList<PredicateHolder> GetContinuousQueryRegisteredPredicates(String type) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        this.getSync().AcquireReaderLock();
        try {
            ArrayList<PredicateHolder> arrayList = this._cache.GetContinuousQueryRegisteredPredicates(type);
            return arrayList;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList GetKeyList(int bucketId, boolean startLogging) {
        this.getSync().AcquireReaderLock();
        try {
            ArrayList arrayList = this._cache.GetKeyList(bucketId, startLogging);
            return arrayList;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    @Override
    public void RemoveBucket(int bucket) throws LockingException, StateTransferException, ClassNotFoundException, IOException, OperationFailedException, CacheException {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.RemoveBucket(bucket);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void RemoveExtraBuckets(ArrayList bucketIds) throws LockingException, StateTransferException, OperationFailedException, CacheException {
        try {
            this.getSync().AcquireWriterLock();
            this._cache.RemoveExtraBuckets(bucketIds);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap GetLogTable(ArrayList bucketIds, RefObject<Boolean> isLoggingStopped) {
        this.getSync().AcquireReaderLock();
        try {
            HashMap hashMap = this._cache.GetLogTable(bucketIds, isLoggingStopped);
            return hashMap;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    @Override
    public void setBucketSize(int value) {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.setBucketSize(value);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void RemoveBucketData(int bucketId) throws LockingException, StateTransferException, OperationFailedException, CacheException {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.RemoveBucketData(bucketId);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void AddLoggedData(ArrayList bucketIds) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.AddLoggedData(bucketIds);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void UpdateLocalBuckets(ArrayList bucketIds) {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.UpdateLocalBuckets(bucketIds);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void RemoveFromLogTbl(int bucketId) {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.RemoveFromLogTbl(bucketId);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void StartLogging(int bucketId) {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.StartLogging(bucketId);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public BucketStatistics[] getLocalBuckets() {
        this.getSync().AcquireReaderLock();
        try {
            BucketStatistics[] bucketStatisticsArray = this._cache.getLocalBuckets();
            return bucketStatisticsArray;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    @Override
    public void setLocalBuckets(BucketStatistics[] value) {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.setLocalBuckets(value);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public float getEvictRatio() {
        return this.getInternal().getEvictRatio();
    }

    @Override
    public void setEvictRatio(float value) {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().setEvictRatio(value);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public boolean CanChangeCacheSize(long size) {
        return this.getInternal().CanChangeCacheSize(size);
    }

    @Override
    public long getMaxSize() {
        this.getSync().AcquireReaderLock();
        try {
            long l = this.getInternal().getMaxSize();
            return l;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    @Override
    public void setMaxSize(long value) throws Exception {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().setMaxSize(value);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void UpdateClientsList(HashMap list) {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().UpdateClientsList(list);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public boolean AcceptClient(InetAddress clientAddress) {
        this.getSync().AcquireWriterLock();
        try {
            boolean bl = this.getInternal().AcceptClient(clientAddress);
            return bl;
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void DisconnectClient(InetAddress clientAddress) {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().DisconnectClient(clientAddress);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void Clear(CallbackEntry cbEntry, DataSourceUpdateOptions updateOptions, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        this.Clear(cbEntry, updateOptions, null, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Clear(CallbackEntry cbEntry, DataSourceUpdateOptions updateOptions, String taskId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Clear", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().Clear(cbEntry, updateOptions, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Clear", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean Contains(Object key, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Cont", (String)"enter");
        }
        if (!this.getSync().IsWriterLockHeld()) {
            this.getSync().AcquireReaderLock();
        }
        try {
            boolean bl = this.getInternal().Contains(key, operationContext);
            return bl;
        }
        finally {
            if (!this.getSync().IsWriterLockHeld()) {
                this.getSync().ReleaseReaderLock();
            }
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Cont", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Contains(Object[] keys, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.ContBlk", (String)"enter");
        }
        if (!this.getSync().IsWriterLockHeld()) {
            this.getSync().AcquireReaderLock();
        }
        try {
            HashMap hashMap = this.getInternal().Contains(keys, operationContext);
            return hashMap;
        }
        finally {
            if (!this.getSync().IsWriterLockHeld()) {
                this.getSync().ReleaseReaderLock();
            }
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.ContBlk", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void UpdateLockInfo(Object key, Object lockId, Date lockDate, LockExpiration lockExpiration, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.UpdLock", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().UpdateLockInfo(key, lockId, lockDate, lockExpiration, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.UpdLock", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry Get(Object key, boolean IsUserOperation, RefObject<Long> version, RefObject<Object> lockId, RefObject<Date> lockDate, LockExpiration lockExpiration, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        CacheEntry entry = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Get_2", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            entry = this.getInternal().Get(key, IsUserOperation, version, lockId, lockDate, lockExpiration, accessType, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Get_2", (String)"exit");
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry Get(Object key, RefObject<Long> version, RefObject<Object> lockId, RefObject<Date> lockDate, LockExpiration lockExpiration, LockAccessType access, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        CacheEntry entry = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Get_2", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            entry = this.getInternal().Get(key, version, lockId, lockDate, lockExpiration, access, operationContext);
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Get_2", (String)"exit");
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap GetTagData(String[] tags, TagComparisonType comparisonType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        HashMap tbl = null;
        this.getSync().AcquireReaderLock();
        try {
            tbl = this.getInternal().GetTagData(tags, comparisonType, operationContext);
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
        return tbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Remove(String[] tags, TagComparisonType tagComparisonType, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap removedKeys = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemoveByTag", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            removedKeys = this.getInternal().Remove(tags, tagComparisonType, notify, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemoveByTag", (String)"exit");
            }
        }
        return removedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList GetTagKeys(String[] tags, TagComparisonType comparisonType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        ArrayList keys = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetTagInternal", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            keys = this.getInternal().GetTagKeys(tags, comparisonType, operationContext);
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetTagInternal", (String)"exit");
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockOptions IsLocked(Object key, RefObject<Object> lockId, RefObject<Date> lockDate, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        LockOptions lockInfo = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.IsLock", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            lockInfo = this.getInternal().IsLocked(key, lockId, lockDate, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.IsLock", (String)"exit");
            }
        }
        return lockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockOptions Lock(Object key, LockExpiration lockExpiration, RefObject<Object> lockId, RefObject<Date> lockDate, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        LockOptions lockInfo = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Lock", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            lockInfo = this.getInternal().Lock(key, lockExpiration, lockId, lockDate, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Lock", (String)"exit");
            }
        }
        return lockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void UnLock(Object key, Object lockId, boolean isPreemptive, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Unlock", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().UnLock(key, lockId, isPreemptive, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Unlock", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Get(Object[] keys, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetBlk", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            HashMap hashMap = this.getInternal().Get(keys, operationContext);
            return hashMap;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetBlk", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList GetGroupKeys(String group, String subGroup, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpKeys", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            ArrayList arrayList = this.getInternal().GetGroupKeys(group, subGroup, operationContext);
            return arrayList;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpKeys", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry GetGroup(Object key, String group, String subGroup, RefObject<Long> version, RefObject<Object> lockId, RefObject<Date> lockDate, LockExpiration lockExpiration, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        CacheEntry entry = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrp", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            entry = this.getInternal().GetGroup(key, group, subGroup, version, lockId, lockDate, lockExpiration, accessType, operationContext);
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrp", (String)"exit");
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupInfo GetGroupInfo(Object key, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpInfo", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            GroupInfo groupInfo = this.getInternal().GetGroupInfo(key, operationContext);
            return groupInfo;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpInf", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap GetGroupInfoBulk(Object[] keys, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpInfBlk", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            HashMap hashMap = this.getInternal().GetGroupInfoBulk(keys, operationContext);
            return hashMap;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpInfBlk", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap GetGroupData(String group, String subGroup, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpData", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            HashMap hashMap = this.getInternal().GetGroupData(group, subGroup, operationContext);
            return hashMap;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.GetGrpData", (String)"exit");
            }
        }
    }

    @Override
    public ArrayList getDataGroupList() {
        this.getSync().AcquireWriterLock();
        try {
            ArrayList arrayList = this.getInternal().getDataGroupList();
            return arrayList;
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public CacheAddResult Add(Object key, CacheEntry cacheEntry, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException, SuspectedException, TimeoutException {
        return this.Add(key, cacheEntry, notify, null, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheAddResult Add(Object key, CacheEntry cacheEntry, boolean notify, String taskId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException, SuspectedException, TimeoutException {
        boolean replicateToBridge = this._context.getCacheImpl().getReplicateToBridge();
        boolean isBridgeOperation = this.IsBridgeOperation(operationContext);
        boolean requiresReplication = this._context.getCacheImpl().getRequiresReplication();
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_1", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            CacheAddResult cacheAddResult = this.getInternal().Add(key, cacheEntry, notify, operationContext);
            return cacheAddResult;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_1", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheAddResult Add(Object key, CacheEntry cacheEntry, boolean notify, boolean IsUserOperation, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_2", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            CacheAddResult result;
            CacheAddResult cacheAddResult = result = this.getInternal().Add(key, cacheEntry, notify, IsUserOperation, operationContext);
            return cacheAddResult;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_2", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean Add(Object key, ExpirationHint eh, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        boolean depAdded = false;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_3", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            depAdded = this.getInternal().Add(key, eh, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_3", (String)"exit");
            }
        }
        return depAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean Add(Object key, CacheSyncDependency syncDependency, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        boolean depAdded = false;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_4", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            depAdded = this.getInternal().Add(key, syncDependency, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Add_4", (String)"exit");
            }
        }
        return depAdded;
    }

    @Override
    public HashMap Add(Object[] keys, CacheEntry[] cacheEntries, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Add(keys, cacheEntries, notify, null, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Add(Object[] keys, CacheEntry[] cacheEntries, boolean notify, String taskId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap result = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.AddBlk", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            result = this.getInternal().Add(keys, cacheEntries, notify, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.AddBlk", (String)"exit");
            }
        }
        return result;
    }

    @Override
    public CacheInsResultWithEntry Insert(Object key, CacheEntry cacheEntry, boolean notify, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Insert(key, cacheEntry, notify, null, lockId, version, accessType, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheInsResultWithEntry Insert(Object key, CacheEntry cacheEntry, boolean notify, String taskId, Object lockId, long version, LockAccessType access, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Insert_1", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            CacheInsResultWithEntry result;
            CacheInsResultWithEntry cacheInsResultWithEntry = result = this.getInternal().Insert(key, cacheEntry, notify, lockId, version, access, operationContext);
            return cacheInsResultWithEntry;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Insert_1", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheInsResultWithEntry Insert(Object key, CacheEntry cacheEntry, boolean notify, boolean IsUserOperation, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Insert_2", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            CacheInsResultWithEntry result;
            CacheInsResultWithEntry cacheInsResultWithEntry = result = this.getInternal().Insert(key, cacheEntry, notify, IsUserOperation, lockId, version, accessType, operationContext);
            return cacheInsResultWithEntry;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Insert_2", (String)"exit");
            }
        }
    }

    @Override
    public HashMap Insert(Object[] keys, CacheEntry[] cacheEntries, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Insert(keys, cacheEntries, notify, null, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Insert(Object[] keys, CacheEntry[] cacheEntries, boolean notify, String taskId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap result = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.InsertBlk", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            result = this.getInternal().Insert(keys, cacheEntries, notify, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.InsertBlk", (String)"exit");
            }
        }
        return result;
    }

    @Override
    public CacheEntry Remove(Object key, ItemRemoveReason ir, boolean notify, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Remove(key, ir, notify, null, lockId, version, accessType, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry Remove(Object key, ItemRemoveReason ir, boolean notify, String taskId, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        CacheEntry entry = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_1", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            entry = this.getInternal().Remove(key, ir, notify, lockId, version, accessType, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_1", (String)"exit");
            }
        }
        return entry;
    }

    @Override
    public HashMap Remove(Object[] keys, ItemRemoveReason ir, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.Remove(keys, ir, notify, null, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Remove(Object[] keys, ItemRemoveReason ir, boolean notify, String taskId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemoveBlk", (String)"enter");
        }
        HashMap result = null;
        Object successfulKeys = null;
        this.getSync().AcquireWriterLock();
        try {
            result = this.getInternal().Remove(keys, ir, notify, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemoveBlk", (String)"exit");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Cascaded_remove(HashMap keyValues, ItemRemoveReason ir, boolean notify, boolean isUserOperation, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap removedItems = new HashMap();
        ArrayList removedItemsList = new ArrayList();
        if (keyValues != null) {
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_3", (String)"enter");
            }
            this.getSync().AcquireWriterLock();
            try {
                for (Map.Entry KeyValue : keyValues.entrySet()) {
                    CacheEntry e = KeyValue.getValue() instanceof CacheEntry ? KeyValue.getValue() : null;
                    if (e == null || e.getKeysDependingOnMe() == null) continue;
                    HashMap entriesTable = new HashMap();
                    Object[] nextRemovalKeys = new String[e.getKeysDependingOnMe().size()];
                    System.arraycopy(e.getKeysDependingOnMe().keySet().toArray(), 0, nextRemovalKeys, 0, e.getKeysDependingOnMe().keySet().size());
                    while (nextRemovalKeys != null && nextRemovalKeys.length > 0) {
                        Iterator ide2;
                        entriesTable = this.Remove(nextRemovalKeys, ir, notify, operationContext);
                        if (entriesTable != null && (ide2 = entriesTable.entrySet().iterator()).hasNext() && (KeyValue = ide2.next()).getValue() != null) {
                            removedItems.put(KeyValue.getKey(), KeyValue.getKey());
                            removedItemsList.add(KeyValue.getKey());
                        }
                        nextRemovalKeys = this.ExtractKeys(entriesTable);
                    }
                }
            }
            finally {
                this.getSync().ReleaseWriterLock();
                if (ServerMonitor.getMonitorActivity()) {
                    ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_3", (String)"exit");
                }
            }
        }
        return removedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Remove(Object[] keys, ItemRemoveReason ir, boolean notify, boolean isUserOperation, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap result = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_4", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            result = this.getInternal().Remove(keys, ir, notify, isUserOperation, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_4", (String)"exit");
            }
        }
        return result;
    }

    @Override
    public Object RemoveSync(Object[] keys, ItemRemoveReason reason, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        return this.getInternal().RemoveSync(keys, reason, notify, operationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry Remove(Object key, ItemRemoveReason ir, boolean notify, boolean isUserOperation, Object lockId, long version, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        CacheEntry entry = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_5", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            entry = this.getInternal().Remove(key, ir, notify, isUserOperation, lockId, version, accessType, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Remove_5", (String)"exit");
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap Remove(String group, String subGroup, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        HashMap result = null;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemoveGrp", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            result = this.getInternal().Remove(group, subGroup, notify, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemoveGrp", (String)"exit");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet Search(String query, Map values, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().Search(query, values, operationContext);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet SearchEntries(String query, Map values, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.SearchEnt", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().SearchEntries(query, values, operationContext);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.SearchEnt", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet SearchCQ(ContinuousQuery query, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().SearchCQ(query, operationContext);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet SearchCQ(String query, Map values, String clientUniqueId, String clientId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, OperationContext operationContext, QueryDataFilters datafilters) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().SearchCQ(query, values, clientUniqueId, clientId, notifyAdd, notifyUpdate, notifyRemove, operationContext, datafilters);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet SearchCQ(String queryId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().SearchCQ(queryId, operationContext);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet SearchEntriesCQ(String queryId, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().SearchEntriesCQ(queryId, operationContext);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet SearchEntriesCQ(String query, Map values, String clientUniqueId, String clientId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, OperationContext operationContext, QueryDataFilters datafilters) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().SearchEntriesCQ(query, values, clientUniqueId, clientId, notifyAdd, notifyUpdate, notifyRemove, operationContext, datafilters);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResultSet SearchEntriesCQ(ContinuousQuery query, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            QueryResultSet queryResultSet = this.getInternal().SearchEntriesCQ(query, operationContext);
            return queryResultSet;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.Search", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteQueryResultSet DeleteQuery(String query, Map values, boolean notify, boolean isUserOperation, ItemRemoveReason reason, OperationContext operationContext) throws Exception {
        DeleteQueryResultSet result = new DeleteQueryResultSet();
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.DeleteQueryEnt", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            result = this.getInternal().DeleteQuery(query, values, notify, isUserOperation, reason, operationContext);
            result.setKeysEffected(null);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.DeleteQueryEnt", (String)"exit");
            }
        }
        return result;
    }

    @Override
    public void SendNotification(Object notifId, Object data) {
        this.getInternal().SendNotification(notifId, data);
    }

    @Override
    public ResetableIterator GetEnumerator() throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        this.getSync().AcquireWriterLock();
        try {
            ResetableIterator resetableIterator = this.getInternal().GetEnumerator();
            return resetableIterator;
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumerationDataChunk GetNextChunk(EnumerationPointer pointer, OperationContext operationContext) throws GeneralFailureException, TimeoutException, SuspectedException, CacheException {
        this.getSync().AcquireWriterLock();
        try {
            EnumerationDataChunk enumerationDataChunk = this.getInternal().GetNextChunk(pointer, operationContext);
            return enumerationDataChunk;
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public boolean HasEnumerationPointer(EnumerationPointer pointer) {
        this.getSync().AcquireWriterLock();
        try {
            boolean bl = this.getInternal().HasEnumerationPointer(pointer);
            return bl;
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void RegisterKeyNotification(String key, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, SuspectedException, TimeoutException {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().RegisterKeyNotification(key, updateCallback, removeCallback, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void RegisterKeyNotification(String[] keys, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, CacheException, LockingException, SuspectedException, TimeoutException {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().RegisterKeyNotification(keys, updateCallback, removeCallback, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void UnregisterKeyNotification(String key, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().UnregisterKeyNotification(key, updateCallback, removeCallback, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void UnregisterKeyNotification(String[] keys, CallbackInfo updateCallback, CallbackInfo removeCallback, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().UnregisterKeyNotification(keys, updateCallback, removeCallback, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap AddDepKeyList(HashMap table, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.AddDepKey", (String)"enter");
        }
        HashMap result = null;
        this.getSync().AcquireWriterLock();
        try {
            result = this.getInternal().AddDepKeyList(table, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.AddDepKey", (String)"exit");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap RemoveDepKeyList(HashMap table, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemDepKey", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            HashMap hashMap = this.getInternal().RemoveDepKeyList(table, operationContext);
            return hashMap;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RemDepKey", (String)"exit");
            }
        }
    }

    @Override
    public void SetStateTransferKeyList(HashMap keylist) {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.SetStateTransferKeyList(keylist);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    @Override
    public void UnSetStateTransferKeyList() {
        this.getSync().AcquireWriterLock();
        try {
            this._cache.UnSetStateTransferKeyList();
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean OpenStream(String key, String lockHandle, StreamModes mode, String group, String subGroup, ExpirationHint hint, EvictionHint evictinHint, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException, SuspectedException, TimeoutException {
        boolean lockAcquired = false;
        boolean requiresReplication = this._context.getCacheImpl().getRequiresReplication();
        this.getSync().AcquireWriterLock();
        try {
            lockAcquired = this.getInternalCache().OpenStream(key, lockHandle, mode, group, subGroup, hint, evictinHint, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
        return lockAcquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void CloseStream(String key, String lockHandle, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException, TimeoutException, SuspectedException {
        boolean requiresReplication = this._context.getCacheImpl().getRequiresReplication();
        this.getSync().AcquireWriterLock();
        try {
            this.getInternalCache().CloseStream(key, lockHandle, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ReadFromStream(RefObject<VirtualArray> vBuffer, String key, String lockHandle, int offset, int length, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException, TimeoutException, SuspectedException {
        try {
            this.getSync().AcquireReaderLock();
            int n = this.getInternalCache().ReadFromStream(vBuffer, key, lockHandle, offset, length, operationContext);
            return n;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void WriteToStream(String key, String lockHandle, VirtualArray vBuffer, int srcOffset, int dstOffset, int length, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException, SuspectedException, TimeoutException {
        this.getSync().AcquireWriterLock();
        try {
            this.getInternalCache().WriteToStream(key, lockHandle, vBuffer, srcOffset, dstOffset, length, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long GetStreamLength(String key, String lockHandle, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StreamException, CacheException, SuspectedException, TimeoutException {
        try {
            this.getSync().AcquireReaderLock();
            long l = this.getInternalCache().GetStreamLength(key, lockHandle, operationContext);
            return l;
        }
        finally {
            this.getSync().ReleaseReaderLock();
        }
    }

    private boolean IsBridgeOperation(OperationContext operationContext) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void UnRegisterCQ(String serverUniqueId, String clientUniqueId, String clientId) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.UnRegisterCQ", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().UnRegisterCQ(serverUniqueId, clientUniqueId, clientId);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.UnRegisterCQ", (String)"exit");
            }
        }
    }

    @Override
    public void UnRegisterCQ(String queryId) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.UnRegisterCQ", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().UnRegisterCQ(queryId);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.UnRegisterCQ", (String)"exit");
            }
        }
    }

    @Override
    public void RegisterCQ(ContinuousQuery query, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RegisterCQ", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            this.getInternal().RegisterCQ(query, operationContext);
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RegisterCQ", (String)"exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String RegisterCQ(String query, Map values, String clientUniqueId, String clientId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, OperationContext operationContext, QueryDataFilters datafilters) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RegisterCQ", (String)"enter");
        }
        this.getSync().AcquireWriterLock();
        try {
            String string = this.getInternal().RegisterCQ(query, values, clientUniqueId, clientId, notifyAdd, notifyUpdate, notifyRemove, operationContext, datafilters);
            return string;
        }
        finally {
            this.getSync().ReleaseWriterLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.RegisterCQ", (String)"exit");
            }
        }
    }

    @Override
    public ActiveQueryAnalyzer getQueryAnalyzer() {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"CacheSyncWrp.QueryAnalyzer", (String)"enter");
        }
        this.getSync().AcquireReaderLock();
        try {
            ActiveQueryAnalyzer activeQueryAnalyzer = this.getInternal().getQueryAnalyzer();
            return activeQueryAnalyzer;
        }
        finally {
            this.getSync().ReleaseReaderLock();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"CacheSyncWrp.QueryAnalyzer", (String)"exit");
            }
        }
    }
}

