/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.Dom;

import Alachisoft.NCache.Common.CaseInsensitiveMap;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.Dom.Channel;
import Alachisoft.NCache.Config.Dom.Cluster;
import Alachisoft.NCache.Config.NewDom.AlertsNotifications;
import Alachisoft.NCache.Config.NewDom.AlertsTypes;
import Alachisoft.NCache.Config.NewDom.Attrib;
import Alachisoft.NCache.Config.NewDom.AttributeListUnion;
import Alachisoft.NCache.Config.NewDom.BackingSource;
import Alachisoft.NCache.Config.NewDom.BatchConfig;
import Alachisoft.NCache.Config.NewDom.BridgeConfig;
import Alachisoft.NCache.Config.NewDom.BridgeConflictResolver;
import Alachisoft.NCache.Config.NewDom.CacheLoader;
import Alachisoft.NCache.Config.NewDom.Class;
import Alachisoft.NCache.Config.NewDom.Cleanup;
import Alachisoft.NCache.Config.NewDom.CompactClass;
import Alachisoft.NCache.Config.NewDom.CompactSerialization;
import Alachisoft.NCache.Config.NewDom.Compression;
import Alachisoft.NCache.Config.NewDom.DataSharing;
import Alachisoft.NCache.Config.NewDom.EmailNotifications;
import Alachisoft.NCache.Config.NewDom.Encryption;
import Alachisoft.NCache.Config.NewDom.EvictionPolicy;
import Alachisoft.NCache.Config.NewDom.GenericArgumentType;
import Alachisoft.NCache.Config.NewDom.Log;
import Alachisoft.NCache.Config.NewDom.NotificationRecipient;
import Alachisoft.NCache.Config.NewDom.Notifications;
import Alachisoft.NCache.Config.NewDom.Parameter;
import Alachisoft.NCache.Config.NewDom.PerfCounters;
import Alachisoft.NCache.Config.NewDom.PortableAttribute;
import Alachisoft.NCache.Config.NewDom.PortableClass;
import Alachisoft.NCache.Config.NewDom.Provider;
import Alachisoft.NCache.Config.NewDom.ProviderAssembly;
import Alachisoft.NCache.Config.NewDom.QueryIndex;
import Alachisoft.NCache.Config.NewDom.Readthru;
import Alachisoft.NCache.Config.NewDom.ReplicationStrategy;
import Alachisoft.NCache.Config.NewDom.SQLDependencyConfig;
import Alachisoft.NCache.Config.NewDom.Security;
import Alachisoft.NCache.Config.NewDom.Storage;
import Alachisoft.NCache.Config.NewDom.Type;
import Alachisoft.NCache.Config.NewDom.User;
import Alachisoft.NCache.Config.NewDom.WriteBehind;
import Alachisoft.NCache.Config.NewDom.Writethru;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ConfigConverter {
    public static HashMap ToHashMap(CacheServerConfig config) {
        return DomToHashMap.GetConfig(config);
    }

    public static HashMap ToHashMap(CacheServerConfig[] configs) {
        return DomToHashMap.GetConfig(configs);
    }

    public static CacheServerConfig[] ToDom(HashMap config) {
        return HashMapToDom.GetConfig(config);
    }

    private static class DomToHashMap {
        private DomToHashMap() {
        }

        public static HashMap GetCacheConfiguration(CacheServerConfig cache) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("type", "cache-configuration");
            config.put("id", cache.getName());
            config.put("cache", DomToHashMap.GetCache(cache));
            config.put("web-cache", DomToHashMap.GetWebCache(cache));
            if (cache.getDataSharing() != null) {
                config.put("data-sharing", DomToHashMap.GetDataSharing(cache.getDataSharing()));
            }
            if (cache.getCompactSerialization() != null) {
                config.put("compact-serialization", DomToHashMap.GetCompactSerialization(cache.getCompactSerialization()));
            }
            return config;
        }

        private static HashMap GetDataSharing(DataSharing dataSharing) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            Type[] typeArray = dataSharing.getTypes();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type typeObj;
                Type type = typeObj = typeArray[i];
                settings.put(type.getID(), DomToHashMap.GetDataSharingCompactType(type));
            }
            return settings;
        }

        private static HashMap GetCompactSerialization(CompactSerialization compactSerialization) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            for (CompactClass cls : compactSerialization.getCompactClassListAsArray()) {
                settings.put(cls.getID(), DomToHashMap.GetCompactClass(cls));
            }
            return settings;
        }

        private static HashMap GetDataSharingCompactType(Type type) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("name", type.getName());
            settings.put("portable", type.getPortable());
            settings.put("id", type.getID());
            if (type.getPortableClasses() != null) {
                settings.put("known-classes", DomToHashMap.GetDataSharingPortableClasses(type.getPortableClasses()));
                settings.put("attribute-union-list", DomToHashMap.GetCompactAttributeListUnion(type.getAttributeList()));
            }
            return settings;
        }

        private static HashMap GetCompactClass(CompactClass cls) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("id", cls.getID());
            settings.put("name", cls.getName());
            settings.put("assembly", cls.getAssembly());
            settings.put("portable", cls.getPortable());
            settings.put("type", cls.getType());
            settings.put("generic-id", cls.getGenericId());
            settings.put("is-generic", cls.getIsGeneric());
            settings.put("num-of-args", cls.getNumberOfArgs());
            HashMap<String, HashMap> argTypes = null;
            if (cls.getIsGeneric() && cls.getGenericArgumentTypeList() != null) {
                argTypes = new HashMap<String, HashMap>();
                for (GenericArgumentType gat : cls.getGenericArgumentTypeList()) {
                    argTypes.put(gat.getID(), DomToHashMap.GetArgumentType(gat));
                }
                settings.put("arg-types", argTypes);
            }
            HashMap nonCompactFields = null;
            if (cls.getNonCompactFieldsTable().size() > 0) {
                nonCompactFields = new HashMap();
                for (Attrib attrib : cls.getNonCompactFields()) {
                    HashMap<String, String> nonCompactAttributes = new HashMap<String, String>();
                    nonCompactAttributes.put("name", attrib.getName());
                    nonCompactAttributes.put("type", attrib.getType());
                    nonCompactAttributes.put("id", attrib.getID());
                    nonCompactFields.put(attrib.getID(), nonCompactAttributes);
                }
                settings.put("non-compact-fields", nonCompactFields);
            }
            return settings;
        }

        private static HashMap GetArgumentType(GenericArgumentType gat) {
            HashMap concreteArgTypes = new HashMap(gat.getGenericArgsCompactTypeList().size());
            HashMap<String, Object> concreteArgType = null;
            if (gat.getGenericArgsCompactTypeList() != null) {
                for (CompactClass cls : gat.getGenericArgsCompactTypeList()) {
                    concreteArgType = new HashMap<String, Object>();
                    concreteArgType.put("id", cls.getID());
                    concreteArgType.put("name", cls.getName());
                    concreteArgType.put("assembly", cls.getAssembly());
                    concreteArgType.put("portable", cls.getPortable());
                    concreteArgType.put("type", cls.getType());
                    concreteArgType.put("generic-id", cls.getGenericId());
                    concreteArgType.put("is-generic", cls.getIsGeneric());
                    concreteArgType.put("num-of-args", cls.getNumberOfArgs());
                    HashMap<String, HashMap> argTypes = null;
                    if (cls.getIsGeneric() && cls.getGenericArgumentTypeList() != null) {
                        argTypes = new HashMap<String, HashMap>();
                        for (GenericArgumentType gat2 : cls.getGenericArgumentTypeList()) {
                            argTypes.put(gat2.getID(), DomToHashMap.GetArgumentType(gat2));
                        }
                        concreteArgType.put("arg-types", argTypes);
                    }
                    concreteArgTypes.put(cls.getID(), concreteArgType);
                }
            }
            return concreteArgTypes;
        }

        private static HashMap GetCompactType(Type type) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("name", type.getName());
            settings.put("portable", type.getPortable());
            settings.put("id", type.getID());
            if (type.getPortableClasses() != null) {
                settings.put("known-classes", DomToHashMap.GetCompactPortableClasses(type.getPortableClasses()));
            }
            return settings;
        }

        private static HashMap GetCompactAttributeListUnion(AttributeListUnion attributeList) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            if (attributeList != null && attributeList.getPortableAttributes() != null) {
                settings.put("attribute", DomToHashMap.GetCompactPortableAttributes(attributeList.getPortableAttributes()));
            }
            return settings;
        }

        private static HashMap GetDataSharingPortableClasses(PortableClass[] classes) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            for (PortableClass clas : classes) {
                settings.put(clas.getName(), DomToHashMap.GetDataSharingPortableClass(clas));
            }
            return settings;
        }

        private static HashMap GetCompactPortableClasses(PortableClass[] classes) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            for (PortableClass clas : classes) {
                settings.put(clas.getName(), DomToHashMap.GetCompactPortableClass(clas));
            }
            return settings;
        }

        private static HashMap GetDataSharingPortableClass(PortableClass clas) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("name", clas.getName());
            if (clas.getID() != null) {
                settings.put("handle-id", clas.getID());
            }
            settings.put("assembly", clas.getAssembly());
            settings.put("type", clas.getType());
            if (clas.getPortableAttributes() != null) {
                settings.put("attribute", DomToHashMap.GetCompactPortableAttributes(clas.getPortableAttributes()));
            }
            return settings;
        }

        private static HashMap GetCompactPortableClass(PortableClass clas) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("name", clas.getName());
            if (clas.getID() != null) {
                settings.put("handle-id", clas.getID());
            }
            settings.put("assembly", clas.getAssembly());
            settings.put("type", clas.getType());
            if (clas.getPortableAttributes() != null) {
                settings.put("attribute", DomToHashMap.GetCompactPortableAttributes(clas.getPortableAttributes()));
            }
            return settings;
        }

        private static HashMap GetCompactPortableAttributes(PortableAttribute[] attributes) {
            HashMap<CallSite, HashMap> settings = new HashMap<CallSite, HashMap>();
            for (PortableAttribute attrib : attributes) {
                settings.put((CallSite)((Object)(attrib.getName() + ":" + attrib.getType())), DomToHashMap.GetCompactPortableAttribute(attrib));
            }
            return settings;
        }

        private static HashMap GetCompactPortableAttribute(PortableAttribute attrib) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("name", attrib.getName());
            settings.put("type", attrib.getType());
            settings.put("order", attrib.getOrder());
            return settings;
        }

        public static HashMap GetWebCache(CacheServerConfig cache) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("shared", new Boolean(!cache.getInProc()).toString().toLowerCase());
            settings.put("cache-id", cache.getName());
            return settings;
        }

        public static HashMap GetCache(CacheServerConfig cache) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("name", cache.getName());
            if (cache.getLog() != null) {
                settings.put("log", DomToHashMap.GetLog(cache.getLog()));
            }
            settings.put("config-id", cache.getConfigID());
            if (cache.getLastModified() != null) {
                settings.put("last-modified", cache.getLastModified());
            }
            settings.put("auto-start", cache.getAutoStartCacheOnServiceStartup());
            settings.put("cache-classes", DomToHashMap.GetCacheClasses(cache));
            settings.put("class", cache.getName());
            if (cache.getPerfCounters() != null) {
                settings.put("perf-counters", cache.getPerfCounters().getEnabled());
            }
            if (cache.getSecurity() != null && cache.getSecurity().getEnabled()) {
                settings.put("security", DomToHashMap.GetSecurity(cache.getSecurity()));
            }
            if (cache.getEncryption() != null && cache.getEncryption().getEnabled()) {
                settings.put("encryption", DomToHashMap.GetEncryption(cache.getEncryption()));
            }
            if (cache.getReplicationStrategy() != null) {
                settings.put("replication-strategy", DomToHashMap.GetReplicationStrategy(cache.getReplicationStrategy()));
            }
            if (cache.getSQLDependencyConfig() != null) {
                settings.put("sql-dependency", DomToHashMap.GetSQLDependency(cache.getSQLDependencyConfig()));
            }
            if (cache.getAlertsNotifications() != null) {
                settings.put("alerts", DomToHashMap.GetAlerts(cache.getAlertsNotifications()));
            }
            if (cache.getCompression() != null) {
                settings.put("compression", DomToHashMap.GetCompression(cache.getCompression()));
            }
            if (cache.getBackingSource() != null) {
                settings.put("backing-source", DomToHashMap.GetBackingSource(cache.getBackingSource()));
            }
            if (cache.getCacheLoader() != null) {
                settings.put("cache-loader", DomToHashMap.GetCacheLoader(cache.getCacheLoader()));
            }
            if (cache.getConflictResolver() != null) {
                settings.put("conflict-resolver", DomToHashMap.GetConflictResolver(cache.getConflictResolver()));
            }
            if (cache.getBridge() != null) {
                settings.put("bridge", DomToHashMap.GetBridge(cache.getBridge()));
            }
            return settings;
        }

        private static HashMap GetBackingSource(BackingSource backingSource) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            if (backingSource.getReadthru() != null) {
                settings.put("read-thru", DomToHashMap.GetReadThru(backingSource.getReadthru()));
            }
            if (backingSource.getWritethru() != null) {
                settings.put("write-thru", DomToHashMap.GetWriteThru(backingSource.getWritethru()));
            }
            return settings;
        }

        private static HashMap GetCacheLoader(CacheLoader CL) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            if (CL.getProvider() != null) {
                settings.put("assembly", CL.getProvider().getAssemblyName());
                settings.put("classname", CL.getProvider().getClassName());
                settings.put("full-name", CL.getProvider().getFullProviderName());
                settings.put("retries", CL.getRetries());
                settings.put("retry-interval", CL.getRetryInterval());
                settings.put("enabled", CL.getEnabled());
                if (CL.getParameters() != null) {
                    settings.put("parameters", DomToHashMap.GetParameters(CL.getParameters()));
                }
            }
            return settings;
        }

        private static HashMap GetConflictResolver(BridgeConflictResolver bridgeConflictResolver) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            if (bridgeConflictResolver.getProvider() != null) {
                settings.put("assembly-name", bridgeConflictResolver.getProvider().getAssemblyName());
                settings.put("class-name", bridgeConflictResolver.getProvider().getClassName());
                settings.put("full-name", bridgeConflictResolver.getProvider().getFullProviderName());
                settings.put("deserialize", bridgeConflictResolver.getDeserializedValue());
                settings.put("enabled", bridgeConflictResolver.getEnabled());
                if (bridgeConflictResolver.getParameters() != null) {
                    settings.put("parameters", DomToHashMap.GetParameters(bridgeConflictResolver.getParameters()));
                }
            }
            return new HashMap();
        }

        private static HashMap GetWriteThru(Writethru writethru) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("enabled", new Boolean(writethru.getEnabled()).toString());
            if (writethru.getProviders() != null) {
                settings.put("write-thru-providers", DomToHashMap.GetProviders(writethru.getProviders()));
            }
            if (writethru.getWriteBehind() != null) {
                settings.put("write-behind", DomToHashMap.GetWriteBehind(writethru.getWriteBehind()));
            }
            return settings;
        }

        private static HashMap GetWriteBehind(WriteBehind writeBehind) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            if (writeBehind != null) {
                settings.put("mode", writeBehind.getMode());
                settings.put("throttling-rate-per-sec", writeBehind.getThrottling());
                settings.put("failed-operations-queue-limit", writeBehind.getRequeueLimit());
                settings.put("failed-operations-eviction-ratio", writeBehind.getEviction());
                if (writeBehind.getBatchConfig() != null) {
                    settings.put("batch-mode-config", DomToHashMap.GetBatchConfig(writeBehind.getBatchConfig()));
                }
            }
            return settings;
        }

        private static HashMap GetBatchConfig(BatchConfig batchConfig) {
            HashMap<String, String> settings = new HashMap<String, String>();
            if (batchConfig != null) {
                settings.put("batch-interval", batchConfig.getBatchInterval());
                settings.put("operation-delay", batchConfig.getOperationDelay());
            }
            return settings;
        }

        private static HashMap GetReadThru(Readthru readthru) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("enabled", new Boolean(readthru.getEnabled()).toString());
            if (readthru.getProviders() != null) {
                settings.put("read-thru-providers", DomToHashMap.GetProviders(readthru.getProviders()));
            }
            return settings;
        }

        private static HashMap GetProviders(Provider[] providers) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            if (providers != null && providers.length > 0) {
                for (int i = 0; i < providers.length; ++i) {
                    settings.put(providers[i].getProviderName(), DomToHashMap.GetProvider(providers[i]));
                }
            }
            return settings;
        }

        private static HashMap GetProvider(Provider provider) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            if (provider != null) {
                settings.put("provider-name", provider.getProviderName());
                settings.put("assembly-name", provider.getAssemblyName());
                settings.put("class-name", provider.getClassName());
                settings.put("full-name", provider.getFullProviderName());
                settings.put("default-provider", new Boolean(provider.getIsDefaultProvider()).toString());
                HashMap paramss = DomToHashMap.GetParameters(provider.getParameters());
                if (paramss != null) {
                    settings.put("parameters", paramss);
                }
            }
            return settings;
        }

        private static HashMap GetParameters(Parameter[] parameters) {
            if (parameters == null) {
                return null;
            }
            HashMap<String, String> settings = new HashMap<String, String>();
            for (int i = 0; i < parameters.length; ++i) {
                settings.put(parameters[i].getName(), parameters[i].getParamValue());
            }
            return settings;
        }

        private static HashMap GetCompression(Compression compression) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("threshold", new Integer(compression.getThreshold()).toString());
            settings.put("enabled", new Boolean(compression.getEnabled()).toString().toLowerCase());
            return settings;
        }

        private static HashMap GetCacheClasses(CacheServerConfig cache) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            settings.put(cache.getName(), DomToHashMap.GetClassifiedCache(cache));
            return settings;
        }

        private static HashMap GetClassifiedCache(CacheServerConfig cache) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("id", cache.getName());
            if (cache.getCluster() == null) {
                settings.put("type", "local-cache");
                DomToHashMap.GetInternalCache(settings, cache, true);
            } else {
                DomToHashMap.GetCluster(settings, cache);
            }
            if (cache.getNotifications() != null) {
                settings.put("notifications", DomToHashMap.GetNotifications(cache.getNotifications()));
            }
            return settings;
        }

        private static void GetInternalCache(HashMap source, CacheServerConfig cache, boolean localCache) {
            if (cache.getQueryIndices() != null) {
                source.put("indexes", DomToHashMap.GetIndexes(cache.getQueryIndices()));
            }
            if (cache.getStorage() != null) {
                source.put("storage", DomToHashMap.GetStorage(cache.getStorage()));
            }
            if (!localCache) {
                source.put("type", "local-cache");
                source.put("id", "internal-cache");
            }
            if (cache.getEvictionPolicy() != null) {
                source.put("scavenging-policy", DomToHashMap.GetEvictionPolicy(cache.getEvictionPolicy()));
            }
            if (cache.getCleanup() != null) {
                source.put("clean-interval", new Integer(cache.getCleanup().getInterval()).toString());
            }
        }

        private static HashMap GetEvictionPolicy(EvictionPolicy evictionPolicy) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("class", evictionPolicy.getPolicy());
            settings.put("eviction-enabled", evictionPolicy.getEnabled());
            settings.put("priority", DomToHashMap.GetEvictionPriority(evictionPolicy));
            settings.put("evict-ratio", evictionPolicy.getEvictionRatio());
            return settings;
        }

        private static HashMap GetEvictionPriority(EvictionPolicy evictionPolicy) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("default-value", evictionPolicy.getDefaultPriority());
            return settings;
        }

        private static HashMap GetStorage(Storage storage) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("class", storage.getType());
            if (storage.getType().equals("heap")) {
                settings.put("heap", DomToHashMap.GetHeap(storage));
            }
            settings.put("heap", DomToHashMap.GetHeap(storage));
            return settings;
        }

        private static HashMap GetSecurity(Security security) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("enabled", new Boolean(security.getEnabled()).toString());
            settings.put("domain-controller", security.getDomainController().toString());
            settings.put("port", security.getPort().toString());
            settings.put("user", DomToHashMap.GetSecurityUser(security.getUsers()));
            return settings;
        }

        private static HashMap GetSecurityUser(User[] users) {
            HashMap<String, String> settings = new HashMap<String, String>();
            for (int i = 0; i < users.length; ++i) {
                settings.put(users[i].getId(), "null");
            }
            return settings;
        }

        private static HashMap GetEncryption(Encryption encryption) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("enabled", new Boolean(encryption.getEnabled()).toString());
            settings.put("key", encryption.getKey().toString());
            settings.put("provider", encryption.getProvider().toString());
            return settings;
        }

        private static HashMap GetHeap(Storage storage) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("max-size", new Long(storage.getSize()).toString());
            return settings;
        }

        private static HashMap GetIndexes(QueryIndex indexes) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            if (indexes.getClasses() != null) {
                settings.put("index-classes", DomToHashMap.GetIndexClasses(indexes.getClasses()));
            }
            return settings;
        }

        private static HashMap GetIndexClasses(Class[] classes) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            for (Class cls : classes) {
                settings.put(cls.getID(), DomToHashMap.GetIndexClass(cls));
            }
            return settings;
        }

        private static HashMap GetIndexClass(Class cls) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("name", cls.getName());
            settings.put("type", "class");
            settings.put("id", cls.getID());
            if (cls.getAttributes() != null) {
                settings.put("attributes", DomToHashMap.GetIndexAttributes(cls.getAttributes()));
            }
            return settings;
        }

        private static HashMap GetIndexAttributes(Attrib[] attributes) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            for (Attrib attrib : attributes) {
                settings.put(attrib.getID(), DomToHashMap.GetIndexAttribute(attrib));
            }
            return settings;
        }

        private static HashMap GetIndexAttribute(Attrib attrib) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("name", attrib.getName());
            settings.put("data-type", attrib.getType());
            settings.put("type", "attrib");
            settings.put("id", attrib.getID());
            return settings;
        }

        private static void GetCluster(HashMap settings, CacheServerConfig cache) {
            settings.put("type", cache.getCluster().getTopology());
            settings.put("stats-repl-interval", new Integer(cache.getCluster().getStatsRepInterval()).toString());
            settings.put("op-timeout", new Integer(cache.getCluster().getOpTimeout()).toString());
            settings.put("use-heart-beat", new Boolean(cache.getCluster().getUseHeartbeat()).toString().toLowerCase());
            if (cache.getCleanup() != null) {
                settings.put("clean-interval", new Integer(cache.getCleanup().getInterval()).toString());
            }
            settings.put("internal-cache", new HashMap());
            DomToHashMap.GetInternalCache((HashMap)settings.get("internal-cache"), cache, false);
            HashMap<String, Object> cluster = new HashMap<String, Object>();
            cluster.put("group-id", cache.getName());
            cluster.put("class", "tcp");
            cluster.put("channel", DomToHashMap.GetChannel(cache.getCluster().getChannel(), cache.getCluster().getUseHeartbeat()));
            settings.put("cluster", cluster);
        }

        private static HashMap GetBridge(BridgeConfig config) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("id", config.getId());
            settings.put("servers", config.getServers());
            settings.put("port", new Integer(config.getPort()).toString());
            settings.put("status", config.getStatus().toString());
            settings.put("is-target-cache", new Boolean(config.getIsBridgeTargetCache()).toString());
            return settings;
        }

        private static HashMap GetReplicationStrategy(ReplicationStrategy replicationStrategy) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("synchronous", new Boolean(replicationStrategy.getReplicateSynchronous()).toString().toLowerCase());
            return settings;
        }

        private static HashMap GetSQLDependency(SQLDependencyConfig sqlDependencyConfig) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("use-default", new Boolean(sqlDependencyConfig.getUseDefault()).toString().toLowerCase());
            return settings;
        }

        private static HashMap GetAlerts(AlertsNotifications alertsNotifications) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            if (alertsNotifications.getEMailNotifications() != null) {
                settings.put("email-notification", DomToHashMap.GetEmailNotifications(alertsNotifications.getEMailNotifications()));
            }
            if (alertsNotifications.getAlertsTypes() != null) {
                settings.put("alerts-types", DomToHashMap.GetAlertsType(alertsNotifications.getAlertsTypes()));
            }
            return settings;
        }

        private static HashMap GetEmailNotifications(EmailNotifications emailNotifications) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("email-notification-enabled", new Boolean(emailNotifications.getEmailNotificationEnabled()).toString());
            settings.put("sender", emailNotifications.getSender());
            settings.put("smtp-server", emailNotifications.getSmtpServer());
            settings.put("smtp-port", new Integer(emailNotifications.getSmtpPort()).toString());
            settings.put("ssl", new Boolean(emailNotifications.getSSL()).toString());
            settings.put("authentication", new Boolean(emailNotifications.getAuthentication()).toString());
            settings.put("sender-login", emailNotifications.getLogin());
            settings.put("sender-password", emailNotifications.getPassword());
            if (emailNotifications.getRecipients() != null) {
                settings.put("recipients", DomToHashMap.GetRecipients(emailNotifications.getRecipients()));
            }
            return settings;
        }

        private static HashMap GetRecipients(NotificationRecipient[] recipients) {
            HashMap<String, String> settings = new HashMap<String, String>();
            for (int i = 0; i < recipients.length; ++i) {
                settings.put(recipients[i].getID(), recipients[i].getID());
            }
            return settings;
        }

        private static HashMap GetAlertsType(AlertsTypes alertTypes) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("cache-stop", new Boolean(alertTypes.getCacheStop()).toString());
            settings.put("cache-start", new Boolean(alertTypes.getCacheStart()).toString());
            settings.put("node-left", new Boolean(alertTypes.getNodeLeft()).toString());
            settings.put("node-joined", new Boolean(alertTypes.getNodeJoined()).toString());
            settings.put("state-transfer-started", new Boolean(alertTypes.getStartTransferStarted()).toString());
            settings.put("state-transfer-stop", new Boolean(alertTypes.getStartTransferStop()).toString());
            settings.put("state-transfer-error", new Boolean(alertTypes.getStartTransferError()).toString());
            settings.put("service-start-error", new Boolean(alertTypes.getServiceStartError()).toString());
            settings.put("cache-size", new Boolean(alertTypes.getCacheSize()).toString());
            settings.put("general-error", new Boolean(alertTypes.getGeneralError()).toString());
            settings.put("licensing-error", new Boolean(alertTypes.getLicensingError()).toString());
            settings.put("configuration-error", new Boolean(alertTypes.getConfigurationError()).toString());
            settings.put("security-error", new Boolean(alertTypes.getSecurityError()).toString());
            settings.put("general-info", new Boolean(alertTypes.getGeneralInfo()).toString());
            settings.put("unhandled-exceptions", new Boolean(alertTypes.getUnHandledException()).toString());
            return settings;
        }

        private static HashMap GetChannel(Channel channel, boolean useHeartBeat) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            settings.put("tcp", DomToHashMap.GetTcp(channel, useHeartBeat));
            settings.put("tcpping", DomToHashMap.GetTcpPing(channel));
            settings.put("pbcast.gms", DomToHashMap.GetGMS(channel));
            return settings;
        }

        private static HashMap GetTcpPing(Channel channel) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("initial_hosts", channel.getInitialHosts().toString());
            settings.put("num_initial_members", new Integer(channel.getNumInitHosts()).toString());
            settings.put("port_range", new Integer(channel.getPortRange()).toString());
            return settings;
        }

        private static HashMap GetTcp(Channel channel, boolean useHeartBeat) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("start_port", new Integer(channel.getTcpPort()).toString());
            settings.put("port_range", new Integer(channel.getPortRange()).toString());
            settings.put("connection_retries", channel.getConnectionRetries());
            settings.put("connection_retry_interval", channel.getConnectionRetryInterval());
            settings.put("use_heart_beat", useHeartBeat);
            return settings;
        }

        private static HashMap GetGMS(Channel channel) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("join_retry_count", new Integer(channel.getJoinRetries()).toString());
            settings.put("join_retry_timeout", new Integer(channel.getJoinRetryInterval()).toString());
            return settings;
        }

        private static HashMap GetNotifications(Notifications notifications) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("item-add", new Boolean(notifications.getItemAdd()).toString().toLowerCase());
            settings.put("item-remove", new Boolean(notifications.getItemRemove()).toString().toLowerCase());
            settings.put("item-update", new Boolean(notifications.getItemUpdate()).toString().toLowerCase());
            settings.put("cache-clear", new Boolean(notifications.getCacheClear()).toString().toLowerCase());
            return settings;
        }

        private static HashMap GetLog(Log log) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("enabled", new Boolean(log.getEnabled()).toString().toLowerCase());
            settings.put("trace-errors", new Boolean(log.getTraceErrors()).toString().toLowerCase());
            settings.put("trace-notices", new Boolean(log.getTraceNotices()).toString().toLowerCase());
            settings.put("trace-debug", new Boolean(log.getTraceDebug()).toString().toLowerCase());
            settings.put("trace-warnings", new Boolean(log.getTraceWarnings()).toString().toLowerCase());
            settings.put("log-path", log.getLocation().toString().toLowerCase());
            return settings;
        }

        public static HashMap GetConfig(CacheServerConfig cache) {
            return DomToHashMap.GetCacheConfiguration(cache);
        }

        public static HashMap GetConfig(CacheServerConfig[] caches) {
            HashMap<String, HashMap> settings = new HashMap<String, HashMap>();
            for (CacheServerConfig cache : caches) {
                settings.put(cache.getName(), DomToHashMap.GetCacheConfiguration(cache));
            }
            return settings;
        }
    }

    private static class HashMapToDom {
        private HashMapToDom() {
        }

        public static CacheServerConfig[] GetConfig(HashMap config) {
            CacheServerConfig[] caches = new CacheServerConfig[config.size()];
            int i = 0;
            for (HashMap cache : config.values()) {
                caches[i++] = HashMapToDom.GetCacheConfiguration(new HashMap(new CaseInsensitiveMap((Map)cache)));
            }
            return caches;
        }

        private static CacheServerConfig GetCacheConfiguration(HashMap settings) {
            CacheServerConfig cache = new CacheServerConfig();
            cache.setName(settings.get("id").toString());
            if (settings.containsKey("web-cache")) {
                HashMapToDom.GetWebCache(cache, (HashMap)settings.get("web-cache"));
            }
            if (settings.containsKey("cache")) {
                HashMapToDom.GetCache(cache, (HashMap)settings.get("cache"));
            }
            if (settings.containsKey("data-sharing")) {
                cache.setDataSharing(HashMapToDom.GetDataSharing((HashMap)settings.get("data-sharing")));
            }
            if (settings.containsKey("compact-serialization")) {
                cache.setCompactSerialization(HashMapToDom.GetCompactSerialization((HashMap)settings.get("compact-serialization")));
            }
            return cache;
        }

        private static void GetCache(CacheServerConfig cache, HashMap settings) {
            if (settings.containsKey("config-id")) {
                cache.setConfigID((String)settings.get("config-id"));
            }
            if (settings.containsKey("last-modified")) {
                cache.setLastModified(settings.get("last-modified").toString());
            }
            if (settings.containsKey("auto-start")) {
                cache.setAutoStartCacheOnServiceStartup((Boolean)settings.get("auto-start"));
            }
            if (settings.containsKey("backing-source")) {
                cache.setBackingSource(HashMapToDom.GetBackingSource((HashMap)settings.get("backing-source")));
            }
            if (settings.containsKey("cache-loader")) {
                cache.setCacheLoader(HashMapToDom.GetCacheLoader((HashMap)settings.get("cache-loader")));
            }
            if (settings.containsKey("conflict-resolver")) {
                cache.setConflictResolver(HashMapToDom.GetConflictResolver((HashMap)settings.get("conflict-resolver")));
            }
            if (settings.containsKey("compression")) {
                cache.setCompression(HashMapToDom.GetCompression((HashMap)settings.get("compression")));
            }
            if (settings.containsKey("log")) {
                cache.setLog(HashMapToDom.GetLog((HashMap)settings.get("log")));
            }
            if (settings.containsKey("cache-classes")) {
                HashMapToDom.GetCacheClasses(cache, (HashMap)settings.get("cache-classes"));
            }
            if (settings.containsKey("perf-counters")) {
                cache.setPerfCounters(HashMapToDom.GetPerfCounters(settings));
            }
            if (settings.containsKey("conflict-resolver")) {
                cache.setConflictResolver(HashMapToDom.GetConflictResolver(settings));
            }
            if (settings.containsKey("security")) {
                cache.setSecurity(HashMapToDom.GetSecurity((HashMap)settings.get("security")));
            }
            if (settings.containsKey("encryption")) {
                cache.setEncryption(HashMapToDom.GetEncryption((HashMap)settings.get("encryption")));
            }
            if (settings.containsKey("replication-strategy")) {
                cache.setReplicationStrategy(HashMapToDom.GetReplicationStrategy((HashMap)settings.get("replication-strategy")));
            }
            if (settings.containsKey("sql-dependency")) {
                cache.setSQLDependencyConfig(HashMapToDom.GetSQLDependency((HashMap)settings.get("sql-dependency")));
            }
            if (cache.getAlertsNotifications() != null) {
                cache.setAlertsNotifications(HashMapToDom.GetAlerts((HashMap)settings.get("alerts")));
            }
            if (settings.containsKey("bridge")) {
                cache.setBridge(HashMapToDom.GetBridge(settings.get("bridge") instanceof HashMap ? settings.get("bridge") : null));
            }
        }

        private static DataSharing GetDataSharing(HashMap settings) {
            DataSharing dataSharing = new DataSharing();
            if (settings != null) {
                Object[] types = new Type[settings.size()];
                Iterator ide = settings.entrySet().iterator();
                int i = 0;
                while (ide.hasNext()) {
                    HashMap knownAttributeUnionList;
                    Map.Entry pair = ide.next();
                    HashMap knownType = pair.getValue() instanceof HashMap ? pair.getValue() : null;
                    if (knownType == null || knownType.size() <= 0) continue;
                    Type type = new Type();
                    type.setID(knownType.get("id") instanceof String ? knownType.get("id") : null);
                    type.setName(knownType.get("name") instanceof String ? knownType.get("name") : null);
                    type.setPortable(Boolean.parseBoolean(knownType.get("portable") instanceof String ? knownType.get("portable") : null));
                    HashMap knownClasses = knownType.get("class") instanceof HashMap ? knownType.get("class") : null;
                    if (knownClasses != null && knownClasses.size() > 0) {
                        Object[] classes = new PortableClass[knownClasses.size()];
                        Iterator ide2 = knownClasses.entrySet().iterator();
                        int j = 0;
                        while (ide2.hasNext()) {
                            Map.Entry pair2 = ide2.next();
                            HashMap knownClass = pair2.getValue() instanceof HashMap ? pair2.getValue() : null;
                            PortableClass clas = new PortableClass();
                            clas.setName(knownClass.get("name") instanceof String ? knownClass.get("name") : null);
                            clas.setID(knownClass.get("id") instanceof String ? knownClass.get("id") : null);
                            clas.setAssembly(knownClass.get("assembly") instanceof String ? knownClass.get("assembly") : null);
                            clas.setType(knownClass.get("type") instanceof String ? knownClass.get("type") : null);
                            HashMap knownAttributes = knownClass.get("class") instanceof HashMap ? knownClass.get("class") : null;
                            if (knownAttributes != null && knownAttributes.size() > 0) {
                                PortableAttribute[] attributes = new PortableAttribute[knownAttributes.size()];
                                Iterator ide3 = knownAttributes.entrySet().iterator();
                                int k = 0;
                                while (ide3.hasNext()) {
                                    Map.Entry ent = ide3.next();
                                    HashMap knownAttribute = ent.getValue() instanceof HashMap ? ent.getValue() : null;
                                    PortableAttribute attribute = new PortableAttribute();
                                    attribute.setName(knownAttribute.get("name") instanceof String ? knownAttribute.get("name") : null);
                                    attribute.setType(knownAttribute.get("type") instanceof String ? knownAttribute.get("type") : null);
                                    attribute.setOrder(knownAttribute.get("order") instanceof String ? knownAttribute.get("order") : null);
                                    attributes[k] = attribute;
                                    ++k;
                                }
                                clas.setPortableAttributes(attributes);
                            }
                            classes[j] = clas;
                            ++j;
                        }
                        type.setPortableClasses(classes);
                    }
                    if ((knownAttributeUnionList = (HashMap)(knownType.get("attribute-list") instanceof HashMap ? knownType.get("attribute-list") : null)) != null && knownAttributeUnionList.size() > 0) {
                        AttributeListUnion attribUnion = new AttributeListUnion();
                        Object[] attributes = new PortableAttribute[knownAttributeUnionList.size()];
                        Iterator ide5 = knownAttributeUnionList.entrySet().iterator();
                        int k = 0;
                        while (ide5.hasNext()) {
                            Map.Entry ent = ide5.next();
                            HashMap knownAttribute = ent.getValue() instanceof HashMap ? ent.getValue() : null;
                            PortableAttribute attribute = new PortableAttribute();
                            attribute.setName(knownAttribute.get("name") instanceof String ? knownAttribute.get("name") : null);
                            attribute.setType(knownAttribute.get("type") instanceof String ? knownAttribute.get("type") : null);
                            attribute.setOrder(knownAttribute.get("order") instanceof String ? knownAttribute.get("order") : null);
                            attributes[k] = attribute;
                            ++k;
                        }
                        attribUnion.setPortableAttributes(attributes);
                        type.setAttributeList(attribUnion);
                    }
                    types[i] = type;
                    ++i;
                }
                dataSharing.setTypes(types);
            }
            return dataSharing;
        }

        private static CompactSerialization GetCompactSerialization(HashMap settings) {
            CompactSerialization serialization = new CompactSerialization();
            if (settings != null) {
                CompactClass[] compactClass = new CompactClass[settings.size()];
                Iterator ide = settings.entrySet().iterator();
                int i = 0;
                while (ide.hasNext()) {
                    Map.Entry ent = ide.next();
                    HashMap knownType = ent.getValue() instanceof HashMap ? ent.getValue() : null;
                    if (knownType == null || knownType.size() <= 0) continue;
                    CompactClass compact = new CompactClass();
                    compact.setID(knownType.get("id") instanceof String ? knownType.get("id") : null);
                    compact.setName(knownType.get("name") instanceof String ? knownType.get("name") : null);
                    compact.setAssembly(knownType.get("assembly") instanceof String ? knownType.get("assembly") : null);
                    compact.setType(knownType.get("type") instanceof String ? knownType.get("type") : null);
                    compactClass[i] = compact;
                }
                serialization.setCompactClassListAsArray(compactClass);
            }
            return serialization;
        }

        private static PerfCounters GetPerfCounters(HashMap settings) {
            PerfCounters perCounters = new PerfCounters();
            perCounters.setEnabled((Boolean)settings.get("perf-counters"));
            return perCounters;
        }

        private static BridgeConflictResolver GetConflictResolver(HashMap settings) {
            BridgeConflictResolver bridgeConflictResolver = new BridgeConflictResolver();
            bridgeConflictResolver.setProvider(new ProviderAssembly());
            if (settings.containsKey("conflict-resolver")) {
                HashMap conflictResolver = (HashMap)settings.get("conflict-resolver");
                bridgeConflictResolver.getProvider().setAssemblyName(settings.get("assembly").toString());
                bridgeConflictResolver.getProvider().setClassName(settings.get("class-name").toString());
                bridgeConflictResolver.getProvider().setFullProviderName(settings.get("full-name").toString());
                bridgeConflictResolver.setDeserializedValue((Boolean)conflictResolver.get("deserialized"));
                if (settings.containsKey("parameters")) {
                    bridgeConflictResolver.setParameters(HashMapToDom.GetParameters(settings.get("parameters") instanceof HashMap ? settings.get("parameters") : null));
                }
            }
            return bridgeConflictResolver;
        }

        private static ReplicationStrategy GetReplicationStrategy(HashMap settings) {
            ReplicationStrategy replicationStrategy = new ReplicationStrategy();
            if (settings.containsKey("synchronous")) {
                replicationStrategy.setReplicateSynchronous((Boolean)settings.get("synchronous"));
            }
            return replicationStrategy;
        }

        private static SQLDependencyConfig GetSQLDependency(HashMap settings) {
            SQLDependencyConfig sqlDependencyConfig = new SQLDependencyConfig();
            if (settings.containsKey("use-default")) {
                sqlDependencyConfig.setUseDefault((Boolean)settings.get("use-default"));
            }
            return sqlDependencyConfig;
        }

        private static AlertsNotifications GetAlerts(HashMap settings) {
            AlertsNotifications alertNotification = new AlertsNotifications();
            if (settings.containsKey("email-notification")) {
                HashMap emailNotification = settings.get("email-notification") instanceof HashMap ? settings.get("email-notification") : null;
                alertNotification.setEMailNotifications(HashMapToDom.GetEmailNotifications(emailNotification));
            }
            if (settings.containsKey("alerts-types")) {
                HashMap alertType = settings.get("alerts-types") instanceof HashMap ? settings.get("alerts-types") : null;
                alertNotification.setAlertsTypes(HashMapToDom.GetAlertsType(alertType));
            }
            return alertNotification;
        }

        private static EmailNotifications GetEmailNotifications(HashMap settings) {
            EmailNotifications emailNotifications = new EmailNotifications();
            if (settings.containsKey("email-notification-enabled")) {
                emailNotifications.setEmailNotificationEnabled((Boolean)settings.get("email-notification-enabled"));
            }
            if (settings.containsKey("sender")) {
                emailNotifications.setSender(settings.get("sender") instanceof String ? settings.get("sender") : null);
            }
            if (settings.containsKey("smtp-server")) {
                emailNotifications.setSmtpServer(settings.get("smtp-server") instanceof String ? settings.get("smtp-server") : null);
            }
            if (settings.containsKey("smtp-port")) {
                emailNotifications.setSmtpPort((Integer)settings.get("smtp-port"));
            }
            if (settings.containsKey("ssl")) {
                emailNotifications.setSSL((Boolean)settings.get("ssl"));
            }
            if (settings.containsKey("authentication")) {
                emailNotifications.setAuthentication((Boolean)settings.get("authentication"));
            }
            if (settings.containsKey("sender-login")) {
                emailNotifications.setLogin(settings.get("sender-login") instanceof String ? settings.get("sender-login") : null);
            }
            if (settings.containsKey("sender-password")) {
                emailNotifications.setPassword(settings.get("sender-password") instanceof String ? settings.get("sender-password") : null);
            }
            if (settings.containsKey("recipients")) {
                HashMap recipients = settings.get("recipients") instanceof HashMap ? settings.get("recipients") : null;
                emailNotifications.setRecipients(HashMapToDom.GetRecipients(recipients));
            }
            return emailNotifications;
        }

        private static NotificationRecipient[] GetRecipients(HashMap settings) {
            NotificationRecipient[] recipients = null;
            if (settings.size() != 0) {
                recipients = new NotificationRecipient[settings.size()];
                int index = 0;
                for (Map.Entry pair : settings.entrySet()) {
                    recipients[index] = new NotificationRecipient();
                    recipients[index].setID(pair.getKey().toString());
                    ++index;
                }
            }
            return recipients;
        }

        private static AlertsTypes GetAlertsType(HashMap settings) {
            AlertsTypes alertTypes = new AlertsTypes();
            if (settings.containsKey("cache-stop")) {
                alertTypes.setCacheStop((Boolean)settings.get("cache-stop"));
            }
            if (settings.containsKey("cache-start")) {
                alertTypes.setCacheStart((Boolean)settings.get("cache-start"));
            }
            if (settings.containsKey("node-left")) {
                alertTypes.setNodeLeft((Boolean)settings.get("node-left"));
            }
            if (settings.containsKey("node-joined")) {
                alertTypes.setNodeJoined((Boolean)settings.get("node-joined"));
            }
            if (settings.containsKey("state-transfer-started")) {
                alertTypes.setStartTransferStarted((Boolean)settings.get("state-transfer-started"));
            }
            if (settings.containsKey("state-transfer-stop")) {
                alertTypes.setStartTransferStop((Boolean)settings.get("state-transfer-stop"));
            }
            if (settings.containsKey("state-transfer-error")) {
                alertTypes.setStartTransferError((Boolean)settings.get("state-transfer-error"));
            }
            if (settings.containsKey("service-start-error")) {
                alertTypes.setServiceStartError((Boolean)settings.get("service-start-error"));
            }
            if (settings.containsKey("cache-size")) {
                alertTypes.setCacheSize((Boolean)settings.get("cache-size"));
            }
            if (settings.containsKey("general-error")) {
                alertTypes.setGeneralError((Boolean)settings.get("general-error"));
            }
            if (settings.containsKey("licensing-error")) {
                alertTypes.setLicensingError((Boolean)settings.get("licensing-error"));
            }
            if (settings.containsKey("configuration-error")) {
                alertTypes.setConfigurationError((Boolean)settings.get("configuration-error"));
            }
            if (settings.containsKey("security-error")) {
                alertTypes.setSecurityError((Boolean)settings.get("security-error"));
            }
            if (settings.containsKey("general-info")) {
                alertTypes.setGeneralInfo((Boolean)settings.get("general-info"));
            }
            if (settings.containsKey("unhandled-exceptions")) {
                alertTypes.setUnHandledException((Boolean)settings.get("unhandled-exceptions"));
            }
            return alertTypes;
        }

        private static void GetCacheClasses(CacheServerConfig cache, HashMap settings) {
            if (settings.containsKey(cache.getName())) {
                HashMapToDom.GetClassifiedCache(cache, (HashMap)settings.get(cache.getName()));
            }
        }

        private static void GetClassifiedCache(CacheServerConfig cache, HashMap settings) {
            if (settings.containsKey("cluster")) {
                cache.setCluster(HashMapToDom.GetCluster(settings));
            }
            if (settings.containsKey("internal-cache")) {
                HashMapToDom.GetInternalCache(cache, (HashMap)settings.get("internal-cache"));
            } else {
                HashMapToDom.GetInternalCache(cache, settings);
            }
            if (settings.containsKey("notifications")) {
                cache.setNotifications(HashMapToDom.GetNotifications((HashMap)settings.get("notifications")));
            }
        }

        private static Notifications GetNotifications(HashMap settings) {
            Notifications notifications = new Notifications();
            if (settings.containsKey("item-remove")) {
                notifications.setItemRemove((Boolean)settings.get("item-remove"));
            }
            if (settings.containsKey("item-add")) {
                notifications.setItemAdd((Boolean)settings.get("item-add"));
            }
            if (settings.containsKey("item-update")) {
                notifications.setItemUpdate((Boolean)settings.get("item-update"));
            }
            if (settings.containsKey("cache-clear")) {
                notifications.setCacheClear((Boolean)settings.get("cache-clear"));
            }
            return notifications;
        }

        private static void GetInternalCache(CacheServerConfig cache, HashMap settings) {
            if (settings.containsKey("indexes")) {
                cache.setQueryIndices(HashMapToDom.GetIndexes((HashMap)settings.get("indexes")));
            }
            if (settings.containsKey("storage")) {
                cache.setStorage(HashMapToDom.GetStorage((HashMap)settings.get("storage")));
            }
            if (settings.containsKey("scavenging-policy")) {
                cache.setEvictionPolicy(HashMapToDom.GetEvictionPolicy((HashMap)settings.get("scavenging-policy")));
            }
            if (settings.containsKey("clean-interval")) {
                cache.setCleanup(HashMapToDom.GetCleanup(settings));
            }
        }

        private static Cleanup GetCleanup(HashMap settings) {
            Cleanup cleanup = new Cleanup();
            cleanup.setInterval((Integer)settings.get("clean-interval"));
            return cleanup;
        }

        private static EvictionPolicy GetEvictionPolicy(HashMap settings) {
            EvictionPolicy evictionPolicy = new EvictionPolicy();
            if (settings.containsKey("eviction-enabled")) {
                evictionPolicy.setEnabled((Boolean)settings.get("eviction-enabled"));
            }
            if (settings.containsKey("priority")) {
                evictionPolicy.setDefaultPriority(((HashMap)settings.get("priority")).get("default-value").toString());
            }
            if (settings.containsKey("class")) {
                evictionPolicy.setPolicy(settings.get("class") instanceof String ? settings.get("class") : null);
            }
            if (settings.containsKey("evict-ratio")) {
                evictionPolicy.setEvictionRatio((BigDecimal)settings.get("evict-ratio"));
            }
            return evictionPolicy;
        }

        private static QueryIndex GetIndexes(HashMap settings) {
            QueryIndex indexes = new QueryIndex();
            if (settings.containsKey("index-classes")) {
                indexes.setClasses(HashMapToDom.GetIndexClasses((HashMap)settings.get("index-classes")));
            }
            return indexes;
        }

        private static Class[] GetIndexClasses(HashMap settings) {
            Class[] classes = new Class[settings.size()];
            int i = 0;
            for (HashMap cls : settings.values()) {
                classes[i++] = HashMapToDom.GetIndexClass(cls);
            }
            return classes;
        }

        private static Class GetIndexClass(HashMap settings) {
            Class cls = new Class();
            if (settings.containsKey("id")) {
                cls.setID(settings.get("id").toString());
            }
            if (settings.containsKey("name")) {
                cls.setName(settings.get("name").toString());
            }
            if (settings.containsKey("attributes")) {
                cls.setAttributes(HashMapToDom.GetIndexAttributes((HashMap)settings.get("attributes")));
            }
            return cls;
        }

        private static Attrib[] GetIndexAttributes(HashMap settings) {
            Attrib[] attributes = new Attrib[settings.size()];
            int i = 0;
            for (HashMap attrib : settings.values()) {
                attributes[i++] = HashMapToDom.GetIndexAttribute(attrib);
            }
            return attributes;
        }

        private static Attrib GetIndexAttribute(HashMap settings) {
            Attrib attrib = new Attrib();
            if (settings.containsKey("id")) {
                attrib.setID(settings.get("id").toString());
            }
            if (settings.containsKey("data-type")) {
                attrib.setType(settings.get("data-type").toString());
            }
            if (settings.containsKey("name")) {
                attrib.setName(settings.get("name").toString());
            }
            return attrib;
        }

        private static Storage GetStorage(HashMap settings) {
            Storage storage = new Storage();
            if (settings.containsKey("class")) {
                storage.setType(settings.get("class").toString());
            }
            if (settings.containsKey("heap")) {
                storage.setSize((Long)((HashMap)settings.get("heap")).get("max-size"));
            }
            return storage;
        }

        private static Security GetSecurity(HashMap settings) {
            Security security = new Security();
            if (settings.containsKey("enabled")) {
                security.setEnabled((Boolean)settings.get("enabled"));
            }
            if (settings.containsKey("domain-controller")) {
                security.setDomainController(settings.get("domain-controller").toString());
            }
            if (settings.containsKey("port")) {
                security.setPort(settings.get("port").toString());
            }
            if (settings.containsKey("user")) {
                security.setUsers(HashMapToDom.GetSecurityUser((HashMap)settings.get("user")));
            }
            return security;
        }

        private static User[] GetSecurityUser(HashMap settings) {
            User[] users = null;
            if (settings.size() != 0) {
                users = new User[settings.size()];
                int index = 0;
                for (Map.Entry ent : settings.entrySet()) {
                    users[index] = new User(ent.getKey().toString());
                    ++index;
                }
            }
            return users;
        }

        private static Encryption GetEncryption(HashMap settings) {
            Encryption encryption = new Encryption();
            if (settings.containsKey("enabled")) {
                encryption.setEnabled((Boolean)settings.get("enabled"));
            }
            if (settings.containsKey("key")) {
                encryption.setKey(settings.get("key").toString());
            }
            if (settings.containsKey("provider")) {
                encryption.setProvider(settings.get("provider").toString());
            }
            return encryption;
        }

        private static Cluster GetCluster(HashMap settings) {
            Cluster cluster = new Cluster();
            if (settings.containsKey("type")) {
                cluster.setTopology(settings.get("type").toString());
            }
            if (settings.containsKey("stats-repl-interval")) {
                cluster.setStatsRepInterval((Integer)settings.get("stats-repl-interval"));
            }
            if (settings.containsKey("op-timeout")) {
                cluster.setOpTimeout((Integer)settings.get("op-timeout"));
            }
            if (settings.containsKey("use-heart-beat")) {
                cluster.setUseHeartbeat((Boolean)settings.get("use-heart-beat"));
            }
            if ((settings = (HashMap)settings.get("cluster")).containsKey("channel")) {
                cluster.setChannel(HashMapToDom.GetChannel((HashMap)settings.get("channel"), cluster.getTopology().equals("partitioned-replicas-server") ? 2 : 1));
            }
            return cluster;
        }

        private static Channel GetChannel(HashMap settings, int defaultPortRange) {
            Channel channel = new Channel(defaultPortRange);
            if (settings.containsKey("tcp")) {
                HashMapToDom.GetTcp(channel, (HashMap)settings.get("tcp"));
            }
            if (settings.containsKey("tcpping")) {
                HashMapToDom.GetTcpPing(channel, (HashMap)settings.get("tcpping"));
            }
            if (settings.containsKey("pbcast.gms")) {
                HashMapToDom.GetGMS(channel, (HashMap)settings.get("pbcast.gms"));
            }
            return channel;
        }

        private static BridgeConfig GetBridge(HashMap settings) {
            BridgeConfig config = new BridgeConfig();
            config.setId(settings.get("id") instanceof String ? settings.get("id") : null);
            config.setServers(settings.get("servers") instanceof String ? settings.get("servers") : null);
            config.setPort((Integer)settings.get("port"));
            config.setStatus(settings.get("status").toString());
            if (settings.containsKey("is-target-cache")) {
                config.setIsBridgeTargetCache((Boolean)settings.get("is-target-cache"));
            }
            return config;
        }

        private static void GetTcpPing(Channel channel, HashMap settings) {
            if (settings.containsKey("initial_hosts")) {
                channel.setInitialHosts(settings.get("initial_hosts").toString());
            }
            if (settings.containsKey("num_initial_members")) {
                channel.setNumInitHosts((Integer)settings.get("num_initial_members"));
            }
            if (settings.containsKey("port_range")) {
                channel.setPortRange((Integer)settings.get("port_range"));
            }
        }

        private static void GetTcp(Channel channel, HashMap settings) {
            if (settings.containsKey("start_port")) {
                channel.setTcpPort((Integer)settings.get("start_port"));
            }
            if (settings.containsKey("port_range")) {
                channel.setPortRange((Integer)settings.get("port_range"));
            }
            if (settings.containsKey("connection_retries")) {
                channel.setConnectionRetries((Integer)settings.get("connection_retries"));
            }
            if (settings.containsKey("connection_retry_interval")) {
                channel.setConnectionRetryInterval((Integer)settings.get("connection_retry_interval"));
            }
        }

        private static void GetGMS(Channel channel, HashMap settings) {
            if (settings.containsKey("join_retry_count")) {
                channel.setJoinRetries(Integer.parseInt(settings.get("join_retry_count").toString()));
            }
            if (settings.containsKey("join_retry_timeout")) {
                channel.setJoinRetryInterval((Integer)settings.get("join_retry_timeout"));
            }
        }

        private static Log GetLog(HashMap settings) {
            Log log = new Log();
            if (settings.containsKey("enabled")) {
                log.setEnabled((Boolean)settings.get("enabled"));
            }
            if (settings.containsKey("trace-errors")) {
                log.setTraceErrors((Boolean)settings.get("trace-errors"));
            }
            if (settings.containsKey("trace-notices")) {
                log.setTraceNotices((Boolean)settings.get("trace-notices"));
            }
            if (settings.containsKey("trace-debug")) {
                log.setTraceDebug((Boolean)settings.get("trace-debug"));
            }
            if (settings.containsKey("trace-warnings")) {
                log.setTraceWarnings((Boolean)settings.get("trace-warnings"));
            }
            if (settings.containsKey("log-path")) {
                log.setLocation((String)settings.get("log-path"));
            }
            return log;
        }

        private static Compression GetCompression(HashMap settings) {
            Compression compression = new Compression();
            if (settings.containsKey("enabled")) {
                compression.setEnabled((Boolean)settings.get("enabled"));
            }
            if (settings.containsKey("threshold")) {
                compression.setThreshold((Integer)settings.get("threshold"));
            }
            return compression;
        }

        private static BackingSource GetBackingSource(HashMap settings) {
            BackingSource backingSource = new BackingSource();
            if (settings.containsKey("read-thru")) {
                backingSource.setReadthru(HashMapToDom.GetReadThru((HashMap)settings.get("read-thru")));
            }
            if (settings.containsKey("write-thru")) {
                backingSource.setWritethru(HashMapToDom.GetWriteThru((HashMap)settings.get("write-thru")));
            }
            return backingSource;
        }

        private static CacheLoader GetCacheLoader(HashMap settings) {
            CacheLoader CL = new CacheLoader();
            CL.setProvider(new ProviderAssembly());
            if (settings.containsKey("cache-load")) {
                HashMap cacheload = (HashMap)settings.get("cache-load");
                CL.getProvider().setAssemblyName(cacheload.get("assembly").toString());
                CL.getProvider().setClassName(cacheload.get("classname").toString());
                CL.getProvider().setFullProviderName(settings.get("full-name").toString());
                CL.setRetries((Integer)cacheload.get("retries"));
                CL.setRetryInterval((Integer)cacheload.get("retry-interval"));
                if (cacheload.containsKey("parameters")) {
                    CL.setParameters(HashMapToDom.GetParameters(cacheload.get("parameters") instanceof HashMap ? cacheload.get("parameters") : null));
                }
            }
            return CL;
        }

        private static Writethru GetWriteThru(HashMap settings) {
            Writethru writeThru = new Writethru();
            if (settings.containsKey("write-thru-providers")) {
                writeThru.setProviders(HashMapToDom.GetProviders(settings.get("write-thru-providers") instanceof HashMap ? settings.get("write-thru-providers") : null));
            }
            return writeThru;
        }

        private static WriteBehind GetWriteBehind(HashMap settings) {
            if (settings == null) {
                return null;
            }
            WriteBehind writeBehind = new WriteBehind();
            if (settings.containsKey("mode")) {
                writeBehind.setMode(settings.get("mode").toString());
            }
            if (settings.containsKey("throttling-rate-per-sec")) {
                writeBehind.setThrottling(settings.get("throttling-rate-per-sec").toString());
            }
            if (settings.containsKey("failed-operations-queue-limit")) {
                writeBehind.setRequeueLimit(settings.get("failed-operations-queue-limit").toString());
            }
            if (settings.containsKey("failed-operations-eviction-ratio")) {
                writeBehind.setEviction(settings.get("failed-operations-eviction-ratio").toString());
            }
            if (settings.containsKey("batch-mode-config")) {
                writeBehind.setBatchConfig(HashMapToDom.GetBatchConfig(settings.get("batch-mode-config") instanceof HashMap ? settings.get("batch-mode-config") : null));
            }
            return writeBehind;
        }

        private static BatchConfig GetBatchConfig(HashMap settings) {
            if (settings == null) {
                return null;
            }
            BatchConfig batchConfig = new BatchConfig();
            if (settings.containsKey("batch-interval")) {
                batchConfig.setBatchInterval(settings.get("batch-interval").toString());
            }
            if (settings.containsKey("operation-delay")) {
                batchConfig.setOperationDelay(settings.get("operation-delay").toString());
            }
            return batchConfig;
        }

        private static Readthru GetReadThru(HashMap settings) {
            Readthru readThru = new Readthru();
            if (settings.containsKey("read-thru-providers")) {
                readThru.setProviders(HashMapToDom.GetProviders(settings.get("read-thru-providers") instanceof HashMap ? settings.get("read-thru-providers") : null));
            }
            return readThru;
        }

        private static Provider[] GetProviders(HashMap settings) {
            if (settings == null) {
                return null;
            }
            Provider[] providers = new Provider[settings.size()];
            int i = 0;
            for (Map.Entry ent : settings.entrySet()) {
                if (!(ent.getValue() instanceof HashMap)) continue;
                Provider provider = new Provider();
                HashMap properties = (HashMap)ent.getValue();
                for (Map.Entry pairDE : properties.entrySet()) {
                    if (pairDE.getKey().equals("assembly-name")) {
                        provider.setAssemblyName((String)pairDE.getValue());
                    }
                    if (pairDE.getKey().equals("class-name")) {
                        provider.setClassName((String)pairDE.getValue());
                    }
                    if (pairDE.getKey().equals("provider-name")) {
                        provider.setProviderName((String)pairDE.getValue());
                    }
                    if (pairDE.getKey().equals("full-name")) {
                        provider.setFullProviderName((String)pairDE.getValue());
                    }
                    if (pairDE.getKey().equals("default-provider")) {
                        provider.setIsDefaultProvider((Boolean)pairDE.getValue());
                    }
                    if (!pairDE.getKey().equals("parameters")) continue;
                    provider.setParameters(HashMapToDom.GetParameters(pairDE.getValue() instanceof HashMap ? pairDE.getValue() : null));
                }
                providers[i] = provider;
                ++i;
            }
            return providers;
        }

        private static Parameter[] GetParameters(HashMap settings) {
            if (settings == null) {
                return null;
            }
            Parameter[] parameters = new Parameter[settings.size()];
            int i = 0;
            for (Map.Entry ent : settings.entrySet()) {
                Parameter parameter = new Parameter();
                parameter.setName(ent.getKey() instanceof String ? ent.getKey() : null);
                parameter.setParamValue(ent.getValue() instanceof String ? ent.getValue() : null);
                parameters[i] = parameter;
                ++i;
            }
            return parameters;
        }

        private static void GetWebCache(CacheServerConfig cache, HashMap settings) {
            if (settings.containsKey("shared")) {
                cache.setInProc((Boolean)settings.get("shared") == false);
            }
        }
    }
}

