/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.NewDom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Common.StatusInfo;
import Alachisoft.NCache.Config.NewDom.Channel;
import Alachisoft.NCache.Config.NewDom.NodeIdentity;
import Alachisoft.NCache.Config.NewDom.ReplicationStrategy;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Cluster
implements Cloneable,
InternalCompactSerializable {
    boolean _isNew = true;
    private String topology = "";
    private String activeMirrorNode = null;
    private int opTimeout = 60;
    private int statsRepInterval;
    private ReplicationStrategy _replicationStrategy;
    private boolean useHeartBeat;
    private Channel channel = new Channel();
    private HashMap<NodeIdentity, StatusInfo> nodes = new HashMap();

    public Cluster() {
        this.topology = new String();
        this._replicationStrategy = new ReplicationStrategy();
    }

    public final String getTopology() {
        String value = this.topology;
        if (value != null) {
            if ((value = value.toLowerCase()).equals("replicated")) {
                return "replicated-server";
            }
            if (value.equals("partitioned")) {
                return "partitioned-server";
            }
            if (value.equals("partition-replica")) {
                return "partitioned-replicas-server";
            }
            if (value.equals("mirror")) {
                return "mirror-server";
            }
        }
        return value;
    }

    public final void setTopology(String value) {
        this.topology = value;
    }

    public final boolean getIsNew() {
        return this._isNew;
    }

    public final void setIsNew(boolean value) {
        this._isNew = value;
    }

    @ConfigurationAttributeAnnotation(value="operation-timeout", appendText="sec")
    public final int getOpTimeout() {
        return this.opTimeout;
    }

    @ConfigurationAttributeAnnotation(value="operation-timeout", appendText="sec")
    public final void setOpTimeout(int value) {
        this.opTimeout = value;
    }

    @ConfigurationAttributeAnnotation(value="stats-repl-interval", appendText="sec")
    public final int getStatsRepInterval() {
        return this.statsRepInterval;
    }

    @ConfigurationAttributeAnnotation(value="stats-repl-interval", appendText="sec")
    public final void setStatsRepInterval(int value) {
        this.statsRepInterval = value;
    }

    @ConfigurationSectionAnnotation(value="data-replication")
    public final ReplicationStrategy getReplicationStrategy() {
        return this._replicationStrategy;
    }

    @ConfigurationSectionAnnotation(value="data-replication")
    public final void setReplicationStrategy(ReplicationStrategy value) {
        this._replicationStrategy = value;
    }

    @ConfigurationAttributeAnnotation(value="use-heart-beat", appendText="")
    public final boolean getUseHeartbeat() {
        return this.useHeartBeat;
    }

    @ConfigurationAttributeAnnotation(value="use-heart-beat", appendText="")
    public final void setUseHeartbeat(boolean value) {
        this.useHeartBeat = value;
    }

    @ConfigurationSectionAnnotation(value="cluster-connection-settings")
    public final Channel getChannel() {
        return this.channel;
    }

    @ConfigurationSectionAnnotation(value="cluster-connection-settings")
    public final void setChannel(Channel value) {
        this.channel = value;
    }

    public final HashMap<NodeIdentity, StatusInfo> getNodes() {
        return this.nodes;
    }

    public final void setNodes(HashMap<NodeIdentity, StatusInfo> value) {
        this.nodes = value;
    }

    public final ArrayList<NodeIdentity> getNodeIdentities() {
        NodeIdentity[] nodeIdentities = new NodeIdentity[this.nodes.size()];
        this.nodes.keySet().toArray(nodeIdentities);
        return new ArrayList<NodeIdentity>(Arrays.asList(nodeIdentities));
    }

    @ConfigurationAttributeAnnotation(value="active-mirror-node", appendText="")
    public final String getActiveMirrorNode() {
        return this.activeMirrorNode;
    }

    @ConfigurationAttributeAnnotation(value="active-mirror-node", appendText="")
    public final void setActiveMirrorNode(String value) {
        this.activeMirrorNode = value;
    }

    public final Object clone() throws CloneNotSupportedException {
        Cluster cluster = new Cluster();
        cluster.setOpTimeout(this.getOpTimeout());
        cluster.setStatsRepInterval(this.getStatsRepInterval());
        cluster.setReplicationStrategy(this._replicationStrategy != null ? (ReplicationStrategy)this._replicationStrategy.clone() : null);
        cluster.setUseHeartbeat(this.getUseHeartbeat());
        cluster.setIsNew(this._isNew);
        cluster.setChannel(this.getChannel() != null ? (Channel)this.getChannel().clone() : null);
        return cluster;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this.opTimeout = reader.ReadInt32();
        this.statsRepInterval = reader.ReadInt32();
        this.useHeartBeat = reader.ReadBoolean();
        this._replicationStrategy = (ReplicationStrategy)Common.readAs((Object)reader.ReadObject(), ReplicationStrategy.class);
        this.channel = (Channel)Common.readAs((Object)reader.ReadObject(), Channel.class);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(this.opTimeout);
        writer.Write(this.statsRepInterval);
        writer.Write(this.useHeartBeat);
        writer.WriteObject((Object)this._replicationStrategy);
        writer.WriteObject((Object)this.channel);
    }
}

