/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.NewDom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.StatusInfo;
import Alachisoft.NCache.Config.NewDom.NodeIdentity;
import Alachisoft.NCache.Config.NewDom.ServerNode;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ServersNodes
implements Cloneable,
InternalCompactSerializable {
    private String _activeMirrorNode = "";
    private ArrayList nodesList;
    private HashMap<NodeIdentity, StatusInfo> nodes = new HashMap();

    public ServersNodes() {
        this.nodesList = new ArrayList();
    }

    @ConfigurationSectionAnnotation(value="server-node")
    public final ServerNode[] getServerNodeList() {
        ServerNode[] serverNode = new ServerNode[this.nodesList.size()];
        for (int index = 0; index < this.nodesList.size(); ++index) {
            serverNode[index] = (ServerNode)this.nodesList.get(index);
        }
        return serverNode;
    }

    @ConfigurationSectionAnnotation(value="server-node")
    public final void setServerNodeList(Object[] value) {
        this.nodesList.clear();
        this.nodesList.addAll(Arrays.asList(value));
    }

    public final ArrayList getNodesList() {
        return this.nodesList;
    }

    public final void setNodesList(ArrayList value) {
        this.nodesList = value;
    }

    public final String getActiveMirrorNode() {
        if (this.getServerNodeList() != null) {
            for (int index = 0; index < this.nodesList.size(); ++index) {
                ServerNode server = (ServerNode)this.nodesList.get(index);
                if (!server.getIsActiveMirrorNode()) continue;
                return server.getIP();
            }
        }
        return this._activeMirrorNode;
    }

    public final void setActiveMirrorNode(String value) {
        this._activeMirrorNode = value;
        if (value != null && !value.isEmpty() && this.getServerNodeList() != null) {
            for (int index = 0; index < this.nodesList.size(); ++index) {
                ServerNode server = (ServerNode)this.nodesList.get(index);
                if (!server.getIP().equals(value)) continue;
                server.setIsActiveMirrorNode(true);
            }
        }
    }

    public final HashMap<NodeIdentity, StatusInfo> getNodes() {
        return this.nodes;
    }

    public final void setNodes(HashMap<NodeIdentity, StatusInfo> value) {
        this.nodes = value;
    }

    public final NodeIdentity[] getNodeIdentities() {
        NodeIdentity[] nodeIdentities = new NodeIdentity[this.nodes.size()];
        this.nodes.keySet().toArray(nodeIdentities);
        return nodeIdentities;
    }

    public final boolean FindNode(String ip) {
        for (int index = 0; index < this.nodesList.size(); ++index) {
            ServerNode server = (ServerNode)this.nodesList.get(index);
            if (!server.getIP().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public final int getNewNodePriority() {
        int priority = 0;
        if (this.getNodes() == null) {
            return 1;
        }
        for (NodeIdentity node : this.getNodeIdentities()) {
            if (node.getNodePriority() <= priority) continue;
            priority = node.getNodePriority();
        }
        return priority + 1;
    }

    public final void ReAssignPriority(NodeIdentity leavingNode) {
        for (NodeIdentity node : this.getNodeIdentities()) {
            if (leavingNode.getNodeName() != node.getNodeName()) continue;
            leavingNode.setNodePriority(node.getNodePriority());
        }
        for (NodeIdentity oldNode : this.getNodeIdentities()) {
            if (oldNode.getNodePriority() <= leavingNode.getNodePriority()) continue;
            oldNode.setNodePriority(oldNode.getNodePriority() - 1);
        }
    }

    public final ArrayList<Address> GetAllConfiguredNodes() throws UnknownHostException {
        ArrayList<Address> nodes = new ArrayList<Address>();
        if (this.getServerNodeList() != null) {
            for (int index = 0; index < this.nodesList.size(); ++index) {
                ServerNode sn = (ServerNode)this.nodesList.get(index);
                nodes.add(new Address(sn.getIP(), 0));
            }
        }
        return nodes;
    }

    public final Object clone() {
        ServersNodes serverNode = new ServersNodes();
        Object tempVar = this.getServerNodeList().clone();
        serverNode.setServerNodeList((ServerNode[])(tempVar instanceof ServerNode[] ? tempVar : null));
        if (this.nodes != null) {
            serverNode.nodes = new HashMap();
            for (Map.Entry<NodeIdentity, StatusInfo> pair : this.nodes.entrySet()) {
                serverNode.nodes.put(pair.getKey(), pair.getValue());
            }
        }
        return serverNode;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        if (this.nodesList == null) {
            this.nodesList = new ArrayList();
        }
        this.nodesList = (ArrayList)Common.readAs((Object)reader.ReadObject(), ArrayList.class);
        boolean nodeExists = reader.ReadBoolean();
        if (nodeExists) {
            this.nodes = new HashMap();
            int count = reader.ReadInt32();
            for (int index = 0; index < count; ++index) {
                this.nodes.put((NodeIdentity)Common.as((Object)reader.ReadObject(), NodeIdentity.class), (StatusInfo)Common.as((Object)reader.ReadObject(), StatusInfo.class));
            }
        }
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this.nodesList);
        if (this.nodes != null && this.nodes.size() > 0) {
            writer.Write(true);
            writer.Write(this.nodes.size());
            for (NodeIdentity key : this.nodes.keySet()) {
                writer.WriteObject((Object)key);
                writer.WriteObject((Object)this.nodes.get(key));
            }
        } else {
            writer.Write(false);
        }
    }
}

