/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config;

import Alachisoft.NCache.Config.ConfigReader;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.util.HashMap;
import java.util.Stack;

public class PropsConfigReader
extends ConfigReader {
    private String _propString;

    public PropsConfigReader(String propString) {
        this._propString = propString;
    }

    public final String getPropertyString() {
        return this._propString;
    }

    @Override
    public HashMap getProperties() {
        try {
            return this.GetProperties(this._propString);
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }

    public final String ToPropertiesXml() throws ConfigurationException {
        return ConfigReader.ToPropertiesXml(this.GetProperties(this._propString));
    }

    private HashMap GetProperties(String propString) throws ConfigurationException {
        boolean uppercaseFlag = false;
        HashMap properties = new HashMap();
        Tokenizer tokenizer = new Tokenizer(propString);
        String key = "";
        int nestingLevel = 0;
        State state = State.keyNeeded;
        Stack<HashMap> stack = new Stack<HashMap>();
        boolean i = false;
        block9: while (true) {
            int token = tokenizer.getNextToken();
            switch (token) {
                case -1: {
                    if (state != State.keyNeeded) {
                        throw new ConfigurationException("Invalid EOF");
                    }
                    if (nestingLevel > 0) {
                        throw new ConfigurationException("Invalid property string, un-matched paranthesis");
                    }
                    return properties;
                }
                case 2: {
                    Object tempVar;
                    if (state != State.keyNeeded) {
                        throw new ConfigurationException("Invalid property string, ) misplaced");
                    }
                    if (nestingLevel < 1) {
                        throw new ConfigurationException("Invalid property string, ) unexpected");
                    }
                    if (uppercaseFlag) {
                        uppercaseFlag = false;
                    }
                    properties = (HashMap)((tempVar = stack.pop()) instanceof HashMap ? tempVar : null);
                    --nestingLevel;
                    continue block9;
                }
                case 4: {
                    switch (state) {
                        case keyNeeded: {
                            if (key.equals("parameters")) {
                                uppercaseFlag = true;
                            }
                            key = tokenizer.getTokenValue();
                            token = tokenizer.getNextToken();
                            if (token == 3 || token == 2 || token == 4 || token == -1) {
                                throw new ConfigurationException("Invalid property string, key following a bad token");
                            }
                            if (token == 0) {
                                state = State.valNeeded;
                                break;
                            }
                            if (token != 1) break;
                            stack.push(properties);
                            properties.put(key.toLowerCase(), new HashMap());
                            properties = properties.get(key.toLowerCase()) instanceof HashMap ? properties.get(key.toLowerCase()) : null;
                            state = State.keyNeeded;
                            ++nestingLevel;
                            break;
                        }
                        case valNeeded: {
                            Object tempVar2;
                            String val = tokenizer.getTokenValue();
                            token = tokenizer.getNextToken();
                            state = State.keyNeeded;
                            if (token == 0 || token == 4 || token == -1) {
                                throw new ConfigurationException("Invalid property string, value following a bad token");
                            }
                            if (uppercaseFlag) {
                                properties.put(key, val);
                            } else {
                                properties.put(key.toLowerCase(), val);
                            }
                            if (token == 1) {
                                stack.push(properties);
                                properties.put(key.toLowerCase(), new HashMap());
                                properties = properties.get(key.toLowerCase()) instanceof HashMap ? properties.get(key.toLowerCase()) : null;
                                properties.put("id", key);
                                properties.put("type", val);
                                state = State.keyNeeded;
                                ++nestingLevel;
                                break;
                            }
                            if (token != 2) break;
                            if (nestingLevel < 1) {
                                throw new ConfigurationException("Invalid property string, ) unexpected");
                            }
                            if (uppercaseFlag) {
                                uppercaseFlag = false;
                            }
                            properties = (HashMap)((tempVar2 = stack.pop()) instanceof HashMap ? tempVar2 : null);
                            --nestingLevel;
                            state = State.keyNeeded;
                        }
                    }
                    continue block9;
                }
            }
            break;
        }
        throw new ConfigurationException("Invalid property string");
    }

    private static class Tokenizer {
        public static final int EOF = -1;
        public static final int ASSIGN = 0;
        public static final int NEST = 1;
        public static final int UNNEST = 2;
        public static final int CONTINUE = 3;
        public static final int ID = 4;
        private String _text;
        private String _token;
        private int _index = 0;

        public Tokenizer(String text) {
            this._text = text;
        }

        public final String getTokenValue() {
            return this._token;
        }

        private String getIdentifier() {
            String offendingStr = "=();";
            StringBuilder returnVal = new StringBuilder();
            if (this._text.charAt(this._index) == '\'') {
                ++this._index;
                while (this._index < this._text.length()) {
                    if (this._text.charAt(this._index) == '\'') {
                        ++this._index;
                        return returnVal.toString();
                    }
                    if (this._text.charAt(this._index) == '\r' || this._text.charAt(this._index) == '\n' || this._text.charAt(this._index) == '\t') {
                        ++this._index;
                        continue;
                    }
                    returnVal.append(this._text.charAt(this._index++));
                }
                return null;
            }
            while (this._index < this._text.length()) {
                if (this._text.charAt(this._index) == '\r' || this._text.charAt(this._index) == '\n' || this._text.charAt(this._index) == '\t') {
                    ++this._index;
                    continue;
                }
                if ("=();".indexOf(this._text.charAt(this._index)) != -1) {
                    return returnVal.toString();
                }
                returnVal.append(this._text.charAt(this._index++));
            }
            return null;
        }

        public final int getNextToken() {
            String trimStr = "=();";
            while (this._index < this._text.length()) {
                if (trimStr.indexOf(this._text.charAt(this._index)) != -1) {
                    this._token = Character.valueOf(this._text.charAt(this._index)).toString();
                    return trimStr.indexOf(this._text.charAt(this._index++));
                }
                if (this._text.charAt(this._index) == '\r' || this._text.charAt(this._index) == '\n' || this._text.charAt(this._index) == '\t' || this._text.charAt(this._index) == ' ') {
                    ++this._index;
                    continue;
                }
                this._token = this.getIdentifier();
                if (this._token == null) continue;
                return 4;
            }
            return -1;
        }
    }

    private static enum State {
        keyNeeded,
        valNeeded;


        public static State forValue(int value) {
            return State.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

