/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.web.session;

import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.web.CacheSession;
import com.alachisoft.ncache.web.EmptySession;
import com.alachisoft.ncache.web.LockException;
import com.alachisoft.ncache.web.config.dom.MultiSiteConfig;
import com.alachisoft.ncache.web.config.dom.PrimaryCache;
import com.alachisoft.ncache.web.config.dom.SecondaryCache;
import com.alachisoft.ncache.web.session.NCacheManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RegionalCache
extends NCacheManager {
    protected static MultiSiteConfig _settings;
    protected static Thread _connectionRecycler;
    protected HashMap _caches;
    protected static String _sid;
    protected String _oldSessionID;

    public RegionalCache(String string, boolean bl, int n, int n2, int n3, boolean bl2, String string2, MultiSiteConfig multiSiteConfig) throws Exception {
        super(string, bl, n, n2, n3, bl2, string2, multiSiteConfig);
        _settings = multiSiteConfig;
        if (_settings != null && _settings.getRecycleInterval() != -1) {
            _connectionRecycler = new Thread(new Runnable(){
                public long interval = _settings.getRecycleInterval() * 60 * 1000;

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(this.interval);
                                RegionalCache.this.RecycleCacheConnection();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            RegionalCache.this.RecycleCacheConnection();
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    @Override
    public String getPrimaryPrefix() {
        return _sid;
    }

    @Override
    public boolean initializeCache(String string, String string2, MultiSiteConfig multiSiteConfig) throws Exception {
        try {
            super.initializeCache(string, string2, multiSiteConfig);
            this._caches = new HashMap();
            _settings = multiSiteConfig;
            if (_settings != null) {
                if (_settings.getPrimaryCache() != null && _settings.getPrimaryCache().length > 0) {
                    for (Serializable serializable : _settings.getPrimaryCache()) {
                        if (this._caches.containsKey(((PrimaryCache)serializable).getId())) continue;
                        this.logger.debug((Object)("Initializing cache: " + ((PrimaryCache)serializable).getId()));
                        this._caches.put(((PrimaryCache)serializable).getId(), CacheManager.getCache((String)((PrimaryCache)serializable).getId()));
                        this._primaryCache = ((PrimaryCache)serializable).getId();
                        _sid = ((PrimaryCache)serializable).getPrefix();
                        break;
                    }
                }
                if (_settings.getSecondaryCache() != null && _settings.getSecondaryCache().length > 0) {
                    for (Serializable serializable : _settings.getSecondaryCache()) {
                        if (this._caches.containsKey(((SecondaryCache)serializable).getId())) continue;
                        try {
                            this._caches.put(((SecondaryCache)serializable).getId(), CacheManager.getCache((String)((SecondaryCache)serializable).getId()));
                        }
                        catch (Exception exception) {
                            if (this.logger == null) continue;
                            this.logger.error((Object)("RegionalCache.InitializeCache:Failed to initialize secondary cache \"" + serializable.toString() + "\". Exception: " + exception.toString()), (Throwable)exception);
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            if (this.logger != null) {
                this.logger.error((Object)("Unable to initialize the cache [" + this._cacheId + "]. See log for more details."), (Throwable)exception);
            }
            throw exception;
        }
    }

    @Override
    public void disconnect() {
        if (this._caches == null) {
            this.logger.debug((Object)"No valid cache instance to disconnect with.");
            return;
        }
        try {
            for (Map.Entry entry : this._caches.entrySet()) {
                Cache cache;
                Cache cache2 = cache = entry.getValue() instanceof Cache ? (Cache)entry.getValue() : null;
                if (cache != null) {
                    this.logger.debug((Object)("Disconnecting with cache: " + this._cacheId.toString()));
                    cache.close();
                }
                this.logger.debug((Object)("Successfully disconnected with cache: " + this._cacheId));
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not disconnect with cache [" + this._cacheId + "]. See log for more details."), (Throwable)exception);
        }
    }

    @Override
    public CacheSession findSessionById(String string) throws LockException, Exception {
        this.logger.debug((Object)("Trying to find session by id: " + string));
        Object object = this.getItem(string);
        if (object != null && object instanceof CacheSession) {
            this.logger.debug((Object)"Found valid session object.");
            return (CacheSession)object;
        }
        if (object instanceof EmptySession) {
            return (EmptySession)object;
        }
        this.logger.debug((Object)("Could not find session [" + string + "] in cache [" + this._cacheId + "]. Returning null."));
        return null;
    }

    private void RecycleCacheConnection() {
        this._sync.AcquireWriterLock();
        try {
            this.DisposeSecondaryCaches();
            this.InitializeSecondaryCaches();
        }
        finally {
            this._sync.ReleaseWriterLock();
        }
    }

    private void DisposeSecondaryCaches() {
        if (this._caches != null) {
            for (Map.Entry entry : this._caches.entrySet()) {
                if (((String)entry.getKey()).toLowerCase().equals(this._primaryCache.toLowerCase())) continue;
                try {
                    ((Cache)entry.getValue()).close();
                }
                catch (Exception exception) {
                    if (this.logger == null) continue;
                    this.logger.error((Object)("RegionalCache.RecycleSecondaryConnections:Failed to dispose \"" + entry.getKey() + "\". Exception: " + exception.toString()), (Throwable)exception);
                }
            }
        }
    }

    private void InitializeSecondaryCaches() {
        if (_settings.getSecondaryCache() != null && _settings.getSecondaryCache().length > 0) {
            for (SecondaryCache secondaryCache : _settings.getSecondaryCache()) {
                try {
                    this._caches.put(secondaryCache.getId(), CacheManager.getCache((String)secondaryCache.getId()));
                }
                catch (Exception exception) {
                    if (this.logger == null) continue;
                    this.logger.error((Object)("RegionalCache.RecycleSecondaryConnections:Failed to initialize \"" + secondaryCache + "\". Exception: " + exception.toString()), (Throwable)exception);
                }
            }
        }
    }

    private String getCacheID(String string) {
        String string2 = "";
        String string3 = "";
        if (string != null) {
            string2 = string.substring(0, 4);
        }
        if (_settings.getPrimaryPrefixes().containsKey(string2)) {
            string3 = (String)_settings.getPrimaryPrefixes().get(string2);
        } else if (_settings.getSecondaryPrefixes().containsKey(string2)) {
            string3 = (String)_settings.getSecondaryPrefixes().get(string2);
        }
        return string3;
    }

    private Object getItem(String string) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, Exception {
        Object object = null;
        Cache cache = this._caches.get(this.getCacheID(string)) instanceof Cache ? this._caches.get(this.getCacheID(string)) : null;
        if (cache != null) {
            object = this.getCacheItem(string, cache, 0);
        } else if (this._currentSessionCache == null || this._currentSessionCache.equals("")) {
            Iterator iterator = this._caches.entrySet().iterator();
            while (iterator.hasNext() && object == null) {
                Map.Entry entry = iterator.next();
                if (cache == null) {
                    cache = this._caches.get(this._primaryCache) instanceof Cache ? this._caches.get(this._primaryCache) : null;
                } else {
                    cache = (Cache)entry.getValue();
                    if (cache.toString().equals(this._primaryCache)) continue;
                }
                object = this.getCacheItem(string, cache, 0);
            }
            this._currentSessionCache = object != null ? cache.toString() : this._primaryCache;
        } else {
            cache = this._caches.get(this._currentSessionCache) instanceof Cache ? this._caches.get(this._currentSessionCache) : null;
            object = this.getCacheItem(string, cache, this.lockTimeOut);
        }
        if (object != null && !cache.toString().equalsIgnoreCase(this._primaryCache)) {
            this._oldSessionID = string;
        }
        return object;
    }

    @Override
    public Cache getCache() {
        Cache cache = this.cache;
        if (this._oldSessionID != null) {
            cache = this._caches.get(this.getCacheID(this._oldSessionID)) instanceof Cache ? this._caches.get(this.getCacheID(this._oldSessionID)) : null;
            this._oldSessionID = null;
        }
        return cache;
    }

    @Override
    public boolean isEmptySession() {
        return this._emptySessionWhenLocked;
    }
}

