/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.web.session;

import java.util.HashMap;
import org.apache.log4j.Logger;

public class SessionMonitor {
    private static HashMap localCache = new HashMap();
    private static Logger logger = Logger.getLogger(SessionMonitor.class);

    public static int getRequestCount(String string) {
        if (localCache.containsKey(string)) {
            Integer n = (Integer)localCache.get(string);
            logger.debug((Object)("Request count is: " + n + " for session (id = " + string + ")"));
            return n;
        }
        logger.debug((Object)"No request (other than this) is currently using this session");
        return 0;
    }

    public static void addRequest(String string) {
        localCache.put(string, new Integer(SessionMonitor.getRequestCount(string) + 1));
        logger.debug((Object)("Another request is using the same session (id = " + string + ")"));
    }

    public static void removeRequest(String string) {
        int n = SessionMonitor.getRequestCount(string) - 1;
        if (n <= 0) {
            localCache.remove(string);
        } else {
            localCache.put(string, new Integer(n));
        }
        logger.debug((Object)("A request completed for session (id = " + string + "), count is: " + n));
    }

    public static void resetRequestCount(String string) {
        localCache.remove(string);
        logger.debug((Object)("Session (id = " + string + ") removed from local cache"));
    }
}

