/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.deactivate.cmdline;

import com.alachisoft.ncache.deactivate.cmdline.DeactivateArgs;
import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.cmdline.LicenseTool;
import com.alachisoft.ncache.ncactivate.cmdline.exceptions.CorruptInstallationException;
import com.alachisoft.ncache.ncactivate.crypto.Crypto;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.ncactivate.utils.StringRef;
import com.alachisoft.ncache.ncactivate.utils.WebUtil;
import com.alachisoft.ncache.ncactivate.utils.XmlUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;

public class DeactivateTool
extends LicenseTool {
    @Override
    public void Run(String[] args) {
        if (super.intialize(args, new DeactivateArgs())) {
            super.pringLogo();
            if (!super.printUsage()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.Run();
            }
        }
    }

    @Override
    public void Run() {
        DeactivateArgs cmdArgs = (DeactivateArgs)super.getCmdArgs();
        HashMap<String, String> requiredParams = new HashMap<String, String>();
        requiredParams.put("deactivation code", cmdArgs.getDeactivateKey());
        if (this.checkRequiredParams(requiredParams)) {
            try {
                super.getAppUtil().DeactStub();
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                System.exit(1);
            }
            RegUtil.setKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.DeactivateKey, (String)cmdArgs.getDeactivateKey());
            RegUtil.StoreRegistry();
            super.getAppUtil();
            AppUtil.getActivationData().Load();
            super.getAppUtil().DeactKey(RegUtil.getKey((InfoType)InfoType.PRODUCT, (RegKeys)RegKeys.DeactCode));
            if (cmdArgs.getManual().booleanValue()) {
                System.out.println("Please copy the following code and email to Alachisoft sales personnel or to sales@alachisoft.com \n\n" + super.getMachineInfoCode());
            } else {
                this.onlineDeactivation();
            }
        }
    }

    public void onlineDeactivation() {
        String strHeaders = new String("Content-Type: application/x-www-form-urlencoded\r\n");
        super.getAppUtil();
        String actXml = AppUtil.getActivationData().ToLinearText();
        super.getAppUtil();
        String edition = AppUtil.getActivationData().Product.Edition;
        String strFormData = String.format("activationText=%s&Edition=%s&Action=%s", WebUtil.UrlEncode(Crypto.Encode(actXml)), edition, "deactivation");
        StringBuilder deactivationConsole = new StringBuilder();
        System.out.println("Contacting license server...\r\n");
        try {
            char tmpChar;
            URL postUrl = new URL("http://app.alachisoft.com/activate/activate.php");
            HttpURLConnection con = (HttpURLConnection)postUrl.openConnection();
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Host", "app.alachisoft.com");
            con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            con.setRequestProperty("Content-Length", String.valueOf(strFormData.length()));
            DataOutputStream connOut = new DataOutputStream(con.getOutputStream());
            connOut.writeBytes(strFormData);
            connOut.flush();
            connOut.close();
            int rc = con.getResponseCode();
            String strMsg = super.getStringTableProps().getProperty(String.valueOf(rc + 1000));
            if (rc >= 400 && rc <= 599) {
                deactivationConsole.append("Request/Server Error: Status Code = ");
                deactivationConsole.append(String.valueOf(rc)).append("\r\n").append("Message: ").append(strMsg).append("\r\n");
                System.out.println(deactivationConsole.toString());
                return;
            }
            deactivationConsole.append(String.valueOf(rc)).append("\r\n").append("Message: ").append(strMsg).append("\r\n\r\n").append("Requesting validation...\r\n").append("Waiting for status...\r\n");
            System.out.println(deactivationConsole.toString());
            DataInputStream connIn = new DataInputStream(con.getInputStream());
            BufferedReader d = new BufferedReader(new InputStreamReader(connIn));
            while (!d.ready()) {
            }
            Object serverResp = new String("");
            char noChar = '\uffff';
            do {
                tmpChar = (char)d.read();
                serverResp = (String)serverResp + tmpChar;
            } while (tmpChar != noChar);
            StringRef extractedMessage = new StringRef();
            XmlUtil.ExtractFromXML("<text>", (String)serverResp, extractedMessage);
            if (((String)serverResp).indexOf("<error>") != -1) {
                deactivationConsole = new StringBuilder();
                deactivationConsole.append("\r\n").append(extractedMessage.strData);
                System.out.println(deactivationConsole.toString());
                return;
            }
            StringRef szDeactKey = new StringRef();
            XmlUtil.ExtractFromXML("<auth-key>", (String)serverResp, szDeactKey);
            super.getAppUtil();
            AppUtil.VerifyResult result = AppUtil.VerifAuthKey(szDeactKey.strData);
            if (result != AppUtil.VerifyResult.Success) {
                System.out.println("Invalid activation key specified\r\n" + strMsg);
                return;
            }
            super.getAppUtil().DeactKey(szDeactKey.strData);
            System.out.println("\r\n" + extractedMessage.strData);
        }
        catch (Exception e) {
            System.out.println("Connection failed: " + e.getMessage());
            return;
        }
    }
}

