/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing;

import com.alachisoft.ncache.licensing.ExpirationInfo;
import com.alachisoft.ncache.licensing.LicScheme;
import com.alachisoft.ncache.licensing.LicenseHelper;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.ncactivate.license.ActivationStatus;
import com.alachisoft.ncache.ncactivate.license.ByteRef;
import com.alachisoft.ncache.ncactivate.license.NCCpuInfo;
import com.alachisoft.ncache.ncactivate.license.NCCrypto;
import com.alachisoft.ncache.ncactivate.license.NCFileUtil;
import com.alachisoft.ncache.ncactivate.license.NCMisc;
import com.alachisoft.ncache.ncactivate.license.SystemTime;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.ncactivate.utils.StringRef;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LocalVerificationFailedException;
import com.alachisoft.ncache.runtime.util.RuntimeUtil;
import com.alachisoft.ncache.util.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class License {
    private static final String winStub = RegUtil.winStub;
    private static final String linuxStub = RegUtil.linuxStub;
    public static LicScheme LicenseScheme;

    public static String[] getStubPaths() {
        String[] systemFolder = null;
        if (RuntimeUtil.getCurrentOS().equals((Object)RuntimeUtil.OS.Windows)) {
            String sys32Folder = System.getenv("WINDIR") + "\\system32";
            systemFolder = new String[]{sys32Folder};
            for (int i = 0; i < systemFolder.length; ++i) {
                systemFolder[i] = systemFolder[i] + "\\" + winStub;
            }
        } else {
            systemFolder = new String[]{"//usr//lib//" + linuxStub, "//usr//bin//" + linuxStub};
        }
        return systemFolder;
    }

    public static boolean isFree(int edid) {
        return edid == 19 || edid == 20 || edid == 29;
    }

    public static void isActivated(int version) throws LicensingException, LocalVerificationFailedException {
        SystemTime pSysTime = new SystemTime();
        String[] systemFolder = null;
        RuntimeUtil.OS currentOS = RuntimeUtil.getCurrentOS();
        try {
            systemFolder = NCMisc.getStubPath();
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new LicensingException("Invalid Authentication Code: Stage 006");
        }
        ByteRef data = NCMisc.ReadEvaluationData(systemFolder);
        NCMisc.GetInstallTime(data.data, version, pSysTime);
        if (pSysTime.wSecond == ActivationStatus.Deactivated.getOrdinal(ActivationStatus.Deactivated)) {
            throw new LicensingException("Invalid Authentication Code: Stage 009");
        }
        if (currentOS == RuntimeUtil.OS.Windows && (LicenseManager.getEdition().equals((Object)LicenseManager.Edition.enterpriseClient) || LicenseManager.getEdition().equals((Object)LicenseManager.Edition.profClient))) {
            for (int i = 0; i < systemFolder.length; ++i) {
                String ncStubFolder = systemFolder[i].replace(winStub, "ncstub.bin");
                if (!NCFileUtil.FileExists(ncStubFolder)) continue;
                data = NCFileUtil.ReadFile(systemFolder[i]);
                if (data == null) {
                    throw new LicensingException("Invalid Authentication Code: Stage 007");
                }
                if (data.data == null) {
                    throw new LicensingException("Invalid Authentication Code: Stage 008");
                }
                NCMisc.GetInstallTime(data.data, version, pSysTime);
                if (pSysTime.wSecond != ActivationStatus.Deactivated.getOrdinal(ActivationStatus.Deactivated)) break;
                throw new LicensingException("Invalid Authentication Code: Stage 009");
            }
        }
    }

    public static void isActivated(int version, byte[] data) throws LicensingException {
        SystemTime pSysTime = new SystemTime();
        NCMisc.GetInstallTime(data, version, pSysTime);
        if (pSysTime.wSecond == ActivationStatus.Deactivated.getOrdinal(ActivationStatus.Deactivated)) {
            throw new LicensingException("Invalid Authentication Code: Stage 009");
        }
    }

    public static void IsValid(String version) throws LicensingException, LocalVerificationFailedException {
        ArrayList macs;
        try {
            macs = EnvironmentUtil.GetAdaptersInfo();
            for (String string : macs) {
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IOException ex) {
            if (Trace.isOn()) {
                Trace.out.println("License: isValid() " + ex.toString());
            }
            throw new LicensingException("License not verified due to following reason: " + ex.toString());
        }
        License.IsValid(version, NCCpuInfo.GetNumProcessors(), macs, NCCpuInfo.getPhysicalCoreCount(), NCCpuInfo.getLogicalCoreCount(), NCCpuInfo.getSocketCount());
    }

    public static Integer Decode(byte[] data) {
        ByteRef refBytes = new ByteRef();
        refBytes.data = data;
        NCCrypto.EncryptDecryptBytes(refBytes, data.length, 0);
        String cpuCountString = new String(refBytes.data, Charset.forName("utf-8"));
        return Integer.decode(cpuCountString);
    }

    public static String convertToString(byte[] data) {
        ByteRef refBytes = new ByteRef();
        refBytes.data = data;
        NCCrypto.EncryptDecryptBytes(refBytes, data.length, 0);
        return new String(refBytes.data, Charset.forName("utf-8"));
    }

    public static void IsValid(String version, byte[] data1, byte[] data2, byte[] data3, byte[] data4, byte[] data5) throws LicensingException {
        ArrayList<String> macs;
        int numCPU = 0;
        numCPU = License.Decode(data1);
        ByteRef refBytes = new ByteRef();
        refBytes.data = data2;
        NCCrypto.EncryptDecryptBytes(refBytes, data2.length, 0);
        String macAddressString = new String(refBytes.data, Charset.forName("utf-8"));
        if (macAddressString != null) {
            String[] parsedmacAddress = macAddressString.split(";");
            macs = new ArrayList<String>();
            for (int i = 0; i < parsedmacAddress.length; ++i) {
                macs.add(parsedmacAddress[i]);
            }
        }
        try {
            macs = EnvironmentUtil.GetAdaptersInfo();
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IOException ex) {
            if (Trace.isOn()) {
                Trace.out.println("License: isValid() " + ex.toString());
            }
            throw new LicensingException("License not verified due to following reason: " + ex.toString());
        }
        int physicalCoreCount = License.Decode(data3);
        int logicalCoreCount = License.Decode(data4);
        int socketCount = License.Decode(data5);
        License.IsValid(version, numCPU, macs, physicalCoreCount, logicalCoreCount, socketCount);
    }

    private static ExpirationInfo IsValid(String version, int cpuCount, ArrayList macs, int physicalCoreCount, int logicalCoreCount, int socketCount) throws LicensingException {
        ExpirationInfo ei;
        block18: {
            ei = new ExpirationInfo();
            try {
                String[] authTokens;
                String scheme;
                StringRef ac = new StringRef();
                String authCode = "";
                NCMisc.ReadActivationCode(ac);
                if (!ac.strData.trim().equals("")) {
                    authCode = ac.strData;
                }
                if ((scheme = (authTokens = authCode.split(":"))[0].toLowerCase()).compareTo("cpu") == 0) {
                    LicenseScheme = LicScheme.PerProcessor;
                } else if (scheme.compareTo("node") == 0) {
                    LicenseScheme = LicScheme.PerNode;
                } else {
                    throw new LicensingException(" Invalid Authentication Code: Stage 001 ");
                }
                String machineName = InetAddress.getLocalHost().getHostName().toLowerCase();
                if (machineName.compareTo(authTokens[1].toLowerCase()) != 0) {
                    throw new LicensingException(" Invalid Authentication Code: Stage 002 ");
                }
                if (!authTokens[5].contains(version)) {
                    throw new LicensingException(" Invalid Authentication Code: Stage 004");
                }
                boolean hasMac1 = macs.contains(authTokens[9].toLowerCase());
                boolean hasMac2 = macs.contains(authTokens[10].toLowerCase());
                boolean hasMac3 = macs.contains(authTokens[11].toLowerCase());
                boolean hasMac4 = macs.contains(authTokens[12].toLowerCase());
                if (!(hasMac1 || hasMac2 || hasMac3 || hasMac4)) {
                    throw new LicensingException("Invalid Authentication Code: Stage 005");
                }
                if (!authTokens[6].equals("null")) {
                    try {
                        Calendar expiration = LicenseHelper.getUTCDate(authTokens[6]);
                        int gracePeriod = Integer.parseInt(authTokens[7]);
                        ei.setExpirationDate(expiration);
                        ei.setGracePeriod(gracePeriod);
                        if (LicenseHelper.getUTCDate().after(ei.getHardExpirationDate())) {
                            throw new LicensingException("License for NCache has been expired.--Stage11");
                        }
                        break block18;
                    }
                    catch (ParseException ex) {
                        throw new LicensingException("Invalid Authentication Code: Stage 010");
                    }
                }
                ei.setIsPerpetual(true);
            }
            catch (LicensingException le) {
                throw new LicensingException("License not verified due to following reason: " + le.toString());
            }
            catch (MissingResourceException mre) {
                throw new LicensingException("License not verified due to following reason: " + mre.toString());
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (Exception ex) {
                if (Trace.isOn()) {
                    Trace.out.println("License: isValid() " + ex.toString());
                }
                throw new LicensingException("License not verified due to following reason: " + ex.toString());
            }
        }
        return ei;
    }

    public static ExpirationInfo GetExpirationInfo() {
        ArrayList macs = null;
        ExpirationInfo info = new ExpirationInfo();
        try {
            macs = EnvironmentUtil.GetAdaptersInfo();
            for (String string : macs) {
            }
            info = License.IsValid(AppUtil.getVersion(), NCCpuInfo.GetNumProcessors(), macs, NCCpuInfo.getPhysicalCoreCount(), NCCpuInfo.getLogicalCoreCount(), NCCpuInfo.getSocketCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    private static String[] getWinSystemDir(String delim, String prop) {
        StringTokenizer tokanizer = new StringTokenizer(prop);
        Vector<String> v = new Vector<String>();
        String token = "";
        while (tokanizer.hasMoreTokens()) {
            token = tokanizer.nextToken(";");
            if (token.indexOf(delim) == -1 || v.contains(token)) continue;
            v.add(token);
        }
        return v.toArray(new String[0]);
    }

    public static void IsValid() throws LicensingException {
        try {
            StringRef ac = new StringRef();
            NCMisc.ReadActivationCode(ac);
            String authCode = ac.strData;
            String[] parts = ac.strData.split(":");
            String scheme = parts[0].toLowerCase();
            if (scheme.compareTo("cpu") == 0) {
                LicenseScheme = LicScheme.PerProcessor;
            } else if (scheme.compareTo("node") == 0) {
                LicenseScheme = LicScheme.PerNode;
            } else {
                throw new LicensingException(" Invalid Authentication Code: Stage 001 ");
            }
            String machineName = InetAddress.getLocalHost().getHostName().toLowerCase();
            if (machineName.compareTo(parts[1].toLowerCase()) != 0) {
                throw new LicensingException(" Invalid Authentication Code: Stage 002 ");
            }
            ArrayList macs = EnvironmentUtil.GetAdaptersInfo();
            boolean hasMac1 = macs.contains(parts[9].toLowerCase());
            boolean hasMac2 = macs.contains(parts[10].toLowerCase());
            boolean hasMac3 = macs.contains(parts[11].toLowerCase());
            boolean hasMac4 = macs.contains(parts[12].toLowerCase());
            if (!(hasMac1 || hasMac2 || hasMac3 || hasMac4)) {
                throw new LicensingException("Invalid Authentication Code: Stage 005");
            }
        }
        catch (LicensingException le) {
            throw new LicensingException("License not verified due to following reason: " + le.toString());
        }
        catch (MissingResourceException mre) {
            throw new LicensingException("License not verified due to following reason: " + mre.toString());
        }
        catch (Exception ex) {
            if (Trace.isOn()) {
                Trace.out.println("License: isValid() " + ex.toString());
            }
            throw new LicensingException("License not verified due to following reason: " + ex.toString());
        }
    }
}

