/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class LicenseHelper {
    static TimeZone utc = TimeZone.getTimeZone("UTC");
    private static long DAY = 86400000L;

    public static Calendar getUTCDate() {
        Calendar utcCalander = Calendar.getInstance(utc);
        utcCalander.set(11, 0);
        utcCalander.set(12, 0);
        utcCalander.set(13, 0);
        utcCalander.set(14, 0);
        return utcCalander;
    }

    public static Calendar getCopy(Calendar c) {
        Calendar calendar = Calendar.getInstance(utc);
        calendar.setTimeInMillis(c.getTimeInMillis());
        return calendar;
    }

    public static Calendar getUTCDate(String date) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        df.setTimeZone(utc);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(utc);
        c.setTime(df.parse(date));
        return c;
    }

    public static long DifferenceInDays(Calendar end, Calendar start) {
        return (end.getTimeInMillis() - start.getTimeInMillis()) / DAY;
    }

    public static String getString(Calendar date) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy");
        df.setTimeZone(utc);
        return df.format(date.getTime());
    }
}

