/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing;

import com.alachisoft.ncache.ncactivate.appdata.MachineInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import tangible.DotNetToJavaStringHelper;

public class LicenseInfo
implements Serializable {
    static LicenseInfo licenseInfo;
    public ArrayList macsInfo;
    private int cores;
    private int processors;
    private String version = "";
    private String mac1 = "";
    private String mac2 = "";
    private String mac3 = "";
    private String mac4 = "";
    private String machineName = "";

    public static LicenseInfo deserialize(String data) {
        String[] tokens = data.split("[,]", -1);
        LicenseInfo info = new LicenseInfo();
        info.setCores(Integer.parseInt(tokens[0]));
        info.setProcessors(Integer.parseInt(tokens[1]));
        info.setVersion(tokens[2]);
        info.setMac1(tokens[3]);
        info.setMac2(tokens[4]);
        info.setMac3(tokens[5]);
        info.setMac4(tokens[6]);
        info.setMachineName(tokens[7]);
        return info;
    }

    public static LicenseInfo getLicenseInfo() {
        MachineInfo machineInfo = new MachineInfo();
        if (licenseInfo == null) {
            licenseInfo = new LicenseInfo();
            licenseInfo.setMachineName(machineInfo.ComputerName);
            licenseInfo.setCores(machineInfo.NumCpus);
            licenseInfo.setVersion("5.1");
            ArrayList<String> macs = machineInfo.getMacs();
            licenseInfo.setMacsInfo(macs);
            if (macs.size() > 0) {
                licenseInfo.setMac1(macs.get(0).toLowerCase());
                if (macs.size() > 1) {
                    licenseInfo.setMac2(macs.get(1).toLowerCase());
                    if (macs.size() > 2) {
                        licenseInfo.setMac3(macs.get(2).toLowerCase());
                        if (macs.size() > 3) {
                            licenseInfo.setMac4(macs.get(3).toLowerCase());
                        }
                    }
                }
            }
        }
        return licenseInfo;
    }

    public ArrayList getMacsInfo() {
        return this.macsInfo;
    }

    public String getStringMacInfo() {
        ArrayList<String> macList = new ArrayList<String>();
        macList.add(this.getMac1());
        macList.add(this.getMac2());
        macList.add(this.getMac3());
        macList.add(this.getMac4());
        Collections.sort(macList);
        return (String)macList.get(0) + ":" + (String)macList.get(1) + ":" + (String)macList.get(2) + ":" + (String)macList.get(3);
    }

    public void setMacsInfo(ArrayList macsInfo) {
        this.macsInfo = macsInfo;
    }

    public final int getCores() {
        return this.cores;
    }

    public final void setCores(int value) {
        this.cores = value;
    }

    public final int getProcessors() {
        return this.processors;
    }

    public final void setProcessors(int value) {
        this.processors = value;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String value) {
        this.version = value;
    }

    public final String getMac1() {
        return this.mac1;
    }

    public final void setMac1(String value) {
        this.mac1 = value;
    }

    public final String getMac2() {
        return this.mac2;
    }

    public final void setMac2(String value) {
        this.mac2 = value;
    }

    public final String getMac3() {
        return this.mac3;
    }

    public final void setMac3(String value) {
        this.mac3 = value;
    }

    public final String getMac4() {
        return this.mac4;
    }

    public final void setMac4(String value) {
        this.mac4 = value;
    }

    public final String getMachineName() {
        return this.machineName;
    }

    public final void setMachineName(String value) {
        this.machineName = value;
    }

    public final String serialize() {
        StringBuilder data = new StringBuilder();
        data.append(String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s", this.getCores(), this.getProcessors(), this.getVersion(), this.getMac1(), this.getMac2(), this.getMac3(), this.getMac4(), this.getMachineName()));
        return data.toString();
    }

    public boolean equals(Object obj) {
        LicenseInfo info = (LicenseInfo)obj;
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac1()) && this.getMac1().equals(info.getMac1()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac1()) && this.getMac1().equals(info.getMac2()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac1()) && this.getMac1().equals(info.getMac3()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac1()) && this.getMac1().equals(info.getMac4()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac2()) && this.getMac2().equals(info.getMac2()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac2()) && this.getMac2().equals(info.getMac3()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac2()) && this.getMac2().equals(info.getMac4()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac3()) && this.getMac3().equals(info.getMac3()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac3()) && this.getMac3().equals(info.getMac4()) || !DotNetToJavaStringHelper.isNullOrEmpty((String)this.getMac4()) && this.getMac4().equals(info.getMac4())) {
            return true;
        }
        return !this.getMac1().equals("") && this.getMac1() != null && this.getMac1().equals(info.getMac1()) || !this.getMac1().equals("") && this.getMac1() != null && this.getMac1().equals(info.getMac2()) || !this.getMac1().equals("") && this.getMac1() != null && this.getMac1().equals(info.getMac3()) || !this.getMac1().equals("") && this.getMac1() != null && this.getMac1().equals(info.getMac4()) || !this.getMac2().equals("") && this.getMac2() != null && this.getMac2().equals(info.getMac2()) || !this.getMac2().equals("") && this.getMac2() != null && this.getMac2().equals(info.getMac3()) || !this.getMac2().equals("") && this.getMac2() != null && this.getMac2().equals(info.getMac4()) || !this.getMac3().equals("") && this.getMac3() != null && this.getMac3().equals(info.getMac3()) || !this.getMac3().equals("") && this.getMac3() != null && this.getMac3().equals(info.getMac4()) || !this.getMac4().equals("") && this.getMac4() != null && this.getMac4().equals(info.getMac4());
    }

    public final boolean Update(LicenseInfo item) {
        boolean modified = false;
        if (item.getCores() > this.getCores()) {
            this.setCores(item.getCores());
            modified = true;
        }
        if (item.getProcessors() > this.getProcessors()) {
            this.setProcessors(item.getProcessors());
            modified = true;
        }
        if (!this.getVersion().equals(item.getVersion())) {
            this.setVersion(item.getVersion());
            modified = true;
        }
        if (!this.getMachineName().equals(item.getMachineName())) {
            this.setMachineName(item.getMachineName());
            modified = true;
        }
        return modified;
    }
}

