/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.EventLogger;
import com.alachisoft.ncache.licensing.ExpirationInfo;
import com.alachisoft.ncache.licensing.ExpirationStatus;
import com.alachisoft.ncache.licensing.License;
import com.alachisoft.ncache.licensing.LicenseHelper;
import com.alachisoft.ncache.licensing.LicenseManager;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class LicenseMonitor
implements IDisposable {
    private static LicenseMonitor _monitor = null;
    private Calendar _lastNotificationDate;
    private ExpirationStatus _lastExpirationStatus;
    private final TimerTask OnNotifyUser = new TimerTask(){

        @Override
        public synchronized void run() {
            ExpirationInfo expirationInfo = License.GetExpirationInfo();
            if (LicenseMonitor.this.DoNotify(expirationInfo)) {
                switch (expirationInfo.getExpirationStatus()) {
                    case Expired: {
                        EventLogger.LogEvent((String)"NCache has expired on this machine.", (EventType)EventType.ERROR);
                        LicenseManager.onLicenseExpiration();
                        break;
                    }
                    case InGracePeriod: {
                        EventLogger.LogEvent((String)String.format("NCache has expired on this machine. Grace period of %d days will expire on %s.", expirationInfo.getGracePeriod(), LicenseHelper.getString(expirationInfo.getHardExpirationDate())), (EventType)EventType.WARNING);
                        break;
                    }
                    case Licensed: {
                        EventLogger.LogEvent((String)String.format("NCache will expire on this machine on %s.", LicenseHelper.getString(expirationInfo.getHardExpirationDate())), (EventType)EventType.WARNING);
                        break;
                    }
                }
            }
        }
    };
    private Timer _notificationTimer;

    private LicenseMonitor() {
        this._lastNotificationDate = LicenseHelper.getUTCDate();
        this._lastNotificationDate.add(5, -365);
        this._lastExpirationStatus = ExpirationStatus.Licensed;
        long licenseCheckInterval = 86400000L;
        String interval = AppUtil.GetAppSetting((String)"CacheServer.LicenseCheckInterval");
        try {
            licenseCheckInterval = Long.parseLong(interval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._notificationTimer = new Timer();
        this._notificationTimer.scheduleAtFixedRate(this.OnNotifyUser, new Date(), licenseCheckInterval);
    }

    public static LicenseMonitor getInstance() {
        return _monitor;
    }

    public static synchronized boolean VerifyLicenseMonitoring() {
        if (_monitor == null) {
            _monitor = new LicenseMonitor();
        }
        return LicenseMonitor._monitor._notificationTimer != null;
    }

    private boolean DoNotify(ExpirationInfo expirationInfo) {
        boolean statusChanged = false;
        if (expirationInfo.getExpirationStatus() != this._lastExpirationStatus) {
            this._lastExpirationStatus = expirationInfo.getExpirationStatus();
            statusChanged = true;
        }
        switch (expirationInfo.getExpirationStatus()) {
            case Expired: 
            case InGracePeriod: {
                return this._lastNotificationDate.compareTo(LicenseHelper.getUTCDate()) != 0 || statusChanged;
            }
            case InEvaluation: {
                return false;
            }
            case Licensed: {
                long daysToExpire = 0L;
                daysToExpire = LicenseHelper.DifferenceInDays(expirationInfo.getExpirationDate(), LicenseHelper.getUTCDate());
                if (daysToExpire > 60L) {
                    return false;
                }
                if (daysToExpire > 10L) {
                    return LicenseHelper.DifferenceInDays(LicenseHelper.getUTCDate(), this._lastNotificationDate) > 7L;
                }
                return this._lastNotificationDate.compareTo(LicenseHelper.getUTCDate()) != 0;
            }
        }
        return true;
    }

    public void dispose() {
        try {
            this._lastNotificationDate = null;
            this._lastExpirationStatus = null;
            if (this._notificationTimer != null) {
                this._notificationTimer.cancel();
            }
            _monitor = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

