/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.appdata;

import com.alachisoft.ncache.ncactivate.license.NCCpuInfo;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public class MachineInfo {
    public String ComputerName;
    public int NumCpus = 0;
    public int PhysicalCpus = 0;
    public String Mac1 = new String("");
    public String Mac2 = new String("");
    public String Mac3 = new String("");
    public String Mac4 = new String("");

    public MachineInfo() {
        this.Load();
    }

    public int Load() {
        try {
            this.ComputerName = EnvironmentUtil.getComputerName();
            this.ComputerName = this.ComputerName.toUpperCase();
            this.NumCpus = NCCpuInfo.GetNumProcessors();
            this.PhysicalCpus = NCCpuInfo.getPhysicalCoreCount();
            ArrayList adapters = EnvironmentUtil.GetAdaptersInfo();
            int num = adapters.size();
            if (num > 0) {
                this.Mac1 = (String)adapters.get(0);
            }
            if (num > 1) {
                this.Mac2 = (String)adapters.get(1);
            }
            if (num > 3) {
                this.Mac3 = (String)adapters.get(2);
            }
            if (num > 4) {
                this.Mac4 = (String)adapters.get(3);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void Save() {
    }

    public String ToXml() {
        Object xml = new String("<machine>");
        xml = (String)xml + "<name>";
        xml = (String)xml + this.ComputerName;
        xml = (String)xml + "</name>";
        String numCpu = new String();
        String.format(Locale.US, "%d", this.NumCpus);
        xml = (String)xml + "<cpu-count>";
        xml = (String)xml + numCpu;
        xml = (String)xml + "</cpu-count>";
        String physicalCpus = new String();
        String.format(Locale.US, "%d", this.PhysicalCpus);
        xml = (String)xml + "<physical-cpus>";
        xml = (String)xml + physicalCpus;
        xml = (String)xml + "</physical-cpus>";
        xml = (String)xml + "<mac1>";
        xml = (String)xml + this.Mac1;
        xml = (String)xml + "</mac1>";
        xml = (String)xml + "<mac2>";
        xml = (String)xml + this.Mac2;
        xml = (String)xml + "</mac2>";
        xml = (String)xml + "<mac3>";
        xml = (String)xml + this.Mac3;
        xml = (String)xml + "</mac3>";
        xml = (String)xml + "<mac4>";
        xml = (String)xml + this.Mac4;
        xml = (String)xml + "</mac4>";
        xml = (String)xml + "</machine>";
        return xml;
    }

    public ArrayList<String> getMacs() {
        ArrayList<String> macs = new ArrayList<String>();
        if (this.Mac1 != "") {
            macs.add(this.Mac1);
        }
        if (this.Mac2 != "") {
            macs.add(this.Mac2);
        }
        if (this.Mac3 != "") {
            macs.add(this.Mac3);
        }
        if (this.Mac4 != "") {
            macs.add(this.Mac4);
        }
        return macs;
    }

    public String ToLinearText() {
        String text = String.format(Locale.US, "%s\t%d\t%d\t%s\t%s\t%s\t%s", this.ComputerName, this.NumCpus, this.PhysicalCpus, this.Mac1, this.Mac2, this.Mac3, this.Mac4);
        return text;
    }
}

