/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.appdata;

import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.crypto.Crypto;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import java.util.Locale;

public class ProductInfo {
    public String ProductName;
    public String Edition;
    public String Version;
    public String LicenseKey;
    public String ActId;
    public String[] LicSchemes;
    public String DeactivateCode;
    public int VersionId;
    public boolean Reactivation;

    public int Load() {
        this.ProductName = new String("NCache");
        String installCode = new String();
        installCode = RegUtil.getKey((InfoType)InfoType.PRODUCT, (RegKeys)RegKeys.InstallCode);
        if ("".equals(installCode)) {
            return -1;
        }
        installCode = Crypto.Decode(installCode);
        String[] tokens = installCode.split(":");
        this.Edition = tokens[0];
        String supportedSchemes = tokens[1];
        this.Version = tokens[2];
        this.LicenseKey = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.LicenseKey);
        String authCode = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode);
        this.ActId = AppUtil.getActivationID(authCode);
        if ("".equals(this.ActId)) {
            this.ActId = EnvironmentUtil.NewGUID();
        }
        this.LicSchemes = supportedSchemes.split(",");
        this.DeactivateCode = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.DeactCode);
        this.VersionId = AppUtil.getEditionID();
        return 0;
    }

    public void Save() {
        RegUtil.setKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.LicenseKey, (String)this.LicenseKey);
    }

    public String ToXml() {
        Object xml = new String("<product-info>");
        xml = (String)xml + "<name>";
        xml = (String)xml + this.ProductName;
        xml = (String)xml + "</name>";
        xml = (String)xml + "<edition>";
        xml = (String)xml + this.Edition;
        xml = (String)xml + "</edition>";
        xml = (String)xml + "<version>";
        xml = (String)xml + this.Version;
        xml = (String)xml + "</version>";
        xml = (String)xml + "<license-key>";
        xml = (String)xml + this.LicenseKey;
        xml = (String)xml + "</license-key>";
        xml = (String)xml + "<act-id>";
        xml = (String)xml + this.ActId;
        xml = (String)xml + "</act-id>";
        xml = (String)xml + "<deactivate-code>";
        xml = (String)xml + this.DeactivateCode;
        xml = (String)xml + "</deactivate-code>";
        xml = (String)xml + "<reactivation>";
        xml = (String)xml + (this.Reactivation ? "true" : "false");
        xml = (String)xml + "</deactivate-code>";
        xml = (String)xml + "</product-info>";
        return xml;
    }

    public String ToLinearText() {
        String reactivationString = this.Reactivation ? "true" : "false";
        String text = String.format(Locale.US, "%1$s\t%2$s\t%3$s\t%4$s\t%5$s\t%6$s\t%7$s", this.ProductName, this.Edition, this.Version, this.LicenseKey, this.ActId, this.DeactivateCode, reactivationString);
        return text;
    }

    boolean IsLicSchemeSupported(String licScheme) {
        for (String scheme : this.LicSchemes) {
            if (scheme.compareToIgnoreCase(licScheme) != 0) continue;
            return true;
        }
        return false;
    }
}

