/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.license;

import com.alachisoft.ncache.ncactivate.license.NCCpuInfo;
import com.alachisoft.ncache.ncactivate.license.NCMisc;
import com.alachisoft.ncache.ncactivate.license.NetworkInfo;
import com.alachisoft.ncache.ncactivate.license.SystemTime;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LocalVerificationFailedException;
import java.io.IOException;
import java.util.ArrayList;

public class EvaluationData {
    public short Year;
    public short Month;
    public short Days;
    public short ExtensionVal;
    public short Extensions;
    public short Period;
    public short ActivationStatus;
    public short Res3;

    public static int GetNumProcessors() throws LicensingException, LocalVerificationFailedException {
        return NCCpuInfo.GetNumProcessors();
    }

    public static ArrayList GetAdaptersAddressList() throws IOException {
        return NetworkInfo.getMacAddress();
    }

    public static int ReadEvaluationData(int version, EvaluationData time) throws LicensingException, LocalVerificationFailedException {
        String[] systemFolder = null;
        try {
            systemFolder = NCMisc.getStubPath();
            return EvaluationData.ReadEvaluationData(NCMisc.ReadEvaluationData((String[])systemFolder).data, version, time);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int ReadEvaluationData(byte[] evalData, int version, EvaluationData time) throws LicensingException {
        SystemTime pTime = new SystemTime();
        int nResult = NCMisc.ReadEvaluationData(evalData, version, pTime);
        EvaluationData.convertToEvalData(pTime, time);
        return nResult;
    }

    private static void convertToEvalData(SystemTime pTime, EvaluationData time) {
        time.Year = pTime.wYear;
        time.Month = pTime.wMonth;
        time.Days = pTime.wDayOfWeek;
        time.ExtensionVal = pTime.wDay;
        time.Extensions = pTime.wHour;
        time.Period = pTime.wMinute;
        time.ActivationStatus = pTime.wSecond;
        time.Res3 = pTime.wMilliseconds;
    }
}

