/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.license;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class NetworkInfo {
    public static final ArrayList getMacAddress() throws IOException {
        try {
            return NetworkInfo.getMacAddresses();
        }
        catch (Exception ex) {
            throw new IOException("Unable to retrieve MAC address:" + ex.getMessage());
        }
    }

    private static final ArrayList linuxParseMacAddress(String ipConfigResponse) throws ParseException {
        ArrayList<String> macAddr = new ArrayList<String>(4);
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        int macCount = 0;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate = tokenizer.nextToken().trim();
            if (!NetworkInfo.linuxIsMacAddress(macAddressCandidate)) continue;
            lastMacAddress = macAddressCandidate;
            macAddr.add(macAddressCandidate);
            ++macCount;
        }
        if (macCount > 0) {
            return macAddr;
        }
        ParseException ex = new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        throw ex;
    }

    private static final boolean linuxIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static final String linuxIpCommand() throws IOException {
        int c;
        String[] cmd = new String[]{"/bin/sh", "-c", "ip  addr | awk '/ether/ {print $2}'"};
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        if (outputText.isEmpty()) {
            return NetworkInfo.linuxRunIfConfigCommand();
        }
        return outputText;
    }

    private static final String linuxRunIfConfigCommand() throws IOException {
        int c;
        String[] cmd = new String[]{"/bin/sh", "-c", "ifconfig -a | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'"};
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final ArrayList windowsParseMacAddress(String ipConfigResponse) throws ParseException {
        ArrayList<String> macAddr = new ArrayList<String>(4);
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        int macCount = 0;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            int macAddressPosition = line.indexOf(":");
            if (macAddressPosition <= 0 || !NetworkInfo.windowsIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 1).trim())) continue;
            lastMacAddress = macAddressCandidate;
            macAddr.add(macAddressCandidate);
            if (++macCount <= 3) continue;
            break;
        }
        if (macCount > 0) {
            return macAddr;
        }
        ParseException ex = new ParseException("cannot read MAC address from [" + ipConfigResponse + "]", 0);
        throw ex;
    }

    private static final boolean windowsIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static ArrayList getMacAddresses() throws SocketException {
        String format = "%02X";
        ArrayList<String> macs = new ArrayList<String>();
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            byte[] mac1 = ni.getHardwareAddress();
            if (ni.isLoopback()) continue;
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            for (InetAddress address : Collections.list(addresses)) {
                byte[] mac;
                if (!(address instanceof Inet4Address) || (mac = ni.getHardwareAddress()) == null) continue;
                StringBuilder macAddress = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    macAddress.append(String.format("%s" + format, "", mac[i]));
                }
                macs.add(macAddress.toString());
            }
        }
        return macs;
    }

    private static final String windowsRunIpConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }
}

