/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.license;

import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.license.ActivationStatus;
import com.alachisoft.ncache.ncactivate.license.ByteRef;
import com.alachisoft.ncache.ncactivate.license.NCCrypto;
import com.alachisoft.ncache.ncactivate.license.NCFileUtil;
import com.alachisoft.ncache.ncactivate.license.NCMisc;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.util.RuntimeUtil;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class StubDll {
    private static final String winStub = RegUtil.winStub;
    private static final String linuxStub = RegUtil.linuxStub;

    public static int InitializeStub(long version, long flagReset, long updateActivation, ActivationStatus activationStatus) throws LicensingException {
        String[] systemFolder = null;
        RuntimeUtil.OS currentOS = RuntimeUtil.getCurrentOS();
        try {
            if (currentOS == RuntimeUtil.OS.Windows) {
                String sys32Folder = System.getenv("WINDIR") + "\\system32";
                systemFolder = new String[]{sys32Folder};
                for (int i = 0; i < systemFolder.length; ++i) {
                    systemFolder[i] = systemFolder[i] + "\\" + winStub;
                }
            } else {
                systemFolder = new String[]{"//usr//lib//" + linuxStub, "//usr//bin//" + linuxStub};
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ByteRef data = null;
        long dwSize = 0L;
        boolean fileExists = false;
        for (int i = 0; i < systemFolder.length && !fileExists; ++i) {
            fileExists = NCFileUtil.FileExists(systemFolder[i]);
            if (fileExists) {
                data = NCFileUtil.ReadFile(systemFolder[i]);
                dwSize = data.data.length;
            } else {
                try {
                    ResourceBundle rb1 = ResourceBundle.getBundle("com.alachisoft.ncache.licensing.DllData");
                    byte[] FirstHalf = (byte[])rb1.getObject("StubDll");
                    ResourceBundle rb2 = ResourceBundle.getBundle("com.alachisoft.ncache.licensing.DllData2");
                    byte[] SecondHalf = (byte[])rb2.getObject("StubDll");
                    dwSize = FirstHalf.length + SecondHalf.length;
                    data = new ByteRef((int)dwSize);
                    System.arraycopy(FirstHalf, 0, data.data, 0, FirstHalf.length);
                    System.arraycopy(SecondHalf, 0, data.data, FirstHalf.length, SecondHalf.length);
                }
                catch (MissingResourceException mre) {
                    mre.printStackTrace();
                }
            }
            if (data != null) continue;
            return -1;
        }
        int ret = -1;
        if (fileExists) {
            if (NCMisc.IsValidVersionMark(data.data, (int)version)) {
                String authCode = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode);
                if (authCode.length() != 0) {
                    flagReset = 1L;
                }
                if (flagReset == 0L) {
                    if (ret > 0) {
                        return 0;
                    }
                    return -1;
                }
            }
        } else {
            NCCrypto.Scramble(data, (int)(dwSize - (long)NCMisc.g_DataOffset), NCMisc.g_DataOffset);
        }
        if (updateActivation == 1L) {
            NCMisc.UpdateActivationStatus(data.data, dwSize, (int)version, activationStatus);
        } else {
            NCMisc.TimeStampData(data.data, dwSize, 0, 60, (int)version);
        }
        boolean result = false;
        try {
            for (int i = 0; i < systemFolder.length; ++i) {
                result = NCFileUtil.WriteFile(systemFolder[i], data.data, data.data.length);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        if (result) {
            return 0;
        }
        return -1;
    }

    public static int InitializeStub(long version, long extension, long period, long flagReset, long updateActivation, ActivationStatus activationStatus) throws LicensingException {
        String[] systemFolder = null;
        RuntimeUtil.OS operatingSystem = RuntimeUtil.getCurrentOS();
        try {
            if (operatingSystem == RuntimeUtil.OS.Windows) {
                String sys32Folder = System.getenv("WINDIR") + "\\system32\\" + winStub;
                systemFolder = new String[]{sys32Folder};
            } else {
                systemFolder = new String[]{"//usr//lib//" + linuxStub, "//usr//bin//" + linuxStub};
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ByteRef data = null;
        long dwSize = 0L;
        boolean fileExists = false;
        for (int i = 0; i < systemFolder.length && !fileExists; ++i) {
            fileExists = NCFileUtil.FileExists(systemFolder[i]);
            if (fileExists) {
                data = NCFileUtil.ReadFile(systemFolder[i]);
                dwSize = data.data.length;
            } else {
                try {
                    ResourceBundle rb1 = ResourceBundle.getBundle("com.alachisoft.ncache.licensing.DllData");
                    byte[] FirstHalf = (byte[])rb1.getObject("StubDll");
                    ResourceBundle rb2 = ResourceBundle.getBundle("com.alachisoft.ncache.licensing.DllData2");
                    byte[] SecondHalf = (byte[])rb2.getObject("StubDll");
                    dwSize = FirstHalf.length + SecondHalf.length;
                    data = new ByteRef((int)dwSize);
                    System.arraycopy(FirstHalf, 0, data.data, 0, FirstHalf.length);
                    System.arraycopy(SecondHalf, 0, data.data, FirstHalf.length, SecondHalf.length);
                }
                catch (MissingResourceException mre) {
                    mre.printStackTrace();
                }
            }
            if (data != null) continue;
            return -1;
        }
        int ret = -1;
        if (fileExists) {
            if (NCMisc.IsValidVersionMark(data.data, (int)version)) {
                String authCode = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode);
                if (authCode.length() != 0) {
                    flagReset = 1L;
                }
                if (flagReset == 0L) {
                    if (ret > 0) {
                        return 0;
                    }
                    return -1;
                }
            }
        } else {
            NCCrypto.Scramble(data, (int)(dwSize - (long)NCMisc.g_DataOffset), NCMisc.g_DataOffset);
        }
        if (updateActivation == 1L) {
            NCMisc.UpdateActivationStatus(data.data, dwSize, (int)version, activationStatus);
        } else {
            NCMisc.TimeStampData(data.data, dwSize, 0, 60, (int)version);
        }
        try {
            boolean result = true;
            for (int i = 0; i < systemFolder.length && result; ++i) {
                result = NCFileUtil.WriteFile(systemFolder[i], data.data, data.data.length);
            }
            if (result) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return -1;
        }
    }

    private static String[] getWinSystemDir(String delim, String prop) {
        StringTokenizer tokanizer = new StringTokenizer(prop);
        Vector<String> v = new Vector<String>();
        String token = "";
        while (tokanizer.hasMoreTokens()) {
            token = tokanizer.nextToken(";");
            if (token.indexOf(delim) == -1 || v.contains(token)) continue;
            v.add(token);
        }
        return v.toArray(new String[0]);
    }
}

