/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.nwizard;

import com.alachisoft.ncache.ncactivate.nwizard.NCWizard;
import com.alachisoft.ncache.ncactivate.nwizard.NCWizardModel;
import com.alachisoft.ncache.ncactivate.nwizard.NCWizardPanelDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class NCWizardController
implements ActionListener {
    private NCWizard wizard;

    public NCWizardController(NCWizard w) {
        this.wizard = w;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        } else if (evt.getActionCommand().equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (evt.getActionCommand().equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nextButtonPressed() {
        NCWizardModel model = this.wizard.getModel();
        NCWizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        Object nextPanelDescriptor = descriptor.getNextPanelDescriptor();
        if (nextPanelDescriptor instanceof NCWizardPanelDescriptor.FinishIdentifier) {
            if (!descriptor.aboutToExitPanel()) return;
            this.wizard.close(0);
            return;
        } else {
            this.wizard.setCurrentPanel(nextPanelDescriptor);
        }
    }

    private void backButtonPressed() {
        NCWizardModel model = this.wizard.getModel();
        NCWizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        Object backPanelDescriptor = descriptor.getBackPanelDescriptor();
        this.wizard.setCurrentPanel(backPanelDescriptor);
    }

    void resetButtonsToPanelRules() {
        NCWizardModel model = this.wizard.getModel();
        NCWizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        model.setCancelButtonText(NCWizard.CANCEL_TEXT);
        model.setBackButtonText(NCWizard.BACK_TEXT);
        if (descriptor.getBackPanelDescriptor() != null) {
            model.setBackButtonEnabled(Boolean.TRUE);
        } else {
            model.setBackButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() != null) {
            model.setNextFinishButtonEnabled(Boolean.TRUE);
        } else {
            model.setNextFinishButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() instanceof NCWizardPanelDescriptor.FinishIdentifier) {
            model.setNextFinishButtonText(NCWizard.FINISH_TEXT);
        } else {
            model.setNextFinishButtonText(NCWizard.NEXT_TEXT);
        }
    }
}

