/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.utils;

import com.alachisoft.ncache.ncactivate.appdata.MachineInfo;
import com.alachisoft.ncache.ncactivate.appdata.ProductInfo;
import com.alachisoft.ncache.ncactivate.appdata.UserInf;
import com.alachisoft.ncache.ncactivate.crypto.Crypto;
import java.util.Locale;

public class ActivationData {
    public ProductInfo Product = new ProductInfo();
    public UserInf User = new UserInf();
    public MachineInfo Machine = new MachineInfo();

    static String GetRegSection() {
        return "UserInfo";
    }

    public int Load() {
        if (this.Product.Load() < 0) {
            return -1;
        }
        if (this.Machine.Load() < 0) {
            return -1;
        }
        if (this.User.Load() < 0) {
            return -1;
        }
        return 0;
    }

    public void Save() {
        this.Machine.Save();
        this.Product.Save();
        this.User.Save();
    }

    public String ToXml() {
        String xml = new String();
        String.format(Locale.US, "<activation>%s%s%s</activation>", this.Product.ToXml(), this.User.ToXml(), this.Machine.ToXml());
        return xml;
    }

    public String ToLinearText() {
        String text = String.format(Locale.US, "%s\n%s\n%s\n%s", Crypto.Encode(this.Product.ToLinearText()), Crypto.Encode(this.User.ToLinearText()), Crypto.Encode(this.Machine.ToLinearText()), Crypto.Encode(" \t0\t "));
        return text;
    }
}

