/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.utils;

import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.appdata.MachineInfo;
import com.alachisoft.ncache.ncactivate.appdata.ProductInfo;
import com.alachisoft.ncache.ncactivate.appdata.UserInf;
import com.alachisoft.ncache.ncactivate.cmdline.exceptions.InvalidKeyException;
import com.alachisoft.ncache.ncactivate.crypto.Crypto;
import com.alachisoft.ncache.ncactivate.license.ActivationStatus;
import com.alachisoft.ncache.ncactivate.license.NCCpuInfo;
import com.alachisoft.ncache.ncactivate.license.StubDll;
import com.alachisoft.ncache.ncactivate.utils.ActivationData;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LocalVerificationFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;

public class AppUtil {
    public static boolean isCloudEdition;
    public static char[][] szKeyEvals;
    static eActivationType g_actType;
    static eDeActivationType g_deActType;
    static eLicenseType g_licType;
    static ActivationData info;
    private static int editionId;
    private static String version;
    private static boolean _isReactivation;

    public static ActivationData getActivationData() {
        return info;
    }

    public static ProductInfo getProductInfo() {
        return AppUtil.getActivationData().Product;
    }

    public static boolean GetReactivate() {
        return _isReactivation;
    }

    public static VerifyResult VerifAuthKey(String szAuthKey) throws LicensingException, LocalVerificationFailedException {
        eLicenseType licType;
        boolean curPos = false;
        String szAuthText = Crypto.Decode(szAuthKey);
        String mac1 = "";
        String mac2 = "";
        String mac3 = "";
        String mac4 = "";
        String[] tokens = szAuthText.split(":");
        int nTokens = tokens.length;
        String scheme = tokens[0].toLowerCase();
        String machineName = tokens[1].toLowerCase();
        String numCpus = tokens[2].toLowerCase();
        String physicalCpus = tokens[3].toLowerCase();
        String version = tokens[4].toLowerCase();
        String editionID = tokens[5].toLowerCase();
        String expiryDate = tokens[6].toLowerCase();
        String gracePeriod = tokens[7].toLowerCase();
        String activationID = tokens[8].toLowerCase();
        _isReactivation = NCCpuInfo.getPhysicalCoreCount() > Integer.parseInt(numCpus) && NCCpuInfo.getLicenseCount() > Integer.parseInt(physicalCpus);
        if (nTokens >= 10) {
            mac1 = tokens[9].toLowerCase();
        }
        if (nTokens >= 11) {
            mac2 = tokens[10].toLowerCase();
        }
        if (nTokens >= 12) {
            mac3 = tokens[11].toLowerCase();
        }
        if (nTokens >= 13) {
            mac4 = tokens[12].toLowerCase();
        }
        if (scheme == "") {
            return VerifyResult.ErrKey;
        }
        eLicenseType eLicenseType2 = licType = scheme.charAt(0) == 'c' ? eLicenseType.Production : eLicenseType.Developer;
        if (machineName.compareToIgnoreCase(EnvironmentUtil.getComputerName()) != 0) {
            return VerifyResult.ErrMac;
        }
        if (version.compareToIgnoreCase(AppUtil.getProductInfo().Version) != 0) {
            return VerifyResult.ErrVersion;
        }
        try {
            ArrayList adapters = EnvironmentUtil.GetAdaptersInfo();
            if (EnvironmentUtil.GetAdapter(adapters, mac1) != -1) {
                return VerifyResult.Success;
            }
            if (EnvironmentUtil.GetAdapter(adapters, mac2) != -1) {
                return VerifyResult.Success;
            }
            if (EnvironmentUtil.GetAdapter(adapters, mac3) != -1) {
                return VerifyResult.Success;
            }
            if (EnvironmentUtil.GetAdapter(adapters, mac4) != -1) {
                return VerifyResult.Success;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return VerifyResult.ErrMac;
    }

    public static String getActivationID(String szAuthKey) {
        try {
            if (szAuthKey == "") {
                return "";
            }
            if (AppUtil.VerifAuthKey(szAuthKey) != VerifyResult.Success) {
                return "";
            }
            String szAuthText = Crypto.Decode(szAuthKey);
            String[] tokens = szAuthText.split(":");
            if (tokens.length >= 9) {
                return tokens[8];
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static int getEditionIDFromServerValue(String installCodeFromServer) {
        String[] tokens;
        if (editionId == -1 && (tokens = (version = installCodeFromServer).split("-")) != null && tokens.length > 3) {
            String edition = tokens[1];
            if ((edition = edition.toLowerCase()).equals("cnto")) {
                editionId = 71;
            } else if (edition.equals("ento")) {
                editionId = 70;
            } else if (edition.equals("dev")) {
                editionId = 19;
            }
        }
        return editionId;
    }

    public static int getEditionID(String code) {
        String[] tokens;
        if (editionId == -1 && (tokens = (version = code == null ? AppUtil.getVersion() : AppUtil.getVersion(code)).split("-")) != null && tokens.length > 3) {
            String edition = tokens[1];
            if ((edition = edition.toLowerCase()).equals("cnto")) {
                editionId = 71;
            } else if (edition.equals("ento")) {
                editionId = 70;
            } else if (edition.equals("dev")) {
                editionId = 19;
            }
        }
        return editionId;
    }

    public static int getEditionID() {
        return AppUtil.getEditionID(null);
    }

    public static String getVersion() {
        if (version == null) {
            return AppUtil.getVersion(RegUtil.getInstallCode());
        }
        return version;
    }

    public static String getVersion(String installCode) {
        if (version == null) {
            try {
                try {
                    installCode = Crypto.Decode(installCode);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to decode the installcode found in license.properties file.");
                }
                if (installCode.contains(":")) {
                    version = installCode.substring(0, installCode.indexOf(":"));
                } else if (installCode.contains("JVC-EXP")) {
                    version = installCode;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version == null) {
            throw new RuntimeException("Unable to detect the product version.");
        }
        return version;
    }

    public eDeActivationType getDeActivationType() {
        return g_deActType;
    }

    public void setDeActivationType(eDeActivationType type) {
        g_deActType = type;
    }

    public eActivationType getAppActivationType() {
        return g_actType;
    }

    public void setAppActivationType(eActivationType type) {
        g_actType = type;
    }

    public eLicenseType getLicenseType() {
        return g_licType;
    }

    public void setLicenseType(eLicenseType type) {
        g_licType = type;
    }

    public UserInf getUserInfo() {
        return AppUtil.getActivationData().User;
    }

    public MachineInfo getMachineInfo() {
        return AppUtil.getActivationData().Machine;
    }

    public final boolean ValidateEvalKey(String key) throws InvalidKeyException {
        AppUtil appUtil = new AppUtil();
        if (key.length() != 17) {
            throw new InvalidKeyException("The specified key is not valid. Please supply a valid extension key.");
        }
        int matchPeriod = appUtil.getExtKeyIndex(key.toCharArray());
        if (matchPeriod < appUtil.getExtensionsUsed()) {
            throw new InvalidKeyException("The specified key is not valid. Please supply a valid extension key.");
        }
        Random rand = new Random();
        String period = String.format("%d:%d:xtension", matchPeriod + 1, rand.nextInt());
        RegUtil.setKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.ExtCode, (String)Crypto.Encode(period));
        System.out.println("NCache evaluation period has been extended.");
        RegUtil.StoreRegistry();
        return true;
    }

    public Properties loadResourceBundle(String bundleName) {
        Properties props = null;
        try {
            InputStream in = AppUtil.class.getClassLoader().getResourceAsStream(bundleName);
            props = new Properties();
            props.load(in);
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        return props;
    }

    public boolean isPerpetual(String szAuthKey) {
        if (szAuthKey == "") {
            return false;
        }
        String szAuthText = Crypto.Decode(szAuthKey);
        String[] tokens = szAuthText.split(":");
        return tokens.length >= 7 && tokens[6] == "null";
    }

    public String generateMachineInfoCode() {
        if (!AppUtil.getProductInfo().Reactivation) {
            AppUtil.getProductInfo().ActId = EnvironmentUtil.NewGUID();
        }
        String xml = AppUtil.getActivationData().ToLinearText();
        return Crypto.Encode(xml);
    }

    public int Activate(String szAuthKey) {
        RegUtil.setKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.DeactCode, (String)"");
        RegUtil.setKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode, (String)szAuthKey);
        AppUtil.getActivationData().Save();
        RegUtil.StoreRegistry();
        try {
            return StubDll.InitializeStub(this.getProductInfo().VersionId, 0L, 1L, ActivationStatus.Activated);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public int DeactKey(String szDeactKey) {
        RegUtil.setKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.DeactCode, (String)szDeactKey);
        RegUtil.setKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode, (String)"");
        RegUtil.StoreRegistry();
        return 0;
    }

    public void DeactStub() throws Exception {
        try {
            int result = StubDll.InitializeStub(this.getProductInfo().VersionId, 0L, 1L, ActivationStatus.Deactivated);
            if (result < 0) {
                throw new LicensingException();
            }
        }
        catch (Exception licensingException) {
            throw new Exception("Failed to Deactivate, Please make sure to execute with administrative rights.");
        }
    }

    public boolean isCloudEdition() {
        AppUtil.getEditionID();
        return isCloudEdition;
    }

    public int getExtensionsUsed() {
        int ext = -1;
        if (ext == -1) {
            String extCode = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.ExtCode);
            extCode = Crypto.Decode(extCode);
            ext = 0;
            if (extCode.length() > 3 && extCode.charAt(0) >= '0' && extCode.charAt(0) <= '9') {
                ext = extCode.charAt(0) - 48;
            }
        }
        return ext;
    }

    public int getMaxExtensions() {
        int arrLength = szKeyEvals.length;
        char[] key = szKeyEvals[0];
        int nKeylen = key.length;
        int nMaxExt = arrLength / nKeylen;
        return 4;
    }

    public int getExtKeyIndex(char[] szKey) {
        for (int i = 0; i < this.getMaxExtensions(); ++i) {
            if (!this.XorCmp(szKeyEvals[i], szKey)) continue;
            return i;
        }
        return -1;
    }

    public boolean XorCmp(char[] szUserKey, char[] szEmbededKey) {
        for (int i = 0; i < 17; ++i) {
            char ch = (char)(szUserKey[i] ^ 0x93);
            char vch = szEmbededKey[i];
            if (ch == vch) continue;
            return false;
        }
        return true;
    }

    static {
        szKeyEvals = new char[][]{{'\u00a6', '\u00a1', '\u00a7', '\u00c2', '\u00c7', '\u00c6', '\u00c0', '\u00df', '\u00ca', '\u00c3', '\u00cb', '\u00cb', '\u00d2', '\u00d0', '\u00ca', '\u00a6', '\u00dc'}, {'\u00d6', '\u00a0', '\u00ab', '\u00de', '\u00d7', '\u00d4', '\u00c9', '\u00d7', '\u00dc', '\u00da', '\u00cb', '\u00d0', '\u00ab', '\u00de', '\u00c5', '\u00a1', '\u00a1'}, {'\u00da', '\u00c4', '\u00a4', '\u00c9', '\u00d9', '\u00a5', '\u00cb', '\u00c7', '\u00d2', '\u00c4', '\u00c1', '\u00cb', '\u00a4', '\u00c6', '\u00d8', '\u00df', '\u00c0'}, {'\u00c3', '\u00c9', '\u00c9', '\u00df', '\u00a1', '\u00c0', '\u00d5', '\u00a1', '\u00d9', '\u00dc', '\u00a4', '\u00a0', '\u00c4', '\u00ca', '\u00ab', '\u00c2', '\u00cb'}};
        info = new ActivationData();
        editionId = -1;
        version = null;
        _isReactivation = false;
    }

    public static enum VerifyResult {
        Success,
        ErrLicScheme,
        ErrNumCpu,
        ErrMac,
        ErrVersion,
        ErrKey,
        ErrPhysicalCpus;

    }

    public static enum eLicenseType {
        Production,
        Developer;

    }

    public static enum eDeActivationType {
        Online,
        Email,
        Manual;

    }

    public static enum eActivationType {
        Online,
        Email,
        Manual;

    }
}

