/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Caching;

import Alachisoft.NCache.Common.Caching.LargeUserBinaryObject;
import Alachisoft.NCache.Common.Caching.SmallUserBinaryObject;
import Alachisoft.NCache.Common.DataStructures.IStreamItem;
import Alachisoft.NCache.Common.ISizable;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public abstract class UserBinaryObject
implements IStreamItem,
ISizable,
Serializable,
ICompactSerializable {
    public static final int LARGE_OBJECT_SIZE = 80896;
    public static final int BYTE_ARRAY_MEMORY_OVERHEAD = 24;
    private int noOfChunks;
    private int index;
    private List<byte[]> data;

    public static UserBinaryObject createUserBinaryObject(Collection data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        UserBinaryObject binaryObject = null;
        binaryObject = data.size() > 1 ? new LargeUserBinaryObject() : new SmallUserBinaryObject();
        if (binaryObject != null) {
            binaryObject.initializeUserBinaryObject(data);
        }
        return binaryObject;
    }

    public abstract void updateActualDataLength();

    public static UserBinaryObject createUserBinaryObject(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        float noOfChunks = (float)byteArray.length / 80896.0f;
        UserBinaryObject binaryObject = null;
        binaryObject = noOfChunks > 1.0f ? new LargeUserBinaryObject() : new SmallUserBinaryObject();
        if (binaryObject != null) {
            binaryObject.initializeUserBinaryObject(byteArray);
        }
        return binaryObject;
    }

    public abstract void initializeUserBinaryObject(Collection var1);

    public abstract void initializeUserBinaryObject(byte[] var1);

    public Object[] getData() {
        return this.getDataList().toArray();
    }

    public abstract List<byte[]> getDataList();

    public abstract byte[] getFullObject();

    public abstract byte[] getTwoDimensionalArray();

    @Override
    public int getSize() {
        return this.getLength();
    }

    public abstract Object[] ClonePayload();

    public abstract UserBinaryObject DeepClone();

    @Override
    public void setLength(int value) {
    }

    public abstract void deserialize(NCacheObjectInput var1) throws IOException, ClassNotFoundException;

    public abstract void serialize(NCacheObjectOutput var1) throws IOException;
}

