/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Communication;

import Alachisoft.NCache.Common.Communication.Exceptions.ChannelException;
import Alachisoft.NCache.Common.Communication.IChannel;
import Alachisoft.NCache.Common.Communication.IChannelEventListener;
import Alachisoft.NCache.Common.Communication.IRequest;
import Alachisoft.NCache.Common.Communication.IResponse;
import Alachisoft.NCache.Common.Communication.RequestResponsePair;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Threading.Monitor;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class RequestManager
implements IChannelEventListener,
IDisposable {
    private IChannel _channel;
    private HashMap _requests = new HashMap();
    private Object _lock = new Object();
    private long _lastRequestId;
    private boolean _resendRequestOnChannelDisconnect = true;
    private int _requestTimeout = 90000;

    public RequestManager(IChannel chnnel) {
        if (chnnel == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: channel");
        }
        this._channel = chnnel;
        this._channel.RegisterEventListener(this);
    }

    public final int getRequestTimedout() {
        return this._requestTimeout;
    }

    public final void setRequestTimedout(int value) {
        this._requestTimeout = value;
    }

    public final boolean getIsConnected() {
        return this._channel != null ? this._channel.getIsConnected() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object SendRequest(IRequest request) throws TimeoutException, UnsupportedEncodingException, InterruptedException {
        Object response = null;
        request.setRequestId(this.GenerateRequestId());
        RequestResponsePair reqRespPair = new RequestResponsePair();
        Object object = this._lock;
        synchronized (object) {
            reqRespPair.setRequest(request);
            if (!this._requests.containsKey(request.getRequestId())) {
                this._requests.put(request.getRequestId(), reqRespPair);
            }
        }
        object = reqRespPair;
        synchronized (object) {
            try {
                if (this._channel != null) {
                    this._channel.SendMessage(request);
                }
                reqRespPair.setRequestSentOverChannel(true);
                Monitor.wait(reqRespPair, this._requestTimeout);
            }
            catch (ChannelException e) {
                throw e;
            }
            finally {
                Object object2 = this._lock;
                synchronized (object2) {
                    this._requests.remove(request.getRequestId());
                }
            }
        }
        if (!reqRespPair.getLockAccquired()) {
            throw new TimeoutException();
        }
        reqRespPair.setLockAccquired(false);
        if (reqRespPair.getChannelException() != null) {
            throw reqRespPair.getChannelException();
        }
        response = reqRespPair.getResponse();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long GenerateRequestId() {
        RequestManager requestManager = this;
        synchronized (requestManager) {
            long requestId = ++this._lastRequestId;
            if (requestId < 0L) {
                this._lastRequestId = 0L;
                requestId = 0L;
            }
            return requestId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ReceiveResponse(IResponse response) {
        RequestResponsePair reqResponsePair;
        IResponse protoResponse = response;
        RequestResponsePair requestResponsePair = reqResponsePair = (RequestResponsePair)(this._requests.get(protoResponse.getRequestId()) instanceof RequestResponsePair ? this._requests.get(protoResponse.getRequestId()) : null);
        synchronized (requestResponsePair) {
            if (reqResponsePair != null) {
                reqResponsePair.setResponse(protoResponse);
                reqResponsePair.setLockAccquired(true);
                Monitor.pulse(reqResponsePair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ChannelDisconnected(String reason) throws UnsupportedEncodingException {
        Object object = this._lock;
        synchronized (object) {
            Object tempVar = this._requests.clone();
            HashMap requestClone = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
            for (Map.Entry current : requestClone.entrySet()) {
                RequestResponsePair reqRspPair = current.getValue() instanceof RequestResponsePair ? current.getValue() : null;
                if (!reqRspPair.getRequestSentOverChannel()) continue;
                RequestResponsePair requestResponsePair = reqRspPair;
                synchronized (requestResponsePair) {
                    if (this._resendRequestOnChannelDisconnect) {
                        try {
                            if (this._channel != null) {
                                this._channel.SendMessage(reqRspPair.getRequest());
                            }
                        }
                        catch (ChannelException ce) {
                            reqRspPair.setChannelException(ce);
                            Monitor.pulse(reqRspPair);
                        }
                    } else {
                        reqRspPair.setChannelException(new ChannelException(reason));
                        Monitor.pulse(reqRspPair);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        try {
            Object object = this._lock;
            synchronized (object) {
                this._requests.clear();
            }
            if (this._channel != null) {
                this._channel.Disconnect();
                this._channel = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

