/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Communication;

import Alachisoft.NCache.Common.Communication.Exceptions.ConnectionException;
import Alachisoft.NCache.Common.Communication.IConnection;
import com.alachisoft.ncache.serialization.standard.io.ObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class TcpConnection
implements IConnection {
    private Socket _socket;
    private boolean _connected;
    private Object _sync_lock = new Object();
    private InetAddress _bindIP;
    private ObjectInputStream in = null;

    @Override
    public final boolean Connect(String serverIP, int port) throws UnknownHostException, IOException {
        boolean connected = false;
        try {
            InetSocketAddress sockaddr = new InetSocketAddress(serverIP, port);
            Socket socket = new Socket();
            if (this._bindIP != null) {
                socket.bind(sockaddr);
            }
            socket.connect(sockaddr);
            connected = socket.isConnected();
            this._socket = socket;
        }
        catch (Exception e) {
            throw new ConnectionException("[" + serverIP + "] " + e.getMessage());
        }
        this._connected = connected;
        return connected;
    }

    @Override
    public final void Disconnect() {
        try {
            if (this._connected && this._socket != null && this._socket.isConnected()) {
                this._socket.shutdownOutput();
                this._socket.shutdownInput();
                this._socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean Send(byte[] buffer, int offset, int count) throws ConnectionException {
        boolean sent = false;
        Object object = this._sync_lock;
        synchronized (object) {
            if (this._connected) {
                int dataSent = 0;
                while (count > 0) {
                    try {
                        ObjectOutputStream os = new ObjectOutputStream(this._socket.getOutputStream(), "");
                        os.write(buffer, offset, count);
                        os.flush();
                        dataSent = count;
                        offset += dataSent;
                        count -= dataSent;
                    }
                    catch (IOException se) {
                        this._connected = false;
                        throw new ConnectionException(se.getMessage(), se);
                    }
                }
            } else {
                throw new ConnectionException();
            }
            sent = true;
        }
        return sent;
    }

    @Override
    public final boolean Receive(byte[] buffer, int count) throws ConnectionException {
        boolean received = false;
        if (this._connected) {
            int receivedCount = 0;
            int offset = 0;
            while (count > 0) {
                try {
                    receivedCount = this._socket.getInputStream().read(buffer, offset, count);
                    offset += receivedCount;
                    count -= receivedCount;
                }
                catch (IOException se) {
                    this._connected = false;
                    throw new ConnectionException(se.getMessage(), se);
                }
            }
        } else {
            throw new ConnectionException();
        }
        received = true;
        return received;
    }

    @Override
    public final boolean getIsConnected() {
        if (this._connected) {
            this._connected = this._socket.isConnected();
        }
        return this._connected;
    }

    @Override
    public final void Bind(String address) throws UnknownHostException {
        if (address == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: address");
        }
        this._bindIP = InetAddress.getByName(address);
    }
}

