/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataReader;

import Alachisoft.NCache.Common.DataReader.RecordColumn;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ColumnCollection
implements InternalCompactSerializable,
Iterable {
    private Map _columns = new HashMap();
    private Map _nameToIndex = new HashMap();

    public final int getCount() {
        return this._columns.size();
    }

    public final int getHiddenColumnCount() {
        int hiddenColumns = 0;
        for (Map.Entry entry : this._columns.entrySet()) {
            Map.Entry columnsEntry = entry;
            if (!((RecordColumn)columnsEntry.getValue()).getIsHidden()) continue;
            ++hiddenColumns;
        }
        return hiddenColumns;
    }

    public final void add(RecordColumn column) {
        if (this._nameToIndex.get(column.getColumnName()) != null) {
            throw new RuntimeException("Invalid query. Same column cannot be selected twice.");
        }
        this._nameToIndex.put(column.getColumnName(), this._columns.size());
        this._columns.put(this._columns.size(), column);
    }

    public final RecordColumn get(String columnName) {
        return (RecordColumn)this._columns.get(this._nameToIndex.get(columnName));
    }

    public final RecordColumn get(int index) {
        return (RecordColumn)this._columns.get(index);
    }

    public final int getColumnIndex(String columnName) {
        return (Integer)this._nameToIndex.get(columnName);
    }

    public final String getColumnName(int index) {
        return ((RecordColumn)this._columns.get(index)).getColumnName();
    }

    public final boolean contains(String columnName) {
        return this._nameToIndex.get(columnName) != null;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._columns = new HashMap();
        int columnCount = reader.ReadInt32();
        for (int i = 0; i < columnCount; ++i) {
            Object tempVar = reader.ReadObject();
            this._columns.put(reader.ReadInt32(), tempVar instanceof RecordColumn ? (RecordColumn)tempVar : null);
        }
        this._nameToIndex = new HashMap();
        int indexCount = reader.ReadInt32();
        for (int i = 0; i < indexCount; ++i) {
            Object tempVar2 = reader.ReadObject();
            this._nameToIndex.put(tempVar2 instanceof String ? (String)tempVar2 : null, reader.ReadInt32());
        }
    }

    public void Serialize(CompactWriter writer) throws IOException {
        Map.Entry result;
        Map.Entry kv;
        writer.Write(this._columns.size());
        Iterator iterator = this._columns.entrySet().iterator();
        while (iterator.hasNext()) {
            result = kv = iterator.next();
            writer.Write(((Integer)result.getKey()).intValue());
            writer.WriteObject(result.getValue());
        }
        writer.Write(this._nameToIndex.size());
        iterator = this._nameToIndex.entrySet().iterator();
        while (iterator.hasNext()) {
            result = kv = iterator.next();
            writer.WriteObject(result.getKey());
            writer.Write(((Integer)result.getValue()).intValue());
        }
    }

    public Iterator iterator() {
        return this._columns.entrySet().iterator();
    }
}

