/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.BridgeOpCodes;
import Alachisoft.NCache.Common.DataStructures.IOptimizedQueueOperation;
import Alachisoft.NCache.Common.Stats.HPTime;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class BridgeOperation
implements ICompactSerializable,
IOptimizedQueueOperation {
    Object _queueCacheKey;
    private BridgeOpCodes _opCode = BridgeOpCodes.values()[0];
    private Object _key;
    private Object _data;
    private byte _flags;
    private int _size = 10;
    private boolean _stateTxferOperation;
    private boolean _doWriteBehind;
    private byte _redoCount;
    private HPTime _bridgeOpTimeStamp;

    public BridgeOperation() {
    }

    public BridgeOperation(BridgeOpCodes opCode, HPTime bridgeOpTimeStamp) {
        this(opCode, null, null, bridgeOpTimeStamp);
    }

    public BridgeOperation(BridgeOpCodes opCode, String key, HPTime bridgeOpTimeStamp) {
        this(opCode, key, null, 0, bridgeOpTimeStamp);
    }

    public BridgeOperation(BridgeOpCodes opCode, String key, boolean doWriteBehind, HPTime bridgeOpTimeStamp) {
        this(opCode, key, null, 0, bridgeOpTimeStamp);
        this._doWriteBehind = doWriteBehind;
    }

    public BridgeOperation(BridgeOpCodes opCode, String key, Object data, HPTime bridgeOpTimeStamp) {
        this(opCode, key, data, 0, 10, bridgeOpTimeStamp);
    }

    public BridgeOperation(BridgeOpCodes opCode, String key, Object data, int size, HPTime bridgeOpTimeStamp) {
        this(opCode, key, data, 0, size, bridgeOpTimeStamp);
    }

    public BridgeOperation(BridgeOpCodes opCode, String key, Object data, byte flag, int size, HPTime bridgeOpTimeStamp) {
        this._opCode = opCode;
        this._key = key;
        this._data = data;
        this._flags = flag;
        this._size = size;
        this._bridgeOpTimeStamp = bridgeOpTimeStamp;
    }

    public final BridgeOpCodes getOpCode() {
        return this._opCode;
    }

    public final void setOpCode(BridgeOpCodes value) {
        this._opCode = value;
    }

    public Object getQueueCacheKey() {
        return this._queueCacheKey;
    }

    public void setQueueCacheKey(Object _queueCacheKey) {
        this._queueCacheKey = _queueCacheKey;
    }

    public final Object getKey() {
        return this._key;
    }

    public final void setKey(Object value) {
        this._key = value;
    }

    @Override
    public final Object getData() {
        return this._data;
    }

    @Override
    public final void setData(Object value) {
        this._data = value;
    }

    public final byte getRedoCount() {
        return this._redoCount;
    }

    public final void setRedoCount(byte value) {
        this._redoCount = value;
    }

    public final boolean getIsStateTransferOperation() {
        return this._stateTxferOperation;
    }

    public final void setIsStateTransferOperation(boolean value) {
        this._stateTxferOperation = value;
    }

    public final byte getFlags() {
        return this._flags;
    }

    public final void setFlags(byte value) {
        this._flags = value;
    }

    @Override
    public final int getSize() {
        return this._size;
    }

    @Override
    public final void setSize(int value) {
        this._size = value;
    }

    public final boolean getDoWriteBehind() {
        return this._doWriteBehind;
    }

    public final void setDoWriteBehind(boolean value) {
        this._doWriteBehind = value;
    }

    @Override
    public final Object[] getUserPayLoad() {
        return null;
    }

    @Override
    public final void setUserPayLoad(Object[] value) {
    }

    @Override
    public final long getPayLoadSize() {
        return 0L;
    }

    @Override
    public final void setPayLoadSize(long value) {
    }

    public final HPTime getBridgeOpTimeStamp() {
        return this._bridgeOpTimeStamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("key = " + this.getKey().toString() + ",");
        sb.append("operation = " + this.getOpCode().name());
        return sb.toString();
    }

    public final void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._opCode = BridgeOpCodes.forValue(reader.ReadByte());
        this._key = reader.ReadObject();
        this._flags = reader.ReadByte();
        this._data = reader.ReadObject();
        this._size = reader.ReadInt32();
        this._stateTxferOperation = reader.ReadBoolean();
        this._doWriteBehind = reader.ReadBoolean();
        this._redoCount = reader.ReadByte();
        this._bridgeOpTimeStamp = (HPTime)reader.ReadObject();
        this._queueCacheKey = reader.ReadObject();
    }

    public final void Serialize(CompactWriter writer) throws IOException, ClassNotFoundException {
        writer.Write((byte)this._opCode.getValue());
        writer.WriteObject(this._key);
        writer.Write(this._flags);
        writer.WriteObject(this._data);
        writer.Write(this._size);
        writer.Write(this._stateTxferOperation);
        writer.Write(this._doWriteBehind);
        writer.Write(this._redoCount);
        writer.WriteObject((Object)this._bridgeOpTimeStamp);
        writer.WriteObject(this._queueCacheKey);
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeByte(this._opCode.getValue());
        writer.writeObject(this._key);
        writer.writeByte((int)this._flags);
        writer.writeObject(this._data);
        writer.writeInt(this._size);
        writer.writeBoolean(this._stateTxferOperation);
        writer.writeBoolean(this._doWriteBehind);
        writer.writeByte((int)this._redoCount);
        writer.writeObject((Object)this._bridgeOpTimeStamp);
        writer.writeObject(this._queueCacheKey);
        writer.flush();
    }

    public void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        this._opCode = BridgeOpCodes.forValue(reader.readByte());
        this._key = reader.readObject();
        this._flags = reader.readByte();
        this._data = reader.readObject();
        this._size = reader.readInt();
        this._stateTxferOperation = reader.readBoolean();
        this._doWriteBehind = reader.readBoolean();
        this._redoCount = reader.readByte();
        this._bridgeOpTimeStamp = (HPTime)reader.readObject();
        this._queueCacheKey = reader.readObject();
    }
}

