/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Util.HashtableUtil;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class NewHashmap
implements ICompactSerializable {
    private long _lastViewId;
    private HashMap _map;
    private ArrayList<String> _members;
    private byte[] _buffer;
    private boolean _updateMap = false;
    private boolean _forcefulUpdate = false;

    public NewHashmap() {
    }

    public NewHashmap(long lastViewid, HashMap map, ArrayList<Address> members) {
        this._lastViewId = lastViewid;
        this._map = map;
        this._members = new ArrayList(members.size());
        for (Address address : members) {
            this._members.add(address.getIpAddress().getHostAddress());
        }
    }

    public NewHashmap(long viewId, HashMap<Integer, String> newMap, List<String> membersList, int bucketSize, boolean b) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Serialize(NewHashmap instance, String serializationContext, boolean updateClientMap) {
        HashMap<String, Serializable> mapInfo = null;
        if (instance != null) {
            mapInfo = new HashMap<String, Serializable>();
            mapInfo.put("ViewId", Long.valueOf(instance._lastViewId));
            mapInfo.put("Members", instance._members);
            mapInfo.put("Map", instance._map);
            mapInfo.put("UpdateMap", Boolean.valueOf(updateClientMap));
            mapInfo.put("ForcefulUpdate", Boolean.valueOf(instance._forcefulUpdate));
            ObjectOutputStream objectOutPutStream = null;
            try {
                ByteArrayOutputStream byteArrayOutPutStream = new ByteArrayOutputStream();
                objectOutPutStream = new ObjectOutputStream(byteArrayOutPutStream);
                objectOutPutStream.writeObject(mapInfo);
                instance._buffer = byteArrayOutPutStream.toByteArray();
                objectOutPutStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                if (objectOutPutStream != null) {
                    try {
                        objectOutPutStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NewHashmap Deserialize(byte[] buffer, String serializationContext) {
        NewHashmap hashmap = null;
        if (buffer != null && buffer.length > 0) {
            Object tempVar = null;
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream(buffer));
                tempVar = objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (ClassNotFoundException cls) {
                System.out.println("" + cls);
            }
            catch (IOException e) {
                System.out.println("" + e);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException cls) {}
                }
            }
            HashMap map = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
            if (map != null) {
                hashmap = new NewHashmap();
                hashmap._lastViewId = (Long)map.get("ViewId");
                hashmap._members = (ArrayList)map.get("Members");
                hashmap._map = (HashMap)map.get("Map");
                hashmap._updateMap = map.get("UpdateMap") != null ? (Boolean)map.get("UpdateMap") : false;
                hashmap._forcefulUpdate = map.get("ForcefulUpdate") != null ? (Boolean)map.get("ForcefulUpdate") : false;
            }
        }
        return hashmap;
    }

    public static NewHashmap DeserializeString(byte[] buffer, String serializationContext) {
        String strValue = new String(buffer, 0, buffer.length, Charset.forName("UTF-8"));
        String[] strParts = strValue.split("\t");
        NewHashmap hashmap = new NewHashmap();
        hashmap._map = HashtableUtil.FromString(strParts[0]);
        hashmap._members = new ArrayList<String>(Arrays.asList(strParts[1].split("\r\n")));
        hashmap._lastViewId = Long.parseLong(strParts[2]);
        hashmap._updateMap = Boolean.getBoolean(strParts[3]);
        return hashmap;
    }

    public boolean isForcefulUpdate() {
        return this._forcefulUpdate;
    }

    public long getLastViewId() {
        return this._lastViewId;
    }

    public HashMap getMap() {
        return this._map;
    }

    public boolean getUpdateMap() {
        return this._updateMap;
    }

    public void setUpdateMap(boolean value) {
        this._updateMap = value;
    }

    public ArrayList getMembers() {
        return this._members;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ (");
        builder.append(this._lastViewId);
        builder.append(") ");
        builder.append("[");
        for (int i = 0; i < this.getMembers().size(); ++i) {
            builder.append(this.getMembers().get(i));
            if (i >= this.getMembers().size() - 1) continue;
            builder.append(",");
        }
        builder.append("] }");
        return builder.toString();
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeLong(this._lastViewId);
        writer.writeObject(this._members);
        writer.writeObject((Object)this._map);
        writer.writeBoolean(this._updateMap);
        writer.writeBoolean(this._forcefulUpdate);
    }

    public void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        this._lastViewId = reader.readLong();
        this._members = (ArrayList)reader.readObject();
        this._map = (HashMap)reader.readObject();
        this._updateMap = reader.readBoolean();
        this._forcefulUpdate = reader.readBoolean();
    }
}

