/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.SearchAlgorithms.BinarySearch;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SortedMap<K, V>
implements Map<K, V> {
    Comparator<K> comp;
    private LinkedList<K> _linkList = new LinkedList();
    private HashMap<K, List<V>> _hashMap;

    public SortedMap(Comparator<K> comp) {
        this.comp = comp;
        this._hashMap = new HashMap();
    }

    @Override
    public int size() {
        return this._linkList.size();
    }

    @Override
    public boolean isEmpty() {
        return this._linkList.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this._hashMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this._hashMap.containsValue(o);
    }

    @Override
    @Deprecated
    public V get(Object o) {
        throw new UnsupportedOperationException();
    }

    public List<V> getValue(Object o) {
        return this._hashMap.get(o);
    }

    @Override
    @Deprecated
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    public List<V> putValue(K k, V v) {
        List<Object> valueList = new ArrayList<V>();
        this.sortKey(k);
        if (this._hashMap.containsKey(k)) {
            valueList = this._hashMap.get(k);
            valueList.add(v);
            return this._hashMap.put(k, valueList);
        }
        valueList.add(v);
        return this._hashMap.put(k, valueList);
    }

    @Override
    @Deprecated
    public V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public List<V> removeVal(Object o) {
        this._linkList.remove(o);
        return this._hashMap.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> pair : map.entrySet()) {
            this.putValue(pair.getKey(), pair.getValue());
        }
    }

    @Override
    public void clear() {
        this._linkList.clear();
        this._hashMap.clear();
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet<K> link = new LinkedHashSet<K>(this._linkList);
        return link;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> arr = new ArrayList<V>();
        for (int i = 0; i < this._linkList.size(); ++i) {
            if (this._hashMap.get(this._linkList.get(i)) == null) continue;
            List<V> intList = this._hashMap.get(this._linkList.get(i));
            for (int j = 0; j < intList.size(); ++j) {
                arr.add(intList.get(j));
            }
        }
        return arr;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> link = new LinkedHashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this._linkList.size(); ++i) {
            AbstractMap.SimpleEntry<K, List<V>> simple = new AbstractMap.SimpleEntry<K, List<V>>(this._linkList.get(i), this._hashMap.get(this._linkList.get(i)));
            link.add(simple);
        }
        return link;
    }

    private void sortKey(Object o) {
        BinarySearch.insertItem(this._linkList, o, this.comp);
    }

    public V getByIndex(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int currentIndex = 0;
        V value = null;
        ArrayList tempList = new ArrayList();
        for (Object tmpValue : this._linkList) {
            if (tempList.contains(tmpValue)) continue;
            tempList.add(tmpValue);
        }
        Iterator ie = tempList.iterator();
        while (ie.hasNext()) {
            List<V> list = this._hashMap.get(ie.next());
            if (list != null && list.size() > 1) {
                for (int j = 0; j < list.size(); ++j) {
                    value = list.get(j);
                    if (currentIndex == index) {
                        return value;
                    }
                    ++currentIndex;
                }
                continue;
            }
            if (list != null && list.size() == 1) {
                value = list.get(0);
            }
            if (currentIndex == index) {
                return value;
            }
            ++currentIndex;
        }
        return null;
    }
}

