/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.VirtualIndex;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VirtualArray
implements ICompactSerializable {
    private static final int maxSize = 80896;
    private List _baseArray;
    private long _size;

    @Deprecated
    public VirtualArray() {
    }

    public VirtualArray(int size) {
        this._size = size;
        int largeObjectSize = 80896;
        int noOfChunks = size / largeObjectSize;
        this._baseArray = new ArrayList(noOfChunks += size - noOfChunks * largeObjectSize != 0 ? 1 : 0);
        for (int i = 0; i < noOfChunks; ++i) {
            byte[] buffer = null;
            if (size >= 80896) {
                buffer = new byte[80896];
                size -= 80896;
            } else {
                buffer = new byte[size];
            }
            this._baseArray.add(i, buffer);
        }
    }

    public VirtualArray(List array) {
        this._baseArray = array;
        for (int i = 0; i < array.size(); ++i) {
            byte[] tmp = array.get(i) instanceof byte[] ? array.get(i) : null;
            if (tmp == null) continue;
            this._size += (long)tmp.length;
        }
    }

    public static void CopyData(VirtualArray src, VirtualIndex srcIndex, VirtualArray dst, VirtualIndex dstIndex, int count) {
        VirtualArray.CopyData(src, srcIndex, dst, dstIndex, count, false);
    }

    public static void CopyData(VirtualArray src, VirtualIndex srcIndex, VirtualArray dst, VirtualIndex dstIndex, int count, boolean allowExpantion) {
        if (src == null || dst == null || srcIndex == null || dstIndex == null) {
            return;
        }
        if (src.getSize() < (long)srcIndex.getIndexValue()) {
            throw new IndexOutOfBoundsException();
        }
        srcIndex = srcIndex.clone();
        dstIndex = dstIndex.clone();
        while (count > 0) {
            int accomdateble;
            byte[] arr = src._baseArray.get(srcIndex.getYIndex()).getClass().isArray() ? (byte[])src._baseArray.get(srcIndex.getYIndex()) : null;
            int copyCount = 80896 - srcIndex.getXIndex();
            if (copyCount > count) {
                copyCount = count;
            }
            byte[] dstArr = null;
            if (dst._baseArray.size() > dstIndex.getYIndex()) {
                byte[] byArray = dstArr = dst._baseArray.get(dstIndex.getYIndex()).getClass().isArray() ? (byte[])dst._baseArray.get(dstIndex.getYIndex()) : null;
            }
            if ((accomdateble = 80896 - dstIndex.getXIndex()) > copyCount) {
                accomdateble = copyCount;
            }
            if ((dstArr == null || accomdateble > dstArr.length - dstIndex.getXIndex()) && allowExpantion) {
                if (dstArr == null) {
                    dstArr = new byte[accomdateble];
                    dst._baseArray.add(dstArr);
                } else {
                    byte[] tmpArray = new byte[accomdateble + dstArr.length - (dstArr.length - dstIndex.getXIndex())];
                    System.arraycopy(dstArr, 0, tmpArray, 0, dstArr.length);
                    dstArr = tmpArray;
                    dst._baseArray.set(dstIndex.getYIndex(), dstArr);
                }
            }
            System.arraycopy(arr, srcIndex.getXIndex(), dstArr, dstIndex.getXIndex(), accomdateble);
            count -= accomdateble;
            srcIndex.IncrementBy(accomdateble);
            dstIndex.IncrementBy(accomdateble);
        }
    }

    public final byte GetValueAt(VirtualIndex vIndex) {
        byte[] arr = this._baseArray.get(vIndex.getYIndex()) instanceof byte[] ? this._baseArray.get(vIndex.getYIndex()) : null;
        return arr[vIndex.getXIndex()];
    }

    public final void SetValueAt(VirtualIndex vIndex, byte value) {
        byte[] arr = this._baseArray.get(vIndex.getYIndex()) instanceof byte[] ? this._baseArray.get(vIndex.getYIndex()) : null;
        arr[vIndex.getXIndex()] = value;
    }

    public final int CopyData(byte[] buffer, int offset, int length) {
        int dataToCopy;
        if (offset + length > buffer.length) {
            throw new IllegalArgumentException("Length plus offset is greater than buffer size");
        }
        int dataCopied = dataToCopy = (int)((long)length >= this.getSize() ? this.getSize() : (long)length);
        int i = 0;
        while (dataToCopy > 0) {
            byte[] binarChunk = (byte[])this._baseArray.get(i);
            if (binarChunk != null) {
                int copyCount = Math.min(binarChunk.length, dataToCopy);
                System.arraycopy(binarChunk, 0, buffer, offset, copyCount);
                offset += copyCount;
                dataToCopy -= copyCount;
            }
            ++i;
        }
        return dataCopied;
    }

    public final List getBaseArray() {
        return this._baseArray;
    }

    public final long getSize() {
        return this._size;
    }

    public final void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        this._size = reader.readLong();
        Object tempVar = reader.readObject();
        this._baseArray = (List)(tempVar instanceof List ? tempVar : null);
    }

    public final void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeLong(this._size);
        writer.writeObject((Object)this._baseArray);
    }
}

