/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataTypes.Counter;

import Alachisoft.NCache.Common.DataTypes.Counter.CounterOperationBase;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.HashMap;

public class CounterOperation
extends CounterOperationBase {
    private long _value;
    private OpType _operationType = OpType.values()[0];

    public CounterOperation(String name, String lockId, TimeSpan lockTimeout) {
        super(name, DistributedDataStructure.Counter, lockId, lockTimeout);
    }

    public final long getValue() {
        return this._value;
    }

    public final void setValue(long value) {
        this._value = value;
    }

    public final OpType getOperationType() {
        return this._operationType;
    }

    public final void setOperationType(OpType value) {
        this._operationType = value;
    }

    public static enum OpType {
        IncrementBy(1),
        DecrementBy(2),
        SetValue(3);

        private static HashMap<Integer, OpType> mappings;
        private int intValue;

        private OpType(int value) {
            this.intValue = value;
            OpType.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Integer, OpType> getMappings() {
            if (mappings != null) return mappings;
            Class<OpType> clazz = OpType.class;
            synchronized (OpType.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static OpType forValue(int value) {
            return OpType.getMappings().get(value);
        }

        public int getValue() {
            return this.intValue;
        }
    }
}

