/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Extensibility.Client;

import Alachisoft.NCache.Common.Extensibility.Client.IClientSurrogateObject;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IMethodArgumentPartitioner;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCCallBuilder;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCConstructorCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCMethodCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCPropertyCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCTransport;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IResponseConsolidator;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Impl.BroadcastingMethodArgumentPartitioner;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Impl.MultiPartitionMethodCall;
import Alachisoft.NCache.Common.Extensibility.SurrogateObjectBase;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;

public class ClientSurrogateObject<TTarget>
extends SurrogateObjectBase
implements IClientSurrogateObject {
    private final TypeToken<TTarget> typeToken = new TypeToken<TTarget>(this.getClass()){};
    private final Type type = this.typeToken.getType();
    protected IRPCCallBuilder _callBuilder;
    protected IRPCTransport _transport;
    protected String _objectUID;
    protected Object[] _constructorParams;
    private IMethodArgumentPartitioner _methodArgumentPartitioner = BroadcastingMethodArgumentPartitioner.getInstance();

    public ClientSurrogateObject(IRPCCallBuilder rpcCallBuilder, IRPCTransport transport, Object[] arguements, String objectUID) {
        super(objectUID);
        this.Initialize(rpcCallBuilder, transport, arguements, objectUID);
    }

    public ClientSurrogateObject(IRPCCallBuilder rpcCallBuilder, IRPCTransport transport, Object[] arguements) {
        this.Initialize(rpcCallBuilder, transport, arguements, super.getObjectUID());
    }

    public Type getType() {
        return this.type;
    }

    private void Initialize(IRPCCallBuilder rpcCallBuilder, IRPCTransport transport, Object[] arguments, String objectUID) {
        this._objectUID = objectUID;
        this._callBuilder = rpcCallBuilder;
        this._transport = transport;
        this._constructorParams = arguments;
    }

    public final void CreateInstance() {
        try {
            this.InitializeInstance(this._constructorParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final <TResult> TResult InvokeMethod(String method, int overload, Object[] arguments, boolean isStatic, IMethodArgumentPartitioner methodAgrumentPartitioner, IResponseConsolidator consolidator) throws Exception {
        methodAgrumentPartitioner = methodAgrumentPartitioner != null ? methodAgrumentPartitioner : this._methodArgumentPartitioner;
        IRPCMethodCall methodCall = this._callBuilder.BuildMethodCall(null, method, overload, isStatic, arguments, this._objectUID, methodAgrumentPartitioner, consolidator);
        return this._transport.ExecuteMethod(methodCall);
    }

    public final <TResult> TResult InvokeMultiPartitionMethod(String method, int overlaod, Object[] arguments, IResponseConsolidator consolidator) throws Exception {
        MultiPartitionMethodCall methodCall = this._callBuilder.BuildMultipartionMethodCall(method, overlaod, arguments, this._objectUID);
        methodCall.setConsolidator(consolidator);
        return this._transport.ExecuteMethod(methodCall);
    }

    @Override
    public final <TValue> void InvokePropertySetter(String property, TValue argument, IResponseConsolidator consolidator) throws Exception {
        IRPCPropertyCall propertyCall = this._callBuilder.BuildPropertySetterCall(property, argument, this._objectUID);
        propertyCall.setConsolidator(consolidator);
        this._transport.ExecuteProperty(propertyCall);
    }

    @Override
    public final <TValue> TValue InvokePropertyGetter(String property, IMethodArgumentPartitioner methodAgrumentPartitioner, IResponseConsolidator consolidator) throws Exception {
        IRPCPropertyCall propertyCall = this._callBuilder.BuildPropertyGetterCall(property, this._objectUID);
        propertyCall.setConsolidator(consolidator);
        return this._transport.ExecuteProperty(propertyCall);
    }

    @Override
    public void InitializeInstance(Object[] args) throws Exception {
        IRPCConstructorCall constructor = this._callBuilder.BuildConstructorCall(this.type.getClass(), this._objectUID, args);
        this._transport.ExecuteConstructor(constructor);
    }
}

