/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Logger;

import Alachisoft.NCache.Common.DataStructures.BridgeOpCodes;
import Alachisoft.NCache.Common.Logger.ILogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class BridgeOperationMonitor
implements Runnable {
    public ILogger _logger;
    private HashMap<BridgeOpCodes, AtomicInteger> _bridgeOperationsHistory = new HashMap();
    private HashMap<BridgeOpCodes, AtomicInteger> _failedbridgeOperationsHistory = new HashMap();
    private Thread bridgeOperationThread = new Thread(new Thread(this));

    public BridgeOperationMonitor() {
        this.bridgeOperationThread.setDaemon(true);
        this.bridgeOperationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void IncrementBridgeOperation(BridgeOpCodes opcode) {
        BridgeOperationMonitor bridgeOperationMonitor = this;
        synchronized (bridgeOperationMonitor) {
            if (!this._bridgeOperationsHistory.containsKey((Object)opcode)) {
                this._bridgeOperationsHistory.put(opcode, new AtomicInteger(0));
            }
            this._bridgeOperationsHistory.get((Object)opcode).set(this._bridgeOperationsHistory.get((Object)opcode).get() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void IncremenFailedtBridgeOperation(BridgeOpCodes opcode) {
        BridgeOperationMonitor bridgeOperationMonitor = this;
        synchronized (bridgeOperationMonitor) {
            if (!this._failedbridgeOperationsHistory.containsKey((Object)opcode)) {
                this._failedbridgeOperationsHistory.put(opcode, new AtomicInteger(0));
            }
            this._failedbridgeOperationsHistory.get((Object)opcode).set(this._failedbridgeOperationsHistory.get((Object)opcode).get() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long sleepTime = 50000L;
        while (true) {
            if (this._logger != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Operations :[");
                BridgeOperationMonitor bridgeOperationMonitor = this;
                synchronized (bridgeOperationMonitor) {
                    Iterator<Map.Entry<BridgeOpCodes, AtomicInteger>> ide = this._bridgeOperationsHistory.entrySet().iterator();
                    while (ide.hasNext()) {
                        sb.append(" ").append((Object)ide.next().getKey()).append(" = ").append(ide.next().getValue()).append(" ,");
                    }
                    sb.append("]").append(System.getProperty("line.separator"));
                    sb.append("Failed [");
                    ide = this._failedbridgeOperationsHistory.entrySet().iterator();
                    while (ide.hasNext()) {
                        sb.append(" ").append((Object)ide.next().getKey()).append(" = ").append(ide.next().getValue()).append(" ,");
                    }
                    sb.append("]").append(System.getProperty("line.separator"));
                }
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

