/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common;

import java.io.Serializable;
import java.util.HashMap;

public final class LoggingInfo
implements Serializable {
    private HashMap<LoggingType, LogsStatus> _logMap = new HashMap(2);

    public LoggingInfo() {
        this._logMap.put(LoggingType.Error, LogsStatus.Disable);
        this._logMap.put(LoggingType.Detailed, LogsStatus.Disable);
    }

    public void SetStatus(LoggingType type, LogsStatus status) {
        this._logMap.put(type, status);
    }

    public LogsStatus GetStatus(LoggingType type) {
        return LogsStatus.Disable;
    }

    public static enum LoggingType {
        Error(1),
        Detailed(2);

        private static HashMap<Integer, LoggingType> mappings;
        private int intValue;

        private LoggingType(int value) {
            this.intValue = value;
            LoggingType.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Integer, LoggingType> getMappings() {
            if (mappings != null) return mappings;
            Class<LoggingType> clazz = LoggingType.class;
            synchronized (LoggingType.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static LoggingType forValue(int value) {
            return LoggingType.getMappings().get(value);
        }

        public int getValue() {
            return this.intValue;
        }
    }

    public static enum LogsStatus {
        Disable(0),
        Enable(1);

        private static HashMap<Integer, LogsStatus> mappings;
        private int intValue;

        private LogsStatus(int value) {
            this.intValue = value;
            LogsStatus.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Integer, LogsStatus> getMappings() {
            if (mappings != null) return mappings;
            Class<LogsStatus> clazz = LogsStatus.class;
            synchronized (LogsStatus.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static LogsStatus forValue(int value) {
            return LogsStatus.getMappings().get(value);
        }

        public int getValue() {
            return this.intValue;
        }
    }

    public static enum LoggingSubsystem {
        Server,
        Client;


        public static LoggingSubsystem forValue(int value) {
            return LoggingSubsystem.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

