/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common;

import Alachisoft.NCache.Common.AttributeTypeSize;
import java.math.BigDecimal;
import java.util.Date;

public class MemoryUtil {
    public static final int KB = 1024;
    public static final int NetOverHead = 24;
    public static final int NetHashtableOverHead = 45;
    public static final int NetListOverHead = 8;
    public static final int NetClassOverHead = 16;
    public static final int NetIntSize = 4;
    public static final int NetEnumSize = 4;
    public static final int NetByteSize = 1;
    public static final int NetShortSize = 2;
    public static final int NetStringCharSize = 16;
    public static final int NetLongSize = 8;
    public static final int NetDateTimeSize = 8;
    public static final int NetReferenceSize = 8;
    public static final String Net_bool = "bool";
    public static final String Net_System_Boolean = "System.Boolean";
    public static final String Net_char = "char";
    public static final String Net_System_Char = "System.Char";
    public static final String Net_string = "string";
    public static final String Net_System_String = "System.String";
    public static final String Net_float = "float";
    public static final String Net_System_Single = "System.Single";
    public static final String Net_double = "double";
    public static final String Net_System_Double = "System.Double";
    public static final String Net_short = "short";
    public static final String Net_ushort = "ushort";
    public static final String Net_System_Int16 = "System.Int16";
    public static final String Net_System_UInt16 = "System.UInt16";
    public static final String Net_int = "int";
    public static final String Net_System_Int32 = "System.Int32";
    public static final String Net_uint = "uint";
    public static final String Net_System_UInt32 = "System.UInt32";
    public static final String Net_long = "long";
    public static final String Net_System_Int64 = "System.Int64";
    public static final String Net_ulong = "ulong";
    public static final String Net_SystemUInt64 = "System.UInt64";
    public static final String Net_byte = "byte";
    public static final String Net_System_Byte = "System.Byte";
    public static final String Net_sbyte = "sbyte";
    public static final String Net_System_SByte = "System.SByte";
    public static final String Net_System_Object = "System.Object";
    public static final String Net_System_DateTime = "System.DateTime";
    public static final String Net_decimal = "decimal";
    public static final String Net_System_Decimal = "System.Decimal";
    public static final String Java_Lang_Boolean = "java.lang.Boolean";
    public static final String Java_Lang_Character = "java.lang.Character";
    public static final String Java_Lang_String = "java.lang.String";
    public static final String Java_Lang_Float = "java.lang.Float";
    public static final String Java_Lang_Double = "java.lang.Double";
    public static final String Java_Lang_Short = "java.lang.Short";
    public static final String Java_Lang_Integer = "java.lang.Integer";
    public static final String Java_Lang_Long = "java.lang.Long";
    public static final String Java_Lang_Byte = "java.lang.Byte";
    public static final String Java_Lang_Object = "java.lang.Object";
    public static final String Java_Util_Date = "java.util.Date";
    public static final String Java_Match_BigDecimal = "java.math.BigDecimal";

    public static int getStringSize(Object key) {
        if (key != null && key instanceof String) {
            return 2 * ((String)key).length() + 24;
        }
        return 0;
    }

    public static int getStringSizeWithoutNetOverhead(Object arg) {
        if (arg != null && arg instanceof String) {
            return 2 * ((String)arg).length();
        }
        return 0;
    }

    public static int getStringSize(Object[] keys) {
        int totalSize = 0;
        if (keys != null) {
            for (Object key : keys) {
                totalSize += 2 * ((String)key).length() + 24;
            }
        }
        return totalSize;
    }

    public static int getTypeSize(AttributeTypeSize type) {
        switch (type) {
            case Byte1: {
                return 1;
            }
            case Byte2: {
                return 2;
            }
            case Byte4: {
                return 4;
            }
            case Byte8: {
                return 8;
            }
            case Byte16: {
                return 16;
            }
        }
        return 0;
    }

    public static AttributeTypeSize getAttributeTypeSize(String type) {
        if (Net_bool.equals(type) || Net_byte.equals(type) || Net_System_Byte.equals(type) || Net_sbyte.equals(type) || Net_System_SByte.equals(type) || Net_System_Boolean.equals(type) || Java_Lang_Boolean.equals(type) || Java_Lang_Byte.equals(type)) {
            return AttributeTypeSize.Byte1;
        }
        if (Net_char.equals(type) || Net_short.equals(type) || Net_ushort.equals(type) || Net_System_Int16.equals(type) || Net_System_UInt16.equals(type) || Net_System_Char.equals(type) || Java_Lang_Character.equals(type) || Java_Lang_Float.equals(type) || Java_Lang_Short.equals(type)) {
            return AttributeTypeSize.Byte2;
        }
        if (Net_float.equals(type) || Net_int.equals(type) || Net_System_Int32.equals(type) || Net_uint.equals(type) || Net_System_UInt32.equals(type) || Net_System_Single.equals(type) || Java_Lang_Integer.equals(type)) {
            return AttributeTypeSize.Byte4;
        }
        if (Net_double.equals(type) || Net_System_Double.equals(type) || Net_long.equals(type) || Net_System_Int64.equals(type) || Net_ulong.equals(type) || Net_System_DateTime.equals(type) || Net_SystemUInt64.equals(type) || Java_Lang_Double.equals(type) || Java_Lang_Long.equals(type) || Java_Util_Date.equals(type)) {
            return AttributeTypeSize.Byte8;
        }
        if (Net_decimal.equals(type) || Net_System_Decimal.equals(type) || Java_Match_BigDecimal.equals(type)) {
            return AttributeTypeSize.Byte16;
        }
        return AttributeTypeSize.Variable;
    }

    public static Class<?> getDataType(String typeName) {
        if (Net_string.equals(typeName)) {
            return String.class;
        }
        if (Net_System_String.equals(typeName)) {
            return String.class;
        }
        if (Java_Lang_String.equals(typeName)) {
            return String.class;
        }
        if (Net_bool.equals(typeName)) {
            return Boolean.class;
        }
        if (Net_byte.equals(typeName)) {
            return Byte.class;
        }
        if (Net_System_Byte.equals(typeName)) {
            return Byte.class;
        }
        if (Net_sbyte.equals(typeName)) {
            return Byte.class;
        }
        if (Net_System_SByte.equals(typeName)) {
            return Byte.class;
        }
        if (Net_System_Boolean.equals(typeName)) {
            return Boolean.class;
        }
        if (Java_Lang_Boolean.equals(typeName)) {
            return Boolean.class;
        }
        if (Java_Lang_Byte.equals(typeName)) {
            return Byte.class;
        }
        if (Net_char.equals(typeName)) {
            return Character.class;
        }
        if (Net_short.equals(typeName)) {
            return Short.class;
        }
        if (Net_ushort.equals(typeName)) {
            return Short.class;
        }
        if (Net_System_Int16.equals(typeName)) {
            return Short.class;
        }
        if (Net_System_UInt16.equals(typeName)) {
            return Short.class;
        }
        if (Net_System_Char.equals(typeName)) {
            return Character.class;
        }
        if (Java_Lang_Character.equals(typeName)) {
            return Character.class;
        }
        if (Java_Lang_Float.equals(typeName)) {
            return Float.class;
        }
        if (Java_Lang_Short.equals(typeName)) {
            return Short.class;
        }
        if (Net_float.equals(typeName)) {
            return Float.class;
        }
        if (Net_int.equals(typeName)) {
            return Integer.class;
        }
        if (Net_System_Int32.equals(typeName)) {
            return Integer.class;
        }
        if (Net_uint.equals(typeName)) {
            return Integer.class;
        }
        if (Net_System_UInt32.equals(typeName)) {
            return Integer.class;
        }
        if (Net_System_Single.equals(typeName)) {
            return Float.class;
        }
        if (Java_Lang_Integer.equals(typeName)) {
            return Integer.class;
        }
        if (Net_double.equals(typeName)) {
            return Double.class;
        }
        if (Net_System_Double.equals(typeName)) {
            return Double.class;
        }
        if (Net_long.equals(typeName)) {
            return Long.class;
        }
        if (Net_System_Int64.equals(typeName)) {
            return Long.class;
        }
        if (Net_ulong.equals(typeName)) {
            return Long.class;
        }
        if (Net_System_DateTime.equals(typeName)) {
            return Date.class;
        }
        if (Net_SystemUInt64.equals(typeName)) {
            return Long.class;
        }
        if (Java_Lang_Double.equals(typeName)) {
            return Double.class;
        }
        if (Java_Lang_Long.equals(typeName)) {
            return Long.class;
        }
        if (Java_Util_Date.equals(typeName)) {
            return Date.class;
        }
        if (Net_decimal.equals(typeName)) {
            return BigDecimal.class;
        }
        if (Net_System_Decimal.equals(typeName)) {
            return BigDecimal.class;
        }
        if (Java_Match_BigDecimal.equals(typeName)) {
            return BigDecimal.class;
        }
        return null;
    }

    public static int getInMemoryInstanceSize(int actualDataBytes) {
        int temp = 16;
        short remainder = (short)(actualDataBytes & 7);
        if (remainder != 0) {
            remainder = (short)(8 - remainder);
        }
        return temp += actualDataBytes + remainder;
    }

    public static long getInMemoryInstanceSize(long actualDataBytes) {
        long temp = 16L;
        short remainder = (short)(actualDataBytes & 7L);
        if (remainder != 0) {
            remainder = (short)(8 - remainder);
        }
        return temp += actualDataBytes + (long)remainder;
    }

    public static int getSafeByteCollectionCount(long length) {
        return length > 81920L ? 81920 : (int)length;
    }
}

