/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Messaging;

import Alachisoft.NCache.Common.Enum.SubscriptionType;
import Alachisoft.NCache.Common.Messaging.MessageFailureReason;
import Alachisoft.NCache.Common.Messaging.SubscriptionIdentifier;
import Alachisoft.NCache.Common.Messaging.SubscriptionListener;
import com.alachisoft.ncache.runtime.caching.DeliveryOption;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class MessageMetaData
implements Cloneable,
ICompactSerializable {
    private String _messageId;
    private HashSet<String> _recepientList;
    private HashSet<SubscriptionListener> _subscriptons;
    private HashSet<SubscriptionIdentifier> _durableSubscriptions;
    private ArrayList<SubscriptionIdentifier> _recipientIdentifierList;
    private Object _mutex = new Object();
    private long privateExpirationTime;
    private double privateTimeToLive;
    private Date privateAssigmentTime;
    private String privateTopicName;
    private DeliveryOption privateDeliveryOption;
    private boolean privateIsAssigned;
    private boolean privateIsNotify;
    private MessageFailureReason privateMessageFailureReason;
    private SubscriptionType privateSubscriptionType;
    private Date privateAbsoluteExpiratoinTime;
    private boolean privateDeliveryFailed;
    private boolean privateEverAcknowledged;

    public MessageMetaData(String messageId) {
        this._messageId = messageId;
        this._recepientList = new HashSet();
        this._subscriptons = new HashSet();
        this._durableSubscriptions = new HashSet();
        this._recipientIdentifierList = new ArrayList();
    }

    public MessageMetaData() {
        this._recepientList = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HashSet<String> getRecepientList() {
        Object object = this._mutex;
        synchronized (object) {
            return this._recepientList;
        }
    }

    public final String getMessageId() {
        return this._messageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HashSet<SubscriptionListener> getSubscriptions() {
        Object object = this._mutex;
        synchronized (object) {
            return this._subscriptons;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsRemovable() {
        Object object = this._mutex;
        synchronized (object) {
            return this._recepientList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddDurableSubscription(SubscriptionIdentifier subIdentifier) {
        Object object = this._mutex;
        synchronized (object) {
            if (!this._durableSubscriptions.contains(subIdentifier)) {
                this._durableSubscriptions.add(subIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HashSet<SubscriptionIdentifier> GetDurableSubscriptions() {
        HashSet<SubscriptionIdentifier> subIdList = new HashSet<SubscriptionIdentifier>();
        Object object = this._mutex;
        synchronized (object) {
            for (SubscriptionIdentifier item : this._durableSubscriptions) {
                subIdList.add((SubscriptionIdentifier)item.clone());
            }
            return subIdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddToRecepientList(SubscriptionIdentifier subscriptionIdentifier) {
        Object object = this._mutex;
        synchronized (object) {
            if (!this._recipientIdentifierList.contains(subscriptionIdentifier)) {
                this._recipientIdentifierList.add(subscriptionIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveFromReciepientList(SubscriptionIdentifier subscriptionIdentifier) {
        Object object = this._mutex;
        synchronized (object) {
            if (this._recipientIdentifierList != null) {
                this._recipientIdentifierList.remove(subscriptionIdentifier);
            }
            if (this._durableSubscriptions != null) {
                this._durableSubscriptions.remove(subscriptionIdentifier);
            }
        }
    }

    public final long getExpirationTime() {
        return this.privateExpirationTime;
    }

    public final void setExpirationTime(long value) {
        this.privateExpirationTime = value;
    }

    public final double getTimeToLive() {
        return this.privateTimeToLive;
    }

    public final void setTimeToLive(double value) {
        this.privateTimeToLive = value;
    }

    public final Date getAssigmentTime() {
        return this.privateAssigmentTime;
    }

    public final void setAssigmentTime(Date value) {
        this.privateAssigmentTime = value;
    }

    public final String getTopicName() {
        return this.privateTopicName;
    }

    public final void setTopicName(String value) {
        this.privateTopicName = value;
    }

    public final DeliveryOption getDeliveryOption() {
        return this.privateDeliveryOption;
    }

    public final void setDeliveryOption(DeliveryOption value) {
        this.privateDeliveryOption = value;
    }

    public final boolean getIsAssigned() {
        return this.privateIsAssigned;
    }

    public final void setIsAssigned(boolean value) {
        this.privateIsAssigned = value;
    }

    public final boolean getIsNotify() {
        return this.privateIsNotify;
    }

    public final void setIsNotify(boolean value) {
        this.privateIsNotify = value;
    }

    public final MessageFailureReason getMessageFailureReason() {
        return this.privateMessageFailureReason;
    }

    public final void setMessageFailureReason(MessageFailureReason value) {
        this.privateMessageFailureReason = value;
    }

    public final SubscriptionType getSubscriptionType() {
        return this.privateSubscriptionType;
    }

    public final void setSubscriptionType(SubscriptionType value) {
        this.privateSubscriptionType = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getDelivered() {
        Object object = this._mutex;
        synchronized (object) {
            if (this.getIsAssigned()) {
                return this._subscriptons.isEmpty() && this._recepientList.isEmpty() && this._durableSubscriptions.isEmpty();
            }
            return false;
        }
    }

    public final Date getAbsoluteExpiratoinTime() {
        return this.privateAbsoluteExpiratoinTime;
    }

    private void setAbsoluteExpiratoinTime(Date value) {
        this.privateAbsoluteExpiratoinTime = value;
    }

    public final boolean getDeliveryFailed() {
        return this.privateDeliveryFailed;
    }

    public final void setDeliveryFailed(boolean value) {
        this.privateDeliveryFailed = value;
    }

    public final boolean getEverAcknowledged() {
        return this.privateEverAcknowledged;
    }

    public final void setEverAcknowledged(boolean value) {
        this.privateEverAcknowledged = value;
    }

    public final boolean getHasSubscriptions() {
        return this._subscriptons.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveRecepient(String recepient) {
        Object object = this._mutex;
        synchronized (object) {
            this._recepientList.remove(recepient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddRecepient(String recepient) {
        Object object = this._mutex;
        synchronized (object) {
            this._recepientList.add(recepient);
        }
    }

    public final ArrayList<SubscriptionIdentifier> getSubscriptionIdentifierList() {
        return this._recipientIdentifierList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RegisterSubscription(SubscriptionListener subscriptionListener) {
        Object object = this._mutex;
        synchronized (object) {
            if (!this._subscriptons.contains(subscriptionListener)) {
                if (this.getAssigmentTime() == null) {
                    this.setAssigmentTime(NCDateTime.getUTCNow());
                }
                this.setIsAssigned(true);
                this._subscriptons.add(subscriptionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void UnregisterSubscription(SubscriptionListener subscriptionListener) {
        Object object = this._mutex;
        synchronized (object) {
            if (this._subscriptons.contains(subscriptionListener)) {
                this._subscriptons.remove(subscriptionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object clone() {
        Object object = this._mutex;
        synchronized (object) {
            MessageMetaData metaData = new MessageMetaData(this.getMessageId());
            metaData.setTimeToLive(this.getTimeToLive());
            metaData.setAssigmentTime(this.getAssigmentTime());
            metaData.setTopicName(this.getTopicName());
            metaData.setDeliveryOption(this.getDeliveryOption());
            metaData.setMessageFailureReason(this.getMessageFailureReason());
            metaData.setSubscriptionType(this.getSubscriptionType());
            metaData.setIsAssigned(this.getIsAssigned());
            metaData.setIsNotify(this.getIsNotify());
            metaData.setAbsoluteExpiratoinTime(this.getAbsoluteExpiratoinTime());
            metaData.setEverAcknowledged(this.getEverAcknowledged());
            metaData.setExpirationTime(this.getExpirationTime());
            metaData._recepientList = new HashSet<String>(this.getRecepientList());
            metaData._subscriptons = new HashSet<SubscriptionListener>(this._subscriptons);
            metaData._durableSubscriptions = new HashSet<SubscriptionIdentifier>(this._durableSubscriptions);
            metaData._recipientIdentifierList = new ArrayList<SubscriptionIdentifier>(this._recipientIdentifierList);
            return metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date InitializeExpiration() {
        Object object = this._mutex;
        synchronized (object) {
            NCDateTime dateTime = new NCDateTime(NCDateTime.getUTCNow());
            dateTime.addTicks(this.getExpirationTime());
            this.setAbsoluteExpiratoinTime(dateTime.getDate());
            return this.getAbsoluteExpiratoinTime();
        }
    }

    public final void OnMessageRemoved() {
        this.RevokeSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RevokeSubscriptions() {
        Object object = this._mutex;
        synchronized (object) {
            for (SubscriptionListener clientSubscriptionListener : this._subscriptons) {
                clientSubscriptionListener.OnMessageRemoved(this.getMessageId());
            }
            this._subscriptons.clear();
            this._recepientList.clear();
        }
    }

    public final void RevokeSubscriptions(SubscriptionListener subscriptionListener) {
        if (this._subscriptons.contains(subscriptionListener)) {
            subscriptionListener.OnMessageRemoved(this.getMessageId());
        }
    }

    public void serialize(NCacheObjectOutput out) throws IOException {
    }

    public void deserialize(NCacheObjectInput in) throws IOException, ClassNotFoundException {
    }
}

